/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export;

import com.atlassian.jira.migration.analytics.crossproject.service.CrossProjectEntityStatsEventService;
import com.atlassian.jira.migration.export.CrossProjectExportStrategy;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.plan.DashboardsMigrationMode;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageManager;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/export/AllDashboardsExportStrategy;", "Lcom/atlassian/jira/migration/export/CrossProjectExportStrategy;", "Lcom/atlassian/jira/migration/plan/DashboardsMigrationMode;", "portalPageManager", "Lcom/atlassian/jira/portal/PortalPageManager;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "crossProjectEntityStatsEventService", "Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;", "(Lcom/atlassian/jira/portal/PortalPageManager;Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;)V", "export", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "getExportMode", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAllDashboardsExportStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllDashboardsExportStrategy.kt\ncom/atlassian/jira/migration/export/AllDashboardsExportStrategy\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,66:1\n17#2,6:67\n*S KotlinDebug\n*F\n+ 1 AllDashboardsExportStrategy.kt\ncom/atlassian/jira/migration/export/AllDashboardsExportStrategy\n*L\n30#1:67,6\n*E\n"})
public final class AllDashboardsExportStrategy
extends CrossProjectExportStrategy<DashboardsMigrationMode> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PortalPageManager portalPageManager;
    @NotNull
    private final ExportService exportService;
    @NotNull
    private static final Logger log;

    @Inject
    public AllDashboardsExportStrategy(@NotNull PortalPageManager portalPageManager, @NotNull ExportService exportService, @NotNull CrossProjectEntityStatsEventService crossProjectEntityStatsEventService) {
        Intrinsics.checkNotNullParameter((Object)portalPageManager, (String)"portalPageManager");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)crossProjectEntityStatsEventService, (String)"crossProjectEntityStatsEventService");
        super(crossProjectEntityStatsEventService);
        this.portalPageManager = portalPageManager;
        this.exportService = exportService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        log.info("MigrationId: " + ctx.getMigrationId() + " : Started exporting all dashboards under export mode " + (Object)((Object)ctx.getExportMode()));
        Long timeTakenInMillisToExportDashboards = null;
        Ref.LongRef totalDashboards = new Ref.LongRef();
        Ref.LongRef totalDashboardsExported = new Ref.LongRef();
        try {
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            this.portalPageManager.getAll().foreach(arg_0 -> AllDashboardsExportStrategy.export$lambda$1$lambda$0(totalDashboards, this, ctx, totalDashboardsExported, arg_0));
            timeTakenInMillisToExportDashboards = System.currentTimeMillis() - start$iv;
        }
        catch (Exception ex) {
            try {
                log.error("Exporting all dashboards failed with error " + ex);
                throw ex;
            }
            catch (Throwable throwable) {
                this.sendDashboardsExportTimeEvent(timeTakenInMillisToExportDashboards, totalDashboardsExported.element, totalDashboards.element, this.getExportMode(), ctx);
                throw throwable;
            }
        }
        this.sendDashboardsExportTimeEvent(timeTakenInMillisToExportDashboards, totalDashboardsExported.element, totalDashboards.element, this.getExportMode(), ctx);
        log.info("MigrationId: " + ctx.getMigrationId() + " : Completed exporting all dashboards under export mode " + (Object)((Object)ctx.getExportMode()));
    }

    @Override
    @NotNull
    public DashboardsMigrationMode getExportMode() {
        return DashboardsMigrationMode.ALL;
    }

    private static final void export$lambda$1$lambda$0(Ref.LongRef $totalDashboards, AllDashboardsExportStrategy this$0, ExportContext $ctx, Ref.LongRef $totalDashboardsExported, PortalPage it) {
        Intrinsics.checkNotNullParameter((Object)$totalDashboards, (String)"$totalDashboards");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
        Intrinsics.checkNotNullParameter((Object)$totalDashboardsExported, (String)"$totalDashboardsExported");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.isSystemDefaultPortalPage()) {
            log.debug("Exporting of dashboard '" + it.getName() + "' with id " + it.getId() + " started");
            ++$totalDashboards.element;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this$0.exportService, $ctx, it, false, 4, null);
            log.debug("Exporting of dashboard '" + it.getName() + "' with id " + it.getId() + " completed successfully");
            ++$totalDashboardsExported.element;
        }
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(AllDashboardsExportStrategy.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/export/AllDashboardsExportStrategy$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

