/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export;

import com.atlassian.jira.migration.amcyclient.AmcyClient;
import com.atlassian.jira.migration.amcyclient.VendorConfigDto;
import com.atlassian.jira.migration.export.ExportOutcome;
import com.atlassian.jira.migration.export.apps.AOTableEntityExporter;
import com.atlassian.jira.migration.orchestratorclient.tasks.AppEntitiesTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import java.io.File;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/export/AppEntitiesExportService;", "", "aoTableEntityExporter", "Lcom/atlassian/jira/migration/export/apps/AOTableEntityExporter;", "amcyClient", "Lcom/atlassian/jira/migration/amcyclient/AmcyClient;", "(Lcom/atlassian/jira/migration/export/apps/AOTableEntityExporter;Lcom/atlassian/jira/migration/amcyclient/AmcyClient;)V", "exportAppEntities", "Lcom/atlassian/jira/migration/export/ExportOutcome;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppEntitiesExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppEntitiesExportService.kt\ncom/atlassian/jira/migration/export/AppEntitiesExportService\n+ 2 Optionals.kt\nkotlin/jvm/optionals/OptionalsKt\n*L\n1#1,51:1\n30#2:52\n*S KotlinDebug\n*F\n+ 1 AppEntitiesExportService.kt\ncom/atlassian/jira/migration/export/AppEntitiesExportService\n*L\n23#1:52\n*E\n"})
public final class AppEntitiesExportService {
    @NotNull
    private final AOTableEntityExporter aoTableEntityExporter;
    @NotNull
    private final AmcyClient amcyClient;

    @Inject
    public AppEntitiesExportService(@NotNull AOTableEntityExporter aoTableEntityExporter, @NotNull AmcyClient amcyClient) {
        Intrinsics.checkNotNullParameter((Object)aoTableEntityExporter, (String)"aoTableEntityExporter");
        Intrinsics.checkNotNullParameter((Object)amcyClient, (String)"amcyClient");
        this.aoTableEntityExporter = aoTableEntityExporter;
        this.amcyClient = amcyClient;
    }

    @NotNull
    public final ExportOutcome exportAppEntities(@NotNull PrcTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        MigrationTask migrationTask = task.getMigrationTask();
        Intrinsics.checkNotNull((Object)migrationTask, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.AppEntitiesTask");
        AppEntitiesTask appEntityTask = (AppEntitiesTask)migrationTask;
        Optional<VendorConfigDto> vendorConfigOptional = this.amcyClient.getVendorConfigForCloudAppKey(appEntityTask.getServerAppKey(), appEntityTask.getCloudAppKey(), task.getCloudId());
        boolean bl = false;
        Optional<VendorConfigDto> $this$getOrElse$iv = vendorConfigOptional;
        boolean $i$f$getOrElse = false;
        if (!$this$getOrElse$iv.isPresent()) {
            boolean bl2 = false;
            throw new IllegalStateException("Vendor config not found for cloud app key " + appEntityTask.getCloudAppKey());
        }
        VendorConfigDto vendorConfig = $this$getOrElse$iv.get();
        File outFile = this.aoTableEntityExporter.extractDataToFile(vendorConfig, task.getMigrationId());
        return new ExportOutcome(outFile);
    }
}

