/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export;

import com.atlassian.jira.migration.export.CrossProjectExportStrategy;
import com.atlassian.jira.migration.export.CrossProjectExportStrategyManager;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.plan.CrossProjectConfig;
import com.atlassian.jira.migration.plan.CrossProjectExportConfig;
import com.atlassian.jira.migration.plan.DashboardsMigrationMode;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/export/DashboardExportService;", "", "crossProjectExportStrategyManager", "Lcom/atlassian/jira/migration/export/CrossProjectExportStrategyManager;", "(Lcom/atlassian/jira/migration/export/CrossProjectExportStrategyManager;)V", "export", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "getDashboardMigrationMode", "Lcom/atlassian/jira/migration/plan/DashboardsMigrationMode;", "Companion", "jira-migration-plugin"})
public final class DashboardExportService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CrossProjectExportStrategyManager crossProjectExportStrategyManager;
    @NotNull
    private static final Logger log;

    @Inject
    public DashboardExportService(@NotNull CrossProjectExportStrategyManager crossProjectExportStrategyManager) {
        Intrinsics.checkNotNullParameter((Object)crossProjectExportStrategyManager, (String)"crossProjectExportStrategyManager");
        this.crossProjectExportStrategyManager = crossProjectExportStrategyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void export(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        long startTime = System.currentTimeMillis();
        try {
            CrossProjectExportStrategy<DashboardsMigrationMode> dashboardExportStrategy;
            CrossProjectExportStrategy<DashboardsMigrationMode> crossProjectExportStrategy = dashboardExportStrategy = this.crossProjectExportStrategyManager.getDashboardExportStrategy(this.getDashboardMigrationMode(ctx));
            if (crossProjectExportStrategy != null) {
                crossProjectExportStrategy.export(ctx);
            }
        }
        finally {
            log.info("migrationId: " + ctx.getMigrationId() + " : Dashboard export finished in " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }

    private final DashboardsMigrationMode getDashboardMigrationMode(ExportContext ctx) {
        DashboardsMigrationMode dashboardsMigrationMode;
        CrossProjectExportConfig crossProjectExportConfig;
        CrossProjectConfig crossProjectConfig = ctx.getCrossProjectConfig();
        return crossProjectConfig != null && (crossProjectExportConfig = crossProjectConfig.getCrossProjectExportConfig()) != null && (dashboardsMigrationMode = crossProjectExportConfig.getDashboardsMigrationMode()) != null ? dashboardsMigrationMode : DashboardsMigrationMode.NONE;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(DashboardExportService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/export/DashboardExportService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

