/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export;

import com.atlassian.jira.migration.events.IssueExportStatistics;
import java.io.File;
import java.nio.file.Files;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/export/DataExportOutcome;", "Ljava/lang/AutoCloseable;", "file", "Ljava/io/File;", "deletedUserKeys", "", "", "exportedEntities", "", "(Ljava/io/File;Ljava/util/Set;I)V", "statistics", "Lcom/atlassian/jira/migration/events/IssueExportStatistics;", "(Ljava/io/File;Ljava/util/Set;ILcom/atlassian/jira/migration/events/IssueExportStatistics;)V", "getDeletedUserKeys", "()Ljava/util/Set;", "getExportedEntities", "()I", "getFile", "()Ljava/io/File;", "getStatistics", "()Lcom/atlassian/jira/migration/events/IssueExportStatistics;", "close", "", "Companion", "jira-migration-plugin"})
public final class DataExportOutcome
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @NotNull
    private final Set<String> deletedUserKeys;
    private final int exportedEntities;
    @Nullable
    private final IssueExportStatistics statistics;
    private static final Logger log = LoggerFactory.getLogger(DataExportOutcome.class);

    public DataExportOutcome(@NotNull File file2, @NotNull Set<String> deletedUserKeys2, int exportedEntities, @Nullable IssueExportStatistics statistics) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(deletedUserKeys2, (String)"deletedUserKeys");
        this.file = file2;
        this.deletedUserKeys = deletedUserKeys2;
        this.exportedEntities = exportedEntities;
        this.statistics = statistics;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final Set<String> getDeletedUserKeys() {
        return this.deletedUserKeys;
    }

    public final int getExportedEntities() {
        return this.exportedEntities;
    }

    @Nullable
    public final IssueExportStatistics getStatistics() {
        return this.statistics;
    }

    public DataExportOutcome(@NotNull File file2, @NotNull Set<String> deletedUserKeys2, int exportedEntities) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(deletedUserKeys2, (String)"deletedUserKeys");
        this(file2, deletedUserKeys2, exportedEntities, null);
    }

    @Override
    public void close() {
        try {
            Files.deleteIfExists(this.file.toPath());
        }
        catch (Exception exception) {
            log.error("Could not delete file " + this.file.getAbsolutePath() + ". Will attempt to delete on JVM exit.", (Throwable)exception);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/DataExportOutcome$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

