/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export;

import com.atlassian.jira.migration.analytics.ReconEventHandler;
import com.atlassian.jira.migration.duplicates.model.CloudIdEntityType;
import com.atlassian.jira.migration.events.ReconEvent;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.externalMapping.model.ExternalEntity;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.preflight.reports.ComparisonType;
import com.atlassian.jira.migration.recon.service.ReconService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.MRIParser;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/export/DuplicateMappingExporterService;", "", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "reconService", "Lcom/atlassian/jira/migration/recon/service/ReconService;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "reconEventHandler", "Lcom/atlassian/jira/migration/analytics/ReconEventHandler;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/recon/service/ReconService;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/analytics/ReconEventHandler;)V", "exportDuplicateMappings", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "planId", "", "cloudId", "getExectionId", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDuplicateMappingExporterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicateMappingExporterService.kt\ncom/atlassian/jira/migration/export/DuplicateMappingExporterService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,51:1\n215#2,2:52\n*S KotlinDebug\n*F\n+ 1 DuplicateMappingExporterService.kt\ncom/atlassian/jira/migration/export/DuplicateMappingExporterService\n*L\n39#1:52,2\n*E\n"})
public final class DuplicateMappingExporterService {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ReconService reconService;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ReconEventHandler reconEventHandler;

    @Inject
    public DuplicateMappingExporterService(@NotNull ExportService exportService, @NotNull ReconService reconService, @NotNull PlanRepository planRepository, @NotNull MigrationFeatures migrationFeatures, @NotNull ReconEventHandler reconEventHandler) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)reconService, (String)"reconService");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)reconEventHandler, (String)"reconEventHandler");
        this.exportService = exportService;
        this.reconService = reconService;
        this.planRepository = planRepository;
        this.migrationFeatures = migrationFeatures;
        this.reconEventHandler = reconEventHandler;
    }

    public final void exportDuplicateMappings(@NotNull ExportContext ctx, @NotNull String planId, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        if (!this.migrationFeatures.getEnableReconMigrationFlow()) {
            return;
        }
        String executionId = this.getExectionId(planId);
        this.reconEventHandler.sendReconEvent(new ReconEvent(cloudId2, executionId, ReconEvent.STATE.START_RECON.getValue(), ReconEvent.STATUS.CREATED.getValue(), null, 0L, 48, null));
        this.reconService.readDuplicateConfigEntitiesFileAndCreateCache(executionId, cloudId2);
        Map<String, CloudIdEntityType> map = this.reconService.getDuplicateEntityReconCache().get((Object)ComparisonType.SERVER_TO_CLOUD);
        if (map != null) {
            Map<String, CloudIdEntityType> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, CloudIdEntityType>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, CloudIdEntityType> element$iv;
                Map.Entry<String, CloudIdEntityType> entry = element$iv = iterator2.next();
                boolean bl = false;
                String serverId = entry.getKey();
                CloudIdEntityType cloudIdEntityType = entry.getValue();
                MRI mri = MRIParser.INSTANCE.parse(serverId);
                String entityType = mri.getNamespace() + ':' + mri.getEntityType();
                ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, new ExternalEntity(entityType, mri.getEntityId(), cloudIdEntityType.getCloudId(), false, 8, null), false, 4, null);
            }
        }
        this.reconEventHandler.sendReconEvent(new ReconEvent(cloudId2, executionId, ReconEvent.STATE.START_RECON.getValue(), ReconEvent.STATUS.SUCCESS.getValue(), null, 0L, 48, null));
    }

    private final String getExectionId(String planId) {
        Object object = this.planRepository.get(planId);
        if (object == null || (object = ((Plan)object).getPreflightCheckExecutionId()) == null) {
            object = "";
        }
        return object;
    }
}

