/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export;

import com.atlassian.jira.migration.analytics.crossproject.service.CrossProjectEntityStatsEventService;
import com.atlassian.jira.migration.export.CrossProjectExportStrategy;
import com.atlassian.jira.migration.export.core.portalpage.DashboardsExtractionHelper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.DashboardsMigrationMode;
import com.atlassian.jira.portal.PortalPage;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/export/SelectedProjectsDashboardExportStrategy;", "Lcom/atlassian/jira/migration/export/CrossProjectExportStrategy;", "Lcom/atlassian/jira/migration/plan/DashboardsMigrationMode;", "dashboardsExtractionHelper", "Lcom/atlassian/jira/migration/export/core/portalpage/DashboardsExtractionHelper;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "crossProjectEntityStatsEventService", "Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;", "(Lcom/atlassian/jira/migration/export/core/portalpage/DashboardsExtractionHelper;Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;)V", "export", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "getExportMode", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nSelectedProjectsDashboardExportStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectedProjectsDashboardExportStrategy.kt\ncom/atlassian/jira/migration/export/SelectedProjectsDashboardExportStrategy\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n17#2,5:83\n22#2:90\n1855#3,2:88\n*S KotlinDebug\n*F\n+ 1 SelectedProjectsDashboardExportStrategy.kt\ncom/atlassian/jira/migration/export/SelectedProjectsDashboardExportStrategy\n*L\n36#1:83,5\n36#1:90\n43#1:88,2\n*E\n"})
public final class SelectedProjectsDashboardExportStrategy
extends CrossProjectExportStrategy<DashboardsMigrationMode> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DashboardsExtractionHelper dashboardsExtractionHelper;
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private static final Logger log;

    @Inject
    public SelectedProjectsDashboardExportStrategy(@NotNull DashboardsExtractionHelper dashboardsExtractionHelper, @NotNull ExportService exportService, @NotNull MigrationFeatures migrationFeatures, @NotNull CrossProjectEntityStatsEventService crossProjectEntityStatsEventService) {
        Intrinsics.checkNotNullParameter((Object)dashboardsExtractionHelper, (String)"dashboardsExtractionHelper");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)crossProjectEntityStatsEventService, (String)"crossProjectEntityStatsEventService");
        super(crossProjectEntityStatsEventService);
        this.dashboardsExtractionHelper = dashboardsExtractionHelper;
        this.exportService = exportService;
        this.migrationFeatures = migrationFeatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void export(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        log.debug("Feature Flag for Scoped Dashboards Mode is currently " + (this.migrationFeatures.getEnableScopedDashboardsFeature() ? "ENABLED" : "DISABLED"));
        if (!this.migrationFeatures.getEnableScopedDashboardsFeature()) return;
        log.info("MigrationId: " + ctx.getMigrationId() + " : Started exporting dashboards referencing selected project ids " + ctx.getProjectIds() + " under export mode " + (Object)((Object)ctx.getExportMode()));
        Long timeTakenInMillisToExportDashboards = null;
        long totalDashboards = 0L;
        long totalDashboardsExported = 0L;
        try {
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            List<PortalPage> allPortalPages = this.dashboardsExtractionHelper.getAllPortalPages();
            List<PortalPage> listOfScopedDashboards = this.dashboardsExtractionHelper.getDashboardsReferringSelectedProjects(ctx.getProjectIds(), allPortalPages);
            totalDashboards = listOfScopedDashboards.size();
            Iterable $this$forEach$iv = listOfScopedDashboards;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PortalPage it = (PortalPage)element$iv;
                boolean bl2 = false;
                log.debug("Exporting of dashboard '" + it.getName() + "' with id " + it.getId() + " started");
                ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
                ++totalDashboardsExported;
                log.debug("Exporting of dashboard '" + it.getName() + "' with id " + it.getId() + " completed successfully");
            }
            timeTakenInMillisToExportDashboards = System.currentTimeMillis() - start$iv;
        }
        catch (Exception ex) {
            try {
                log.error("Exporting scoped dashboards failed with error " + ex);
                throw ex;
            }
            catch (Throwable throwable) {
                try {
                    this.sendDashboardsExportTimeEvent(timeTakenInMillisToExportDashboards, totalDashboardsExported, totalDashboards, this.getExportMode(), ctx);
                    log.debug("Successfully sent dashboards export time event for MigrationId: " + ctx.getMigrationId() + '.');
                    throw throwable;
                }
                catch (Exception e) {
                    log.debug("Failed to send dashboards export time event", (Throwable)e);
                }
                throw throwable;
            }
        }
        try {
            this.sendDashboardsExportTimeEvent(timeTakenInMillisToExportDashboards, totalDashboardsExported, totalDashboards, this.getExportMode(), ctx);
            log.debug("Successfully sent dashboards export time event for MigrationId: " + ctx.getMigrationId() + '.');
        }
        catch (Exception e) {
            log.debug("Failed to send dashboards export time event", (Throwable)e);
        }
        log.info("MigrationId: " + ctx.getMigrationId() + " : Completed exporting dashboards referencing selected project ids " + ctx.getProjectIds() + " under export mode " + (Object)((Object)ctx.getExportMode()));
    }

    @Override
    @NotNull
    public DashboardsMigrationMode getExportMode() {
        return DashboardsMigrationMode.SELECTED_PROJECTS;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(SelectedProjectsDashboardExportStrategy.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/export/SelectedProjectsDashboardExportStrategy$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

