/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.advancedroadmaps;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.migration.export.advancedroadmaps.IssueSourceServiceKt;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsIssueSourceData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.IssueSourceDataReader;
import com.atlassian.jira.migration.export.db.advancedroadmaps.IssueSourceType;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migrationservice.CachedProjectMigratedService;
import com.atlassian.jira.migration.serverdataextractors.RelatedEntitiesDataReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0011\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0018\u001a\u00020\u0019J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\b\b\u0002\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00100&2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001c\u001a\u00020\u001dJ\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u000fJ\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u000fJ\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00102\u0006\u0010\u001c\u001a\u00020\u001dJ2\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u000f2\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010-\u001a\u00020 H\u0002J\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u000fJ\u001c\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u000fJ\u001c\u00100\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u000fJ\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u000fJ\u0016\u00102\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00103\u001a\u00020\u000fJ\u0016\u00104\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u000fJ\u000e\u00106\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dR-\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/atlassian/jira/migration/export/advancedroadmaps/IssueSourceService;", "", "cachedProjectMigratedService", "Lcom/atlassian/jira/migration/migrationservice/CachedProjectMigratedService;", "relatedEntitiesDataReader", "Lcom/atlassian/jira/migration/serverdataextractors/RelatedEntitiesDataReader;", "issueSourceDataReader", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/IssueSourceDataReader;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/migrationservice/CachedProjectMigratedService;Lcom/atlassian/jira/migration/serverdataextractors/RelatedEntitiesDataReader;Lcom/atlassian/jira/migration/export/db/advancedroadmaps/IssueSourceDataReader;Lcom/atlassian/cache/CacheManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "arPlanIssueSourceCache", "Lcom/atlassian/cache/Cache;", "", "", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/AdvancedRoadmapsIssueSourceData;", "getArPlanIssueSourceCache", "()Lcom/atlassian/cache/Cache;", "arPlanIssueSourceCache$delegate", "Lkotlin/Lazy;", "log", "Lorg/slf4j/Logger;", "clearCache", "", "filterIssueSources", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "issueSources", "migratable", "", "filterIssueSourcesByProject", "sourceValue", "", "getAllMigratableIssueSources", "getAllMissingProjectIdsFromPlansMap", "", "getAllNonMigratableIssueSources", "getAllProjectsIdsFromAllIssueSources", "planId", "getAllProjectsIdsFromIssueSources", "getAllScopedProjectIdsFromPlans", "getIssueSources", "skipFiltering", "getMigratableIssueSources", "getMissingProjectsIdsFromIssueSources", "getNonMigratableIssueSources", "getScopedProjectsIdsFromIssueSources", "isIssueSourceMigrating", "issueSourceId", "isProjectInScope", "projectId", "loadAllMigratableIssueSourcesForPlans", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nIssueSourceService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssueSourceService.kt\ncom/atlassian/jira/migration/export/advancedroadmaps/IssueSourceService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,138:1\n1855#2,2:139\n1549#2:141\n1620#2,3:142\n1549#2:145\n1620#2,3:146\n766#2:149\n857#2,2:150\n766#2:152\n857#2,2:153\n1549#2:155\n1620#2,3:156\n1271#2,2:159\n1285#2,4:161\n1747#2,3:172\n766#2:175\n857#2,2:176\n494#3,7:165\n*S KotlinDebug\n*F\n+ 1 IssueSourceService.kt\ncom/atlassian/jira/migration/export/advancedroadmaps/IssueSourceService\n*L\n49#1:139,2\n73#1:141\n73#1:142,3\n78#1:145\n78#1:146,3\n93#1:149\n93#1:150,2\n98#1:152\n98#1:153,2\n101#1:155\n101#1:156,3\n104#1:159,2\n104#1:161,4\n109#1:172,3\n112#1:175\n112#1:176,2\n105#1:165,7\n*E\n"})
public final class IssueSourceService {
    @NotNull
    private final CachedProjectMigratedService cachedProjectMigratedService;
    @NotNull
    private final RelatedEntitiesDataReader relatedEntitiesDataReader;
    @NotNull
    private final IssueSourceDataReader issueSourceDataReader;
    @NotNull
    private final CacheManager cacheManager;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final Logger log;
    @NotNull
    private final Lazy arPlanIssueSourceCache$delegate;

    @Inject
    public IssueSourceService(@NotNull CachedProjectMigratedService cachedProjectMigratedService, @NotNull RelatedEntitiesDataReader relatedEntitiesDataReader, @NotNull IssueSourceDataReader issueSourceDataReader, @NotNull CacheManager cacheManager, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)cachedProjectMigratedService, (String)"cachedProjectMigratedService");
        Intrinsics.checkNotNullParameter((Object)relatedEntitiesDataReader, (String)"relatedEntitiesDataReader");
        Intrinsics.checkNotNullParameter((Object)issueSourceDataReader, (String)"issueSourceDataReader");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.cachedProjectMigratedService = cachedProjectMigratedService;
        this.relatedEntitiesDataReader = relatedEntitiesDataReader;
        this.issueSourceDataReader = issueSourceDataReader;
        this.cacheManager = cacheManager;
        this.migrationFeatures = migrationFeatures;
        Logger logger2 = LoggerFactory.getLogger(IssueSourceService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
        this.arPlanIssueSourceCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Cache<Long, Set<? extends AdvancedRoadmapsIssueSourceData>>>(this){
            final /* synthetic */ IssueSourceService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Cache<Long, Set<AdvancedRoadmapsIssueSourceData>> invoke() {
                return IssueSourceService.access$getCacheManager$p(this.this$0).getCache("AR_PLAN_ISSUE_SOURCE_CACHE", null, new CacheSettingsBuilder().expireAfterAccess(2L, IssueSourceServiceKt.access$getCACHE_TIME_UNIT$p()).remote().build());
            }
        }));
    }

    private final Cache<Long, Set<AdvancedRoadmapsIssueSourceData>> getArPlanIssueSourceCache() {
        Lazy lazy = this.arPlanIssueSourceCache$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Cache)object;
    }

    public final void loadAllMigratableIssueSourcesForPlans(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.clearCache();
        this.log.info("migrationId: " + ctx.getMigrationId() + " : Loading all migratable issue sources for plans: " + ctx.getAdvancedRoadmapsIds());
        Iterable $this$forEach$iv = ctx.getAdvancedRoadmapsIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long planId = ((Number)element$iv).longValue();
            boolean bl = false;
            this.getMigratableIssueSources(ctx, planId);
        }
    }

    public final void clearCache() {
        this.getArPlanIssueSourceCache().removeAll();
        this.cachedProjectMigratedService.clearCache();
    }

    @NotNull
    public final Set<AdvancedRoadmapsIssueSourceData> getMigratableIssueSources(@NotNull ExportContext ctx, long planId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object object2 = this;
        try {
            IssueSourceService $this$getMigratableIssueSources_u24lambda_u242 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)((Set)$this$getMigratableIssueSources_u24lambda_u242.getArPlanIssueSourceCache().get((Object)planId, () -> IssueSourceService.getMigratableIssueSources$lambda$2$lambda$1($this$getMigratableIssueSources_u24lambda_u242, ctx, planId))));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e = object = throwable;
            boolean bl = false;
            this.log.error("Error while getting issue sources for plan " + planId, (Throwable)e);
        }
        object = SetsKt.emptySet();
        return (Set)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    @NotNull
    public final Set<AdvancedRoadmapsIssueSourceData> getNonMigratableIssueSources(@NotNull ExportContext ctx, long planId) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return CollectionsKt.toSet((Iterable)IssueSourceService.getIssueSources$default(this, ctx, planId, false, false, 8, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<AdvancedRoadmapsIssueSourceData> getAllMigratableIssueSources(@NotNull ExportContext ctx) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Iterable $this$map$iv = ctx.getAdvancedRoadmapsIds();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            long l = ((Number)item$iv$iv).longValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getMigratableIssueSources(ctx, (long)it));
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<AdvancedRoadmapsIssueSourceData> getAllNonMigratableIssueSources(@NotNull ExportContext ctx) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Iterable $this$map$iv = ctx.getAdvancedRoadmapsIds();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            long l = ((Number)item$iv$iv).longValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getNonMigratableIssueSources(ctx, (long)it));
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
    }

    @NotNull
    public final Set<Long> getAllProjectsIdsFromIssueSources(@NotNull ExportContext ctx, long planId) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this.relatedEntitiesDataReader.getAllProjectIdsFromIssueSources(CollectionsKt.toList((Iterable)this.getMigratableIssueSources(ctx, planId)));
    }

    @NotNull
    public final Set<Long> getAllProjectsIdsFromAllIssueSources(@NotNull ExportContext ctx, long planId) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this.relatedEntitiesDataReader.getAllProjectIdsFromIssueSources(CollectionsKt.toList((Iterable)IssueSourceService.getIssueSources$default(this, ctx, planId, false, true, 4, null)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Long> getScopedProjectsIdsFromIssueSources(@NotNull ExportContext ctx, long planId) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Set projectIds = this.getAllProjectsIdsFromIssueSources(ctx, planId);
        boolean bl = false;
        if (this.migrationFeatures.getEnableArPhasedFeature() && ctx.getAdvancedRoadmapsMigrationMode() != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = projectIds;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                long it = ((Number)element$iv$iv).longValue();
                boolean bl2 = false;
                if (!this.isProjectInScope(ctx, it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            set = projectIds;
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Long> getMissingProjectsIdsFromIssueSources(@NotNull ExportContext ctx, long planId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Iterable $this$filter$iv = this.getAllProjectsIdsFromAllIssueSources(ctx, planId);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            long it = ((Number)element$iv$iv).longValue();
            boolean bl = false;
            if (!(!this.isProjectInScope(ctx, it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Long> getAllScopedProjectIdsFromPlans(@NotNull ExportContext ctx) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Iterable $this$map$iv = ctx.getAdvancedRoadmapsIds();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            long l = ((Number)item$iv$iv).longValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getScopedProjectsIdsFromIssueSources(ctx, (long)it));
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Long, Set<Long>> getAllMissingProjectIdsFromPlansMap(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Iterable $this$associateWith$iv = ctx.getAdvancedRoadmapsIds();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            long l = ((Number)element$iv$iv).longValue();
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Set<Long> set = this.getMissingProjectsIdsFromIssueSources(ctx, (long)it);
            map.put(t, set);
        }
        Map $this$filterValues$iv = result$iv;
        boolean $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            Set it = (Set)entry$iv.getValue();
            boolean bl = false;
            boolean bl2 = !((Collection)it).isEmpty();
            if (!bl2) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isIssueSourceMigrating(@NotNull ExportContext ctx, long issueSourceId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (!this.migrationFeatures.getEnableArPhasedFeature()) return true;
        Iterable $this$any$iv = this.getAllMigratableIssueSources(ctx);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            AdvancedRoadmapsIssueSourceData it = (AdvancedRoadmapsIssueSourceData)element$iv;
            boolean bl2 = false;
            if (it.getId() == issueSourceId) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AdvancedRoadmapsIssueSourceData> filterIssueSources(@NotNull ExportContext ctx, @NotNull List<AdvancedRoadmapsIssueSourceData> issueSources, boolean migratable) {
        List list;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(issueSources, (String)"issueSources");
        Iterable $this$filter$iv = issueSources;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String string;
            String sourceValue;
            String string2;
            String sourceType;
            AdvancedRoadmapsIssueSourceData issueSource = (AdvancedRoadmapsIssueSourceData)element$iv$iv;
            boolean bl = false;
            String string3 = issueSource.getSourceType();
            if (string3 == null) {
                string3 = sourceType = "";
            }
            if ((string2 = issueSource.getSourceValue()) == null) {
                string2 = sourceValue = "";
            }
            boolean bl2 = Intrinsics.areEqual((Object)(string = sourceType), (Object)IssueSourceType.PROJECT.getValue()) ? this.filterIssueSourcesByProject(ctx, sourceValue) == migratable : (Intrinsics.areEqual((Object)string, (Object)IssueSourceType.FILTER.getValue()) ? true : Intrinsics.areEqual((Object)string, (Object)IssueSourceType.BOARD.getValue()));
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        this.log.info("Filtered " + (migratable ? "migratable" : "non-migratable") + " issue sources for migration " + ctx.getMigrationId() + " under exportMode " + (Object)((Object)ctx.getExportMode()));
        return list;
    }

    public static /* synthetic */ List filterIssueSources$default(IssueSourceService issueSourceService, ExportContext exportContext, List list, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return issueSourceService.filterIssueSources(exportContext, list, bl);
    }

    private final List<AdvancedRoadmapsIssueSourceData> getIssueSources(ExportContext ctx, long planId, boolean migratable, boolean skipFiltering) {
        List<AdvancedRoadmapsIssueSourceData> it = this.issueSourceDataReader.getAllExistentIssueSourcesForPlan(planId);
        boolean bl = false;
        return !this.migrationFeatures.getEnableArPhasedFeature() || ctx.getAdvancedRoadmapsMigrationMode() == null || skipFiltering ? it : this.filterIssueSources(ctx, it, migratable);
    }

    static /* synthetic */ List getIssueSources$default(IssueSourceService issueSourceService, ExportContext exportContext, long l, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return issueSourceService.getIssueSources(exportContext, l, bl, bl2);
    }

    private final boolean filterIssueSourcesByProject(ExportContext ctx, String sourceValue) {
        return this.isProjectInScope(ctx, Long.parseLong(sourceValue));
    }

    public final boolean isProjectInScope(@NotNull ExportContext ctx, long projectId) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return ctx.getProjectIds().contains(projectId) || this.cachedProjectMigratedService.isProjectMigrated(projectId, ctx.getMigrationTaskMetadata().getContainerToken());
    }

    private static final Set getMigratableIssueSources$lambda$2$lambda$1(IssueSourceService $this_runCatching, ExportContext $ctx, long $planId) {
        Intrinsics.checkNotNullParameter((Object)$this_runCatching, (String)"$this_runCatching");
        Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
        $this_runCatching.log.info("migrationId: " + $ctx.getMigrationId() + " : Loading migratable issue sources for plan " + $planId);
        return CollectionsKt.toSet((Iterable)IssueSourceService.getIssueSources$default($this_runCatching, $ctx, $planId, false, false, 12, null));
    }

    public static final /* synthetic */ CacheManager access$getCacheManager$p(IssueSourceService $this) {
        return $this.cacheManager;
    }
}

