/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.advancedroadmaps;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.migration.db.EntityPropertyTable;
import com.atlassian.jira.migration.db.JiraIssueTable;
import com.atlassian.jira.migration.export.advancedroadmaps.ParentLink;
import com.atlassian.jira.migration.export.advancedroadmaps.ParentLinkData;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/export/advancedroadmaps/ParentLinkValueReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "getAllParentLinksForProject", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/export/advancedroadmaps/ParentLinkData;", "projectId", "", "Companion", "jira-migration-plugin"})
public final class ParentLinkValueReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private static final ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private static final Logger log = LoggerFactory.getLogger(ParentLinkValueReader.class);

    @Inject
    public ParentLinkValueReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    @NotNull
    public final Sequence<ParentLinkData> getAllParentLinksForProject(long projectId) {
        log.debug("Executing db query for fetching all parentLinks for project {}", (Object)projectId);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> ParentLinkValueReader.getAllParentLinksForProject$lambda$0(projectId, arg_0), OnRollback.NOOP);
            Sequence it = (Sequence)object;
            boolean bl = false;
            log.debug("Successfully fetched all parentLinks for project {}", (Object)projectId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (Sequence)object2;
        }
        catch (QueryException ex) {
            log.error("Exception occurred while fetching parentLinks associated with project {}: {}", (Object)projectId, (Object)ex.getMessage());
            throw ex;
        }
    }

    private static final Sequence getAllParentLinksForProject$lambda$0(long $projectId, DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{EntityPropertyTable.INSTANCE.getENTITY_ID(), EntityPropertyTable.INSTANCE.getJSON_VALUE()};
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)EntityPropertyTable.INSTANCE)).innerJoin((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).on((Predicate)EntityPropertyTable.INSTANCE.getENTITY_ID().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()));
        expressionArray = new Predicate[]{JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().eq((Object)$projectId), EntityPropertyTable.INSTANCE.getPROPERTY_KEY().eq((Object)"jpo-issue-properties"), EntityPropertyTable.INSTANCE.getENTITY_NAME().eq((Object)EntityPropertyType.ISSUE_PROPERTY.getDbEntityName())};
        List list = ((SQLQuery)sQLQuery.where((Predicate[])expressionArray)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<Tuple, ParentLinkData>((Object)Companion){

            @Nullable
            public final ParentLinkData invoke(@NotNull Tuple p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).buildParentLinkData(p0);
            }
        }));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/export/advancedroadmaps/ParentLinkValueReader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "buildParentLinkData", "Lcom/atlassian/jira/migration/export/advancedroadmaps/ParentLinkData;", "row", "Lcom/querydsl/core/Tuple;", "jira-migration-plugin"})
    @SourceDebugExtension(value={"SMAP\nParentLinkValueReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParentLinkValueReader.kt\ncom/atlassian/jira/migration/export/advancedroadmaps/ParentLinkValueReader$Companion\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n58#2:79\n51#2:80\n1#3:81\n*S KotlinDebug\n*F\n+ 1 ParentLinkValueReader.kt\ncom/atlassian/jira/migration/export/advancedroadmaps/ParentLinkValueReader$Companion\n*L\n68#1:79\n68#1:80\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        @Nullable
        public final ParentLinkData buildParentLinkData(@NotNull Tuple row) {
            ParentLinkData parentLinkData;
            void $this$readValue$iv;
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            ObjectMapper objectMapper2 = mapper;
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"access$getMapper$cp(...)");
            Object object = objectMapper2;
            Object object2 = row.get((Expression)EntityPropertyTable.INSTANCE.getJSON_VALUE());
            Intrinsics.checkNotNull((Object)object2);
            String content$iv = (String)object2;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            object = $this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<ParentLink>(){});
            ParentLink it = (ParentLink)object;
            boolean bl = false;
            String string = it.getParentId();
            ParentLink parentLink = (ParentLink)((string != null ? StringsKt.toLongOrNull((String)string) : null) != null ? object : null);
            if (parentLink != null) {
                ParentLink $this$buildParentLinkData_u24lambda_u241 = parentLink;
                boolean bl2 = false;
                Object object3 = row.get((Expression)EntityPropertyTable.INSTANCE.getENTITY_ID());
                Intrinsics.checkNotNull((Object)object3);
                long l = ((Number)object3).longValue();
                String string2 = $this$buildParentLinkData_u24lambda_u241.getParentId();
                Intrinsics.checkNotNull((Object)string2);
                Long l2 = StringsKt.toLongOrNull((String)string2);
                Intrinsics.checkNotNull((Object)l2);
                parentLinkData = new ParentLinkData(l, l2);
            } else {
                parentLinkData = null;
            }
            return parentLinkData;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

