/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.advancedroadmaps;

import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsPersonData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsResourceData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.ResourceDataReader;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.advancedroadmaps.Person;
import com.atlassian.migration.jira.advancedroadmaps.Team;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0002H\u0016J\b\u0010!\u001a\u00020\u0018H\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/export/advancedroadmaps/PersonExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/AdvancedRoadmapsPersonData;", "Lcom/atlassian/migration/jira/advancedroadmaps/Person;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "resourceDataReader", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/ResourceDataReader;", "entityIdentifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/db/advancedroadmaps/ResourceDataReader;Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapJiraUser", "Lcom/atlassian/migration/base/mri/MRI;", "mapTeamIdsFromResources", "", "person", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPersonExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersonExporter.kt\ncom/atlassian/jira/migration/export/advancedroadmaps/PersonExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1#2:99\n1#2:110\n1603#3,9:100\n1855#3:109\n1856#3:111\n1612#3:112\n*S KotlinDebug\n*F\n+ 1 PersonExporter.kt\ncom/atlassian/jira/migration/export/advancedroadmaps/PersonExporter\n*L\n75#1:110\n75#1:100,9\n75#1:109\n75#1:111\n75#1:112\n*E\n"})
public final class PersonExporter
implements Exporter<Long, AdvancedRoadmapsPersonData, Person> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ResourceDataReader resourceDataReader;
    @NotNull
    private final EntityIdentifierGenerator entityIdentifierGenerator;
    private final Logger log;
    @NotNull
    private final ExporterKey key;

    @Inject
    public PersonExporter(@NotNull ExportService exportService, @NotNull ResourceDataReader resourceDataReader, @NotNull EntityIdentifierGenerator entityIdentifierGenerator) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)resourceDataReader, (String)"resourceDataReader");
        Intrinsics.checkNotNullParameter((Object)entityIdentifierGenerator, (String)"entityIdentifierGenerator");
        this.exportService = exportService;
        this.resourceDataReader = resourceDataReader;
        this.entityIdentifierGenerator = entityIdentifierGenerator;
        this.log = LoggerFactory.getLogger(PersonExporter.class);
        this.key = new ExporterKey(Person.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, AdvancedRoadmapsPersonData.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull AdvancedRoadmapsPersonData entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(Person.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public Person exportData(@NotNull ExportContext ctx, @NotNull AdvancedRoadmapsPersonData entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.info("Exporting personEntity with id {} for migration {} under exportMode {}", objectArray);
        objectArray = this.mriForEntity(entity);
        Set<MRI> set = this.mapTeamIdsFromResources(ctx, entity);
        MRI mRI = this.mapJiraUser(ctx, entity);
        return new Person((MRI)objectArray, mRI, set);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull AdvancedRoadmapsPersonData entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting users and groups for advancedRoadmapsPersonData {} for migration {} under exportMode {}", objectArray);
        this.mapJiraUser(ctx, entity);
    }

    private final MRI mapJiraUser(ExportContext ctx, AdvancedRoadmapsPersonData entity) {
        UserRef userRef;
        block3: {
            block2: {
                userRef = UserRef.Companion.fromString(entity.getJiraUserId());
                if (userRef == null) break block2;
                UserRef it = userRef;
                boolean bl = false;
                MRI mRI = this.exportService.userRef(ctx, it);
                userRef = mRI;
                if (mRI != null) break block3;
            }
            MRI mRI = this.mriForEntity(entity);
            String string = EntityIdentifierGenerator.generate$default(this.entityIdentifierGenerator, this.mriForEntity(entity), entity, null, 4, null) + " has no jira user associated.";
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_PERSON_HAS_NO_USER;
            throw new ExportException(mRI, exportErrorCode, string, "Please specify a jira user for this person.", null, null, null, 112, null);
        }
        return userRef;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<MRI> mapTeamIdsFromResources(ExportContext ctx, AdvancedRoadmapsPersonData person) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List<AdvancedRoadmapsResourceData> resources = this.resourceDataReader.getResourcesForPerson(person.getId());
        Iterable iterable = resources;
        boolean $i$f$mapNotNull = false;
        ExportErrorCode exportErrorCode = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MRI mRI;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            AdvancedRoadmapsResourceData resource = (AdvancedRoadmapsResourceData)element$iv$iv;
            boolean bl2 = false;
            Long l = resource.getTeamId();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl3 = false;
                ExportService.CheckExportedResult checkResult = this.exportService.checkExported(ctx, Team.Companion.getEntityType(), it);
                mRI = checkResult.isExported() ? checkResult.getMri() : null;
            } else {
                mRI = null;
            }
            if (mRI == null) continue;
            MRI it$iv$iv = mRI;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set exportedTeams = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (exportedTeams.isEmpty()) {
            iterable = this.mriForEntity(person);
            String string = EntityIdentifierGenerator.generate$default(this.entityIdentifierGenerator, this.mriForEntity(person), person, null, 4, null) + " does not belong to any teams or doesn't have any related teams exported.";
            exportErrorCode = ExportErrorCode.PRJ_PERSON_HAS_NO_TEAM;
            throw new ExportException((MRI)iterable, exportErrorCode, string, "Please either add this person to a team or export the related teams first.", null, null, null, 112, null);
        }
        return exportedTeams;
    }

    @Override
    @Nullable
    public AdvancedRoadmapsPersonData extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull AdvancedRoadmapsPersonData entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

