/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.advancedroadmaps;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.migration.db.EntityPropertyTable;
import com.atlassian.jira.migration.db.JiraIssueTable;
import com.atlassian.jira.migration.export.advancedroadmaps.TeamCustomFieldValue;
import com.atlassian.jira.migration.export.advancedroadmaps.TeamCustomFieldValueData;
import com.atlassian.jira.migration.export.advancedroadmaps.TeamData;
import com.atlassian.jira.migration.export.db.querydsl.QuerydslHelpersKt;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.support.QueryBase;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/export/advancedroadmaps/TeamCustomFieldValueReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "getAllTeamCustomFieldValues", "", "Lcom/atlassian/jira/migration/export/advancedroadmaps/TeamCustomFieldValue;", "getAllTeamCustomFieldValuesForProject", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/export/advancedroadmaps/TeamCustomFieldValueData;", "projectId", "", "getAllTeamCustomFieldValuesForProjectIds", "projectIds", "Companion", "jira-migration-plugin"})
public final class TeamCustomFieldValueReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private static final ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private static final Logger log = LoggerFactory.getLogger(TeamCustomFieldValueReader.class);

    @Inject
    public TeamCustomFieldValueReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    @NotNull
    public final Sequence<TeamCustomFieldValueData> getAllTeamCustomFieldValuesForProject(long projectId) {
        log.debug("Executing db query for fetching all teamCustomFieldValues for project {}", (Object)projectId);
        try {
            Object object = this.databaseAccessor.run(arg_0 -> TeamCustomFieldValueReader.getAllTeamCustomFieldValuesForProject$lambda$0(projectId, arg_0), OnRollback.NOOP);
            Sequence it = (Sequence)object;
            boolean bl = false;
            log.debug("Successfully fetched all teamCustomFieldValues for project {}", (Object)projectId);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (Sequence)object2;
        }
        catch (QueryException ex) {
            log.error("Exception occurred while fetching teamCustomFieldValues associated with project {}: {}", (Object)projectId, (Object)ex.getMessage());
            throw ex;
        }
    }

    @NotNull
    public final Sequence<TeamCustomFieldValueData> getAllTeamCustomFieldValuesForProjectIds(@NotNull List<Long> projectIds) {
        Intrinsics.checkNotNullParameter(projectIds, (String)"projectIds");
        try {
            log.debug("Executing db query for fetching all teamCustomFieldValues associated with projects {}", projectIds);
            Object object = this.databaseAccessor.run(arg_0 -> TeamCustomFieldValueReader.getAllTeamCustomFieldValuesForProjectIds$lambda$2(projectIds, arg_0), OnRollback.NOOP);
            Sequence it = (Sequence)object;
            boolean bl = false;
            log.debug("Successfully fetched all teamCustomFieldValues associated with projects {}", projectIds);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (Sequence)object2;
        }
        catch (QueryException ex) {
            log.error("Exception occurred while fetching teamCustomFieldValues associated with projectIds {}: {}", projectIds, (Object)ex.getMessage());
            throw ex;
        }
    }

    @NotNull
    public final List<TeamCustomFieldValue> getAllTeamCustomFieldValues() {
        try {
            log.debug("Executing db query for fetching all teamCustomFieldValues");
            Object object = this.databaseAccessor.run(TeamCustomFieldValueReader::getAllTeamCustomFieldValues$lambda$4, OnRollback.NOOP);
            List it = (List)object;
            boolean bl = false;
            log.debug("Successfully fetched all teamCustomFieldValues");
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (List)object2;
        }
        catch (QueryException ex) {
            log.error("Exception occurred while fetching teamCustomFieldValues: {}", (Object)ex.getMessage());
            throw ex;
        }
    }

    private static final Sequence getAllTeamCustomFieldValuesForProject$lambda$0(long $projectId, DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{EntityPropertyTable.INSTANCE.getENTITY_ID(), EntityPropertyTable.INSTANCE.getJSON_VALUE()};
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)EntityPropertyTable.INSTANCE)).innerJoin((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).on((Predicate)EntityPropertyTable.INSTANCE.getENTITY_ID().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()));
        expressionArray = new Predicate[]{JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().eq((Object)$projectId), EntityPropertyTable.INSTANCE.getPROPERTY_KEY().eq((Object)"jpo-issue-properties"), EntityPropertyTable.INSTANCE.getENTITY_NAME().eq((Object)EntityPropertyType.ISSUE_PROPERTY.getDbEntityName())};
        List list = ((SQLQuery)sQLQuery.where((Predicate[])expressionArray)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<Tuple, TeamCustomFieldValueData>((Object)Companion){

            @Nullable
            public final TeamCustomFieldValueData invoke(@NotNull Tuple p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).buildTeamCustomFieldValueData(p0);
            }
        }));
    }

    private static final Sequence getAllTeamCustomFieldValuesForProjectIds$lambda$2(List $projectIds, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$projectIds, (String)"$projectIds");
        Expression[] expressionArray = new Expression[]{EntityPropertyTable.INSTANCE.getENTITY_ID(), EntityPropertyTable.INSTANCE.getJSON_VALUE()};
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)EntityPropertyTable.INSTANCE)).innerJoin((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).on((Predicate)EntityPropertyTable.INSTANCE.getENTITY_ID().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()));
        expressionArray = new Predicate[]{JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().in((Collection)$projectIds), EntityPropertyTable.INSTANCE.getPROPERTY_KEY().eq((Object)"jpo-issue-properties"), EntityPropertyTable.INSTANCE.getENTITY_NAME().eq((Object)EntityPropertyType.ISSUE_PROPERTY.getDbEntityName())};
        QueryBase queryBase = sQLQuery.where((Predicate[])expressionArray);
        Intrinsics.checkNotNullExpressionValue((Object)queryBase, (String)"where(...)");
        List list = QuerydslHelpersKt.useLiteralsInsteadOfQueryParameters((SQLQuery)queryBase).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<Tuple, TeamCustomFieldValueData>((Object)Companion){

            @Nullable
            public final TeamCustomFieldValueData invoke(@NotNull Tuple p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).buildTeamCustomFieldValueData(p0);
            }
        }));
    }

    private static final List getAllTeamCustomFieldValues$lambda$4(DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{EntityPropertyTable.INSTANCE.getENTITY_ID(), EntityPropertyTable.INSTANCE.getJSON_VALUE(), JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT()};
        QueryBase queryBase = ((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)EntityPropertyTable.INSTANCE)).innerJoin((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).on((Predicate)EntityPropertyTable.INSTANCE.getENTITY_ID().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()))).where((Predicate)EntityPropertyTable.INSTANCE.getPROPERTY_KEY().eq((Object)"jpo-issue-properties").and((Predicate)EntityPropertyTable.INSTANCE.getENTITY_NAME().eq((Object)EntityPropertyType.ISSUE_PROPERTY.getDbEntityName())));
        Intrinsics.checkNotNullExpressionValue((Object)queryBase, (String)"where(...)");
        CloseableIterator closeableIterator = QuerydslHelpersKt.useLiteralsInsteadOfQueryParameters((SQLQuery)queryBase).iterate();
        Intrinsics.checkNotNullExpressionValue((Object)closeableIterator, (String)"iterate(...)");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)((Iterator)closeableIterator)), (Function1)((Function1)new Function1<Tuple, TeamCustomFieldValue>((Object)Companion){

            @Nullable
            public final TeamCustomFieldValue invoke(@NotNull Tuple p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).buildTeamCustomFieldValue(p0);
            }
        })));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/export/advancedroadmaps/TeamCustomFieldValueReader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "buildTeamCustomFieldValue", "Lcom/atlassian/jira/migration/export/advancedroadmaps/TeamCustomFieldValue;", "row", "Lcom/querydsl/core/Tuple;", "buildTeamCustomFieldValueData", "Lcom/atlassian/jira/migration/export/advancedroadmaps/TeamCustomFieldValueData;", "jira-migration-plugin"})
    @SourceDebugExtension(value={"SMAP\nTeamCustomFieldValueReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamCustomFieldValueReader.kt\ncom/atlassian/jira/migration/export/advancedroadmaps/TeamCustomFieldValueReader$Companion\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n58#2:162\n51#2:163\n58#2:165\n51#2:166\n1#3:164\n*S KotlinDebug\n*F\n+ 1 TeamCustomFieldValueReader.kt\ncom/atlassian/jira/migration/export/advancedroadmaps/TeamCustomFieldValueReader$Companion\n*L\n139#1:162\n139#1:163\n151#1:165\n151#1:166\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final TeamCustomFieldValue buildTeamCustomFieldValue(@NotNull Tuple row) {
            TeamCustomFieldValue teamCustomFieldValue;
            void $this$readValue$iv;
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            ObjectMapper objectMapper2 = mapper;
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"access$getMapper$cp(...)");
            Object object = objectMapper2;
            Object object2 = row.get((Expression)EntityPropertyTable.INSTANCE.getJSON_VALUE());
            Intrinsics.checkNotNull((Object)object2);
            String content$iv = (String)object2;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            object = $this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<TeamData>(){});
            TeamData it = (TeamData)object;
            boolean bl = false;
            String string = it.getTeamId();
            TeamData teamData = (TeamData)((string != null ? StringsKt.toLongOrNull((String)string) : null) != null ? object : null);
            if (teamData != null) {
                TeamData $this$buildTeamCustomFieldValue_u24lambda_u241 = teamData;
                boolean bl2 = false;
                String string2 = $this$buildTeamCustomFieldValue_u24lambda_u241.getTeamId();
                Intrinsics.checkNotNull((Object)string2);
                Long l = StringsKt.toLongOrNull((String)string2);
                Intrinsics.checkNotNull((Object)l);
                long l2 = l;
                Object object3 = row.get((Expression)EntityPropertyTable.INSTANCE.getENTITY_ID());
                Intrinsics.checkNotNull((Object)object3);
                long l3 = ((Number)object3).longValue();
                Object object4 = row.get((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT());
                Intrinsics.checkNotNull((Object)object4);
                teamCustomFieldValue = new TeamCustomFieldValue(l2, l3, ((Number)object4).longValue());
            } else {
                teamCustomFieldValue = null;
            }
            return teamCustomFieldValue;
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        @Nullable
        public final TeamCustomFieldValueData buildTeamCustomFieldValueData(@NotNull Tuple row) {
            TeamCustomFieldValueData teamCustomFieldValueData;
            void $this$readValue$iv;
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            ObjectMapper objectMapper2 = mapper;
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"access$getMapper$cp(...)");
            Object object = objectMapper2;
            Object object2 = row.get((Expression)EntityPropertyTable.INSTANCE.getJSON_VALUE());
            Intrinsics.checkNotNull((Object)object2);
            String content$iv = (String)object2;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            object = $this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<TeamData>(){});
            TeamData it = (TeamData)object;
            boolean bl = false;
            String string = it.getTeamId();
            TeamData teamData = (TeamData)((string != null ? StringsKt.toLongOrNull((String)string) : null) != null ? object : null);
            if (teamData != null) {
                TeamData $this$buildTeamCustomFieldValueData_u24lambda_u243 = teamData;
                boolean bl2 = false;
                String string2 = $this$buildTeamCustomFieldValueData_u24lambda_u243.getTeamId();
                Intrinsics.checkNotNull((Object)string2);
                Long l = StringsKt.toLongOrNull((String)string2);
                Intrinsics.checkNotNull((Object)l);
                long l2 = l;
                Object object3 = row.get((Expression)EntityPropertyTable.INSTANCE.getENTITY_ID());
                Intrinsics.checkNotNull((Object)object3);
                teamCustomFieldValueData = new TeamCustomFieldValueData(l2, ((Number)object3).longValue());
            } else {
                teamCustomFieldValueData = null;
            }
            return teamCustomFieldValueData;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

