/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.advancedroadmaps;

import com.atlassian.jira.migration.export.advancedroadmaps.IssueSourceService;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsPlanTeamData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsPlannedCapacityData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsTeamAndPlanTeamData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.PlannedCapacityDataReader;
import com.atlassian.jira.migration.export.db.advancedroadmaps.ResourceDataReader;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.advancedroadmaps.EstimationUnit;
import com.atlassian.migration.jira.advancedroadmaps.IssueSource;
import com.atlassian.migration.jira.advancedroadmaps.Plan;
import com.atlassian.migration.jira.advancedroadmaps.PlanTeam;
import com.atlassian.migration.jira.advancedroadmaps.PlannedCapacity;
import com.atlassian.migration.jira.advancedroadmaps.SchedulingMode;
import com.atlassian.migration.jira.advancedroadmaps.Team;
import com.atlassian.migration.jira.classic.software.sprint.Sprint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 /2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001/B'\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001f2\u0006\u0010!\u001a\u00020\u00032\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u0002H\u0016J\b\u0010)\u001a\u00020*H\u0007J7\u0010+\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010&\u0012\u0006\u0012\u0004\u0018\u00010\u00020,2\u0006\u0010-\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0002\u0010.R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/atlassian/jira/migration/export/advancedroadmaps/TeamExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/AdvancedRoadmapsTeamAndPlanTeamData;", "Lcom/atlassian/migration/jira/advancedroadmaps/Team;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "plannedCapacityDataReader", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PlannedCapacityDataReader;", "resourceDataReader", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/ResourceDataReader;", "issueSourceService", "Lcom/atlassian/jira/migration/export/advancedroadmaps/IssueSourceService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PlannedCapacityDataReader;Lcom/atlassian/jira/migration/export/db/advancedroadmaps/ResourceDataReader;Lcom/atlassian/jira/migration/export/advancedroadmaps/IssueSourceService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "convertEstimationUnit", "Lcom/atlassian/migration/jira/advancedroadmaps/EstimationUnit;", "teamId", "value", "", "convertSchedulingMode", "Lcom/atlassian/migration/jira/advancedroadmaps/SchedulingMode;", "(Ljava/lang/Long;)Lcom/atlassian/migration/jira/advancedroadmaps/SchedulingMode;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "mapPlanTeams", "", "Lcom/atlassian/migration/jira/advancedroadmaps/PlanTeam;", "teamAndPlanTeam", "mapPlannedCapacities", "Lcom/atlassian/migration/jira/advancedroadmaps/PlannedCapacity;", "planTeams", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "", "resolveIteration", "Lkotlin/Pair;", "schedulingMode", "(Lcom/atlassian/migration/jira/advancedroadmaps/SchedulingMode;JLjava/lang/Long;)Lkotlin/Pair;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nTeamExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamExporter.kt\ncom/atlassian/jira/migration/export/advancedroadmaps/TeamExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1855#2:166\n1549#2:167\n1620#2,3:168\n1856#2:171\n1549#2:172\n1620#2,3:173\n*S KotlinDebug\n*F\n+ 1 TeamExporter.kt\ncom/atlassian/jira/migration/export/advancedroadmaps/TeamExporter\n*L\n82#1:166\n85#1:167\n85#1:168,3\n82#1:171\n138#1:172\n138#1:173,3\n*E\n"})
public final class TeamExporter
implements Exporter<Long, AdvancedRoadmapsTeamAndPlanTeamData, Team> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final PlannedCapacityDataReader plannedCapacityDataReader;
    @NotNull
    private final ResourceDataReader resourceDataReader;
    @NotNull
    private final IssueSourceService issueSourceService;
    @NotNull
    private final ExporterKey key;
    @NotNull
    private static final Logger log;

    @Inject
    public TeamExporter(@NotNull ExportService exportService, @NotNull PlannedCapacityDataReader plannedCapacityDataReader, @NotNull ResourceDataReader resourceDataReader, @NotNull IssueSourceService issueSourceService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)plannedCapacityDataReader, (String)"plannedCapacityDataReader");
        Intrinsics.checkNotNullParameter((Object)resourceDataReader, (String)"resourceDataReader");
        Intrinsics.checkNotNullParameter((Object)issueSourceService, (String)"issueSourceService");
        this.exportService = exportService;
        this.plannedCapacityDataReader = plannedCapacityDataReader;
        this.resourceDataReader = resourceDataReader;
        this.issueSourceService = issueSourceService;
        this.key = new ExporterKey(Team.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, AdvancedRoadmapsTeamAndPlanTeamData.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull AdvancedRoadmapsTeamAndPlanTeamData entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getTeamData().getId());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(Team.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public Team exportData(@NotNull ExportContext ctx, @NotNull AdvancedRoadmapsTeamAndPlanTeamData entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{ctx.getMigrationId(), entity.getTeamData().getId(), ctx.getExportMode()};
        log.info("[MigrationId:{}] Exporting TeamEntity with id:{} under exportMode:{}", objectArray);
        Set<PlanTeam> mappedPlanTeams = this.mapPlanTeams(entity, ctx);
        MRI mRI = this.mriForEntity(entity);
        Boolean bl = entity.getTeamData().getShareable();
        if (bl == null) {
            throw new ExportException(this.mriForEntity(entity), ExportErrorCode.GENERIC_ERROR_CODE, "No shareable property for AR Team", null, null, null, null, 120, null);
        }
        boolean bl2 = bl;
        boolean bl3 = !this.resourceDataReader.resourcesExistForTeam(entity.getTeamData().getId());
        String string = entity.getTeamData().getTitle();
        if (string == null) {
            throw new ExportException(this.mriForEntity(entity), ExportErrorCode.GENERIC_ERROR_CODE, "No title for AR Team", null, null, null, null, 120, null);
        }
        String string2 = string;
        Set<PlannedCapacity> set = this.mapPlannedCapacities(entity, mappedPlanTeams);
        return new Team(mRI, string2, bl2, Boolean.valueOf(bl3), null, mappedPlanTeams, set, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<PlannedCapacity> mapPlannedCapacities(AdvancedRoadmapsTeamAndPlanTeamData teamAndPlanTeam, Set<PlanTeam> planTeams) {
        Set allPlannedCapacities = new LinkedHashSet();
        Iterable $this$forEach$iv = planTeams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            PlanTeam planTeam = (PlanTeam)element$iv;
            boolean bl = false;
            Iterable iterable = this.plannedCapacityDataReader.getPlannedCapacitiesForPlan(Long.parseLong(planTeam.getPlanId().getEntityId()));
            Set set = allPlannedCapacities;
            boolean $i$f$map = false;
            void var13_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void plannedCapacity;
                AdvancedRoadmapsPlannedCapacityData advancedRoadmapsPlannedCapacityData = (AdvancedRoadmapsPlannedCapacityData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Pair<MRI, Long> pair = this.resolveIteration(this.convertSchedulingMode(teamAndPlanTeam.getTeamData().getId(), plannedCapacity.getSchedulingMode()), teamAndPlanTeam.getTeamData().getId(), plannedCapacity.getIterationId());
                MRI iterationId = (MRI)pair.component1();
                Long iterationStart = (Long)pair.component2();
                Double d = plannedCapacity.getCapacity();
                if (d == null) {
                    throw new ExportException(MriExtensionsKt.mri$default(Team.Companion.getEntityType(), teamAndPlanTeam.getTeamData().getId(), null, 2, null), ExportErrorCode.GENERIC_ERROR_CODE, "Invalid capacity for PlannedCapacity", null, null, null, null, 120, null);
                }
                collection.add(new PlannedCapacity(planTeam.getPlanId(), this.convertSchedulingMode(teamAndPlanTeam.getTeamData().getId(), plannedCapacity.getSchedulingMode()), iterationId, iterationStart, this.convertEstimationUnit(teamAndPlanTeam.getTeamData().getId(), plannedCapacity.getPlanningUnit()), d.doubleValue()));
            }
            set.addAll((List)destination$iv$iv);
        }
        return allPlannedCapacities;
    }

    private final Pair<MRI, Long> resolveIteration(SchedulingMode schedulingMode, long teamId, Long value) {
        Pair pair;
        Long l = value;
        if (l == null) {
            throw new ExportException(MriExtensionsKt.mri$default(Team.Companion.getEntityType(), teamId, null, 2, null), ExportErrorCode.GENERIC_ERROR_CODE, "Invalid iterationId for PlannedCapacity", null, null, null, null, 120, null);
        }
        long iteration = l;
        switch (WhenMappings.$EnumSwitchMapping$0[schedulingMode.ordinal()]) {
            case 1: {
                pair = new Pair((Object)MriExtensionsKt.mri$default(Sprint.Companion.getEntityType(), iteration, null, 2, null), null);
                break;
            }
            case 2: {
                pair = new Pair(null, (Object)iteration);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pair;
    }

    private final SchedulingMode convertSchedulingMode(long teamId, String value) {
        SchedulingMode schedulingMode;
        String string = value;
        if (Intrinsics.areEqual((Object)string, (Object)"Scrum")) {
            schedulingMode = SchedulingMode.SCRUM;
        } else if (Intrinsics.areEqual((Object)string, (Object)"Kanban")) {
            schedulingMode = SchedulingMode.KANBAN;
        } else {
            throw new ExportException(MriExtensionsKt.mri$default(Team.Companion.getEntityType(), teamId, null, 2, null), ExportErrorCode.GENERIC_ERROR_CODE, "Invalid scheduling mode for PlannedCapacity", null, null, null, null, 120, null);
        }
        return schedulingMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final EstimationUnit convertEstimationUnit(long teamId, String value) {
        EstimationUnit estimationUnit;
        block6: {
            String string = value;
            if (string == null) throw new ExportException(MriExtensionsKt.mri$default(Team.Companion.getEntityType(), teamId, null, 2, null), ExportErrorCode.GENERIC_ERROR_CODE, "Invalid estimation unit for PlannedCapacity", null, null, null, null, 120, null);
            switch (string.hashCode()) {
                case 69916399: {
                    if (!string.equals("Hours")) {
                        throw new ExportException(MriExtensionsKt.mri$default(Team.Companion.getEntityType(), teamId, null, 2, null), ExportErrorCode.GENERIC_ERROR_CODE, "Invalid estimation unit for PlannedCapacity", null, null, null, null, 120, null);
                    }
                    break block6;
                }
                case 2122871: {
                    if (string.equals("Days")) break;
                    throw new ExportException(MriExtensionsKt.mri$default(Team.Companion.getEntityType(), teamId, null, 2, null), ExportErrorCode.GENERIC_ERROR_CODE, "Invalid estimation unit for PlannedCapacity", null, null, null, null, 120, null);
                }
                case 318938648: {
                    if (!string.equals("StoryPoints")) throw new ExportException(MriExtensionsKt.mri$default(Team.Companion.getEntityType(), teamId, null, 2, null), ExportErrorCode.GENERIC_ERROR_CODE, "Invalid estimation unit for PlannedCapacity", null, null, null, null, 120, null);
                    estimationUnit = EstimationUnit.STORY_POINTS;
                    return estimationUnit;
                }
            }
            estimationUnit = EstimationUnit.DAYS;
            return estimationUnit;
        }
        estimationUnit = EstimationUnit.HOURS;
        return estimationUnit;
        throw new ExportException(MriExtensionsKt.mri$default(Team.Companion.getEntityType(), teamId, null, 2, null), ExportErrorCode.GENERIC_ERROR_CODE, "Invalid estimation unit for PlannedCapacity", null, null, null, null, 120, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<PlanTeam> mapPlanTeams(AdvancedRoadmapsTeamAndPlanTeamData teamAndPlanTeam, ExportContext ctx) {
        Collection<AdvancedRoadmapsPlanTeamData> collection;
        block8: {
            block7: {
                void $this$mapTo$iv$iv;
                collection = teamAndPlanTeam.getPlanTeamData();
                if (collection == null) break block7;
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    SchedulingMode schedulingMode;
                    MRI mRI;
                    void planTeam;
                    AdvancedRoadmapsPlanTeamData advancedRoadmapsPlanTeamData = (AdvancedRoadmapsPlanTeamData)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    EntityType entityType = Plan.Companion.getEntityType();
                    Long l = planTeam.getPlanId();
                    Intrinsics.checkNotNull((Object)l);
                    MRI mRI2 = MriExtensionsKt.mri$default(entityType, l, null, 2, null);
                    Long l2 = planTeam.getIssueSourceId();
                    if (l2 != null) {
                        void it;
                        long l3 = ((Number)l2).longValue();
                        MRI mRI3 = mRI2;
                        boolean bl2 = false;
                        mRI = this.issueSourceService.isIssueSourceMigrating(ctx, (long)it) ? MriExtensionsKt.mri$default(IssueSource.Companion.getEntityType(), (long)it, null, 2, null) : null;
                        mRI2 = mRI3;
                    } else {
                        mRI = null;
                    }
                    if (this.convertSchedulingMode(planTeam.getSchedulingMode()) == null) {
                        throw new ExportException(MriExtensionsKt.mri$default(Team.Companion.getEntityType(), teamAndPlanTeam.getTeamData().getId(), null, 2, null), ExportErrorCode.GENERIC_ERROR_CODE, "Invalid scheduling mode for PlanTeam", null, null, null, null, 120, null);
                    }
                    Long l4 = planTeam.getSprintVelocity();
                    Long l5 = planTeam.getWeeklyCapacity();
                    Long l6 = planTeam.getIterationLength();
                    Double d = l5 != null ? Double.valueOf(l5.longValue()) : null;
                    Double d2 = l4 != null ? Double.valueOf(l4.longValue()) : null;
                    MRI mRI4 = mRI;
                    MRI mRI5 = mRI2;
                    collection2.add(new PlanTeam(mRI5, mRI4, schedulingMode, d2, d, l6));
                }
                collection = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                if (collection != null) break block8;
            }
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    private final SchedulingMode convertSchedulingMode(Long value) {
        Object object;
        Long l;
        Long l2 = l = value;
        long l3 = SchedulingMode.KANBAN.ordinal();
        if (l2 != null && l2 == l3) {
            object = SchedulingMode.KANBAN;
        } else {
            Long l4 = l;
            l3 = SchedulingMode.SCRUM.ordinal();
            object = l4 != null && l4 == l3 ? SchedulingMode.SCRUM : null;
        }
        return object;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull AdvancedRoadmapsTeamAndPlanTeamData entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public AdvancedRoadmapsTeamAndPlanTeamData extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull AdvancedRoadmapsTeamAndPlanTeamData entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(TeamExporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/export/advancedroadmaps/TeamExporter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SchedulingMode.values().length];
            try {
                nArray[SchedulingMode.SCRUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SchedulingMode.KANBAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

