/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.apps;

import com.atlassian.jira.migration.amcyclient.VendorConfigDto;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.db.AppDataTable;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.migration.jira.apps.AppData;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/export/apps/AOTableEntityExporter;", "", "appDataTable", "Lcom/atlassian/jira/migration/db/AppDataTable;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/db/AppDataTable;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "getCloudSiteRepository", "()Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "getLocalFileDataOutput", "()Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "Lkotlin/Lazy;", "getPlatformService", "()Lcom/atlassian/jira/migration/platform/PlatformService;", "extractDataToFile", "Ljava/io/File;", "vendorConfigDto", "Lcom/atlassian/jira/migration/amcyclient/VendorConfigDto;", "migrationId", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAOTableEntityExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AOTableEntityExporter.kt\ncom/atlassian/jira/migration/export/apps/AOTableEntityExporter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,64:1\n1313#2,2:65\n*S KotlinDebug\n*F\n+ 1 AOTableEntityExporter.kt\ncom/atlassian/jira/migration/export/apps/AOTableEntityExporter\n*L\n46#1:65,2\n*E\n"})
public final class AOTableEntityExporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppDataTable appDataTable;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final Lazy objectMapper$delegate;
    private static final Logger log = LoggerFactory.getLogger(AOTableEntityExporter.class);

    @Inject
    public AOTableEntityExporter(@NotNull AppDataTable appDataTable, @NotNull PlatformService platformService, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)appDataTable, (String)"appDataTable");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.appDataTable = appDataTable;
        this.platformService = platformService;
        this.cloudSiteRepository = cloudSiteRepository;
        this.localFileDataOutput = localFileDataOutput;
        this.objectMapper$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ObjectMapper>(objectMapperFactory){
            final /* synthetic */ ObjectMapperFactory $objectMapperFactory;
            {
                this.$objectMapperFactory = $objectMapperFactory;
                super(0);
            }

            @NotNull
            public final ObjectMapper invoke() {
                return this.$objectMapperFactory.createObjectMapper();
            }
        }));
    }

    @NotNull
    public final PlatformService getPlatformService() {
        return this.platformService;
    }

    @NotNull
    public final CloudSiteRepository getCloudSiteRepository() {
        return this.cloudSiteRepository;
    }

    @NotNull
    public final LocalFileDataOutput getLocalFileDataOutput() {
        return this.localFileDataOutput;
    }

    private final ObjectMapper getObjectMapper() {
        Lazy lazy = this.objectMapper$delegate;
        return (ObjectMapper)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File extractDataToFile(@NotNull VendorConfigDto vendorConfigDto, @NotNull String migrationId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)vendorConfigDto, (String)"vendorConfigDto");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        log.info("Exporting AO Table entity data for migrationId: " + migrationId);
        String fileName = vendorConfigDto.getCloudAppKey() + '-' + migrationId + "-aoTableData.json";
        try {
            object = this.localFileDataOutput.outputFileForAppEntities(migrationId, fileName);
        }
        catch (Exception ex) {
            log.error("Failed to create output file for ao table export", (Throwable)ex);
            throw ex;
        }
        File outFile = object;
        try {
            object = new FileOutputStream(outFile);
            Throwable throwable = null;
            try {
                FileOutputStream outFileStream = (FileOutputStream)object;
                boolean bl = false;
                JsonGenerator jsonGenerator = this.getObjectMapper().getFactory().createGenerator((OutputStream)outFileStream, JsonEncoding.UTF8);
                Sequence<AppData> appData = this.appDataTable.getAoTableData(vendorConfigDto.getAoTableModels(), vendorConfigDto.getCloudAppKey());
                jsonGenerator.writeStartArray();
                Sequence<AppData> $this$forEach$iv = appData;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AppData entity = (AppData)element$iv;
                    boolean bl2 = false;
                    jsonGenerator.writeObject((Object)entity);
                }
                jsonGenerator.writeEndArray();
                jsonGenerator.close();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            return outFile;
        }
        catch (Exception ex) {
            log.error("Failed to write ao table data to file", (Throwable)ex);
            outFile.delete();
            throw ex;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/apps/AOTableEntityExporter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

