/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.assets;

import com.atlassian.jira.migration.export.assets.AssetsExportService;
import com.atlassian.jira.migration.export.assets.ObjectSchemaService;
import com.atlassian.jira.migration.export.db.assets.ObjectSchemaWrapper;
import com.atlassian.jira.migration.export.db.assets.ReferenceReader;
import com.atlassian.jira.migration.export.db.assets.ReferenceWrapper;
import com.atlassian.jira.migration.export.db.assets.StatusReader;
import com.atlassian.jira.migration.export.db.assets.StatusWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.plan.AssetsDataMigrationMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/export/assets/AssetsExportServiceImpl;", "Lcom/atlassian/jira/migration/export/assets/AssetsExportService;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "objectSchemaService", "Lcom/atlassian/jira/migration/export/assets/ObjectSchemaService;", "referenceReader", "Lcom/atlassian/jira/migration/export/db/assets/ReferenceReader;", "statusReader", "Lcom/atlassian/jira/migration/export/db/assets/StatusReader;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/assets/ObjectSchemaService;Lcom/atlassian/jira/migration/export/db/assets/ReferenceReader;Lcom/atlassian/jira/migration/export/db/assets/StatusReader;)V", "exportAssetsData", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "exportAssetsGlobalData", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAssetsExportServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssetsExportServiceImpl.kt\ncom/atlassian/jira/migration/export/assets/AssetsExportServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,50:1\n1549#2:51\n1620#2,3:52\n1855#2,2:55\n1313#3,2:57\n1313#3,2:59\n*S KotlinDebug\n*F\n+ 1 AssetsExportServiceImpl.kt\ncom/atlassian/jira/migration/export/assets/AssetsExportServiceImpl\n*L\n26#1:51\n26#1:52,3\n28#1:55,2\n34#1:57,2\n37#1:59,2\n*E\n"})
public final class AssetsExportServiceImpl
implements AssetsExportService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ObjectSchemaService objectSchemaService;
    @NotNull
    private final ReferenceReader referenceReader;
    @NotNull
    private final StatusReader statusReader;
    @NotNull
    private static final Logger log;

    public AssetsExportServiceImpl(@NotNull ExportService exportService, @NotNull ObjectSchemaService objectSchemaService, @NotNull ReferenceReader referenceReader, @NotNull StatusReader statusReader) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)objectSchemaService, (String)"objectSchemaService");
        Intrinsics.checkNotNullParameter((Object)referenceReader, (String)"referenceReader");
        Intrinsics.checkNotNullParameter((Object)statusReader, (String)"statusReader");
        this.exportService = exportService;
        this.objectSchemaService = objectSchemaService;
        this.referenceReader = referenceReader;
        this.statusReader = statusReader;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void exportAssetsData(@NotNull ExportContext ctx) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<ObjectSchemaWrapper> list;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        AssetsDataMigrationMode assetsDataMigrationMode = ctx.getAssetsDataMigrationMode();
        switch (assetsDataMigrationMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[assetsDataMigrationMode.ordinal()]) {
            case 1: {
                list = this.objectSchemaService.getAllObjectSchemas();
                break;
            }
            case 2: {
                list = this.objectSchemaService.getObjectSchemaForProjects(ctx.getProjectIds());
                break;
            }
            case 3: {
                List<String> list2 = ctx.getAssetsSchemaKeys();
                Intrinsics.checkNotNull(list2);
                list = this.objectSchemaService.getObjectSchemaByObjectSchemasByKeys(list2);
                break;
            }
            default: {
                list = CollectionsKt.emptyList();
            }
        }
        List<ObjectSchemaWrapper> objectSchemasToMigrate = list;
        Iterable iterable = objectSchemasToMigrate;
        StringBuilder stringBuilder = new StringBuilder().append("Migration Id: ").append(ctx.getMigrationId()).append(" - Migrating ").append(objectSchemasToMigrate.size()).append(" assets for mode ").append((Object)ctx.getAssetsDataMigrationMode()).append(". Assets Schema keys:\n ");
        Logger logger2 = log;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ObjectSchemaWrapper objectSchemaWrapper = (ObjectSchemaWrapper)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getObjectSchemaKey());
        }
        collection = (List)destination$iv$iv;
        logger2.info(stringBuilder.append(collection).toString());
        Iterable $this$forEach$iv = objectSchemasToMigrate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObjectSchemaWrapper it = (ObjectSchemaWrapper)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    @Override
    public void exportAssetsGlobalData(@NotNull ExportContext ctx) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        long currentTime = System.currentTimeMillis();
        log.info("Migration Id: " + ctx.getMigrationId() + " - Migrating Assets Global data started at " + currentTime);
        Object $this$forEach$iv = this.referenceReader.fetchGlobalReferences();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ReferenceWrapper)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
        $this$forEach$iv = this.statusReader.fetchGlobalStatuses();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatusWrapper)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
        log.info("Migration Id: " + ctx.getMigrationId() + " - Migrating Assets Global data ended at " + (System.currentTimeMillis() - currentTime));
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(AssetsExportServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/export/assets/AssetsExportServiceImpl$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AssetsDataMigrationMode.values().length];
            try {
                nArray[AssetsDataMigrationMode.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AssetsDataMigrationMode.SELECTED_PROJECTS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AssetsDataMigrationMode.SCHEMA_BY_SCHEMA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

