/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.assets;

import com.atlassian.jira.migration.export.db.assets.RoleActorWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.assets.Role;
import com.atlassian.migration.jira.assets.RoleActor;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/export/assets/AssetsRoleActorExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/assets/RoleActorWrapper;", "Lcom/atlassian/migration/jira/assets/RoleActor;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapTypeParameter", "Lcom/atlassian/migration/base/mri/MRI;", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAssetsRoleActorExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssetsRoleActorExporter.kt\ncom/atlassian/jira/migration/export/assets/AssetsRoleActorExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class AssetsRoleActorExporter
implements Exporter<Integer, RoleActorWrapper, RoleActor> {
    @NotNull
    private final ExportService exportService;
    private final Logger log;

    @Inject
    public AssetsRoleActorExporter(@NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.exportService = exportService;
        this.log = LoggerFactory.getLogger(AssetsRoleActorExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, RoleActorWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(RoleActor.Companion.getEntityType());
    }

    @Override
    @NotNull
    public MRI mriForKey(int entityKey) {
        return MriExtensionsKt.mri$default(RoleActor.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull RoleActorWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public RoleActor exportData(@NotNull ExportContext ctx, @NotNull RoleActorWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        String string = entity.getType();
        if (string == null) {
            throw new IllegalStateException(("Assets Role Actor " + entity.getId() + "'s type cannot be null").toString());
        }
        MRI mRI = this.mapTypeParameter(ctx, entity);
        if (mRI == null) {
            throw new IllegalStateException(("Assets Role Actor " + entity.getId() + " has invalid user/group reference").toString());
        }
        return new RoleActor(this.mriForEntity(entity), MriExtensionsKt.mri$default(Role.Companion.getEntityType(), entity.getRoleAoid(), null, 2, null), string, mRI);
    }

    private final MRI mapTypeParameter(ExportContext ctx, RoleActorWrapper entity) {
        MRI mRI;
        String string = entity.getType();
        if (Intrinsics.areEqual((Object)string, (Object)"atlassian-group-role-actor")) {
            String string2 = entity.getTypeParameter();
            Intrinsics.checkNotNull((Object)string2);
            GroupRefModel groupRef = new GroupRefModel(string2, "Assets Role [" + entity.getId() + ']', String.valueOf(entity.getId()));
            mRI = this.exportService.groupRefSkipInvalid(ctx, groupRef);
        } else if (Intrinsics.areEqual((Object)string, (Object)"atlassian-user-role-actor")) {
            UserRef userRef = UserRef.Companion.fromString(entity.getTypeParameter());
            if (userRef != null) {
                UserRef it = userRef;
                boolean bl = false;
                mRI = this.exportService.userRef(ctx, it);
            } else {
                mRI = null;
            }
        } else {
            throw new IllegalStateException(("Assets role with id " + entity.getId() + " has type other than atlassian-group-role-actor, atlassian-user-role-actor").toString());
        }
        return mRI;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull RoleActorWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting users and groups for roleActor  with id {} for migration {} under exportMode {}", objectArray);
        this.mapTypeParameter(ctx, entity);
    }

    @Override
    @Nullable
    public RoleActorWrapper extractServerEntity(@NotNull ExportContext ctx, int entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull RoleActorWrapper entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

