/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.assets;

import com.atlassian.jira.migration.export.db.assets.RoleActorReader;
import com.atlassian.jira.migration.export.db.assets.RoleActorWrapper;
import com.atlassian.jira.migration.export.db.assets.RoleWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.assets.ObjectSchema;
import com.atlassian.migration.jira.assets.ObjectType;
import com.atlassian.migration.jira.assets.Role;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 &2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001&B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ$\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0002H\u0016J\b\u0010#\u001a\u00020\u0014H\u0007J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u001cH\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010 2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001cH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/atlassian/jira/migration/export/assets/AssetsRoleExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/assets/RoleWrapper;", "Lcom/atlassian/migration/jira/assets/Role;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "roleActorReader", "Lcom/atlassian/jira/migration/export/db/assets/RoleActorReader;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/db/assets/RoleActorReader;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "childrenActions", "", "Lkotlin/Function0;", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportData", "hasValidTypeAndTypeParameter", "", "roleActor", "Lcom/atlassian/jira/migration/export/db/assets/RoleActorWrapper;", "mapRoleActors", "mapType", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "validateRoleActorType", "validateRoleActorTypeParameter", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAssetsRoleExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssetsRoleExporter.kt\ncom/atlassian/jira/migration/export/assets/AssetsRoleExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,116:1\n1#2:117\n1313#3,2:118\n*S KotlinDebug\n*F\n+ 1 AssetsRoleExporter.kt\ncom/atlassian/jira/migration/export/assets/AssetsRoleExporter\n*L\n86#1:118,2\n*E\n"})
public final class AssetsRoleExporter
implements Exporter<Integer, RoleWrapper, Role> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final RoleActorReader roleActorReader;
    private final Logger log;
    private static final int ROLE_TYPE_MIN_VALUE = 1;
    private static final int ROLE_TYPE_MAX_VALUE = 7;

    @Inject
    public AssetsRoleExporter(@NotNull ExportService exportService, @NotNull RoleActorReader roleActorReader) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)roleActorReader, (String)"roleActorReader");
        this.exportService = exportService;
        this.roleActorReader = roleActorReader;
        this.log = LoggerFactory.getLogger(AssetsRoleExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, RoleWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(Role.Companion.getEntityType());
    }

    @Override
    @NotNull
    public MRI mriForKey(int entityKey) {
        return MriExtensionsKt.mri$default(Role.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull RoleWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public Role exportData(@NotNull ExportContext ctx, @NotNull RoleWrapper entity) {
        MRI mRI;
        MRI mRI2;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        MRI mRI3 = this.mriForEntity(entity);
        String string = entity.getName();
        if (string == null) {
            throw new ExportException(this.mriForEntity(entity), ExportErrorCode.ASSETS_ROLE_HAS_NO_NAME, "Assets Role with id: " + entity.getId() + " has no name assigned.", null, null, null, null, 120, null);
        }
        String string2 = string;
        int n = this.mapType(entity);
        Integer n2 = entity.getObjectSchemaId();
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl = false;
            mRI2 = MriExtensionsKt.mri$default(ObjectSchema.Companion.getEntityType(), it, null, 2, null);
        } else {
            mRI2 = null;
        }
        MRI mRI4 = mRI2;
        Integer n3 = entity.getObjectTypeId();
        if (n3 != null) {
            int it = ((Number)n3).intValue();
            boolean bl = false;
            mRI = MriExtensionsKt.mri$default(ObjectType.Companion.getEntityType(), it, null, 2, null);
        } else {
            mRI = null;
        }
        MRI mRI5 = mRI;
        return new Role(mRI3, string2, mRI4, mRI5, n);
    }

    private final int mapType(RoleWrapper entity) {
        if (entity.getType() == null || !new IntRange(1, 7).contains(entity.getType().intValue())) {
            throw new ExportException(this.mriForEntity(entity), ExportErrorCode.ASSETS_ROLE_HAS_INVALID_TYPE_ASSIGNED, "Assets Role with id: " + entity.getId() + " has invalid type assigned.", "Role type should be between 1 and 7.", null, null, null, 112, null);
        }
        return entity.getType();
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull RoleWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return ctx.getIncludeRoleActors() ? CollectionsKt.listOf((Object)new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ AssetsRoleExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ RoleWrapper $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                AssetsRoleExporter.access$mapRoleActors(this.this$0, this.$ctx, this.$entity);
            }
        }) : CollectionsKt.emptyList();
    }

    private final void mapRoleActors(ExportContext ctx, RoleWrapper entity) {
        Sequence $this$forEach$iv = SequencesKt.filterNot(this.roleActorReader.fetchRoleActorsForRole(entity.getId()), (Function1)((Function1)new Function1<RoleActorWrapper, Boolean>(this, ctx){
            final /* synthetic */ AssetsRoleExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull RoleActorWrapper roleActor) {
                Intrinsics.checkNotNullParameter((Object)roleActor, (String)"roleActor");
                Boolean bl = roleActor.getType() == null || roleActor.getTypeParameter() == null || !AssetsRoleExporter.access$hasValidTypeAndTypeParameter(this.this$0, this.$ctx, roleActor);
                AssetsRoleExporter assetsRoleExporter = this.this$0;
                boolean result2 = bl;
                boolean bl2 = false;
                if (result2) {
                    AssetsRoleExporter.access$getLog$p(assetsRoleExporter).info("Filtered out assets roleActor with id: " + roleActor.getId());
                }
                return bl;
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RoleActorWrapper roleActor = (RoleActorWrapper)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, roleActor, false, 4, null);
        }
    }

    private final boolean hasValidTypeAndTypeParameter(ExportContext ctx, RoleActorWrapper roleActor) {
        return this.validateRoleActorType(roleActor) && this.validateRoleActorTypeParameter(ctx, roleActor) != null;
    }

    private final boolean validateRoleActorType(RoleActorWrapper entity) {
        return Intrinsics.areEqual((Object)entity.getType(), (Object)"atlassian-user-role-actor") || Intrinsics.areEqual((Object)entity.getType(), (Object)"atlassian-group-role-actor");
    }

    private final MRI validateRoleActorTypeParameter(ExportContext ctx, RoleActorWrapper entity) {
        MRI mRI;
        String string = entity.getType();
        if (Intrinsics.areEqual((Object)string, (Object)"atlassian-group-role-actor")) {
            String string2 = entity.getTypeParameter();
            Intrinsics.checkNotNull((Object)string2);
            GroupRefModel groupRef = new GroupRefModel(string2, "Assets Role [" + entity.getId() + ']', String.valueOf(entity.getId()));
            mRI = this.exportService.groupRefSkipInvalid(ctx, groupRef);
        } else if (Intrinsics.areEqual((Object)string, (Object)"atlassian-user-role-actor")) {
            UserRef userRef = UserRef.Companion.fromString(entity.getTypeParameter());
            if (userRef != null) {
                UserRef it = userRef;
                boolean bl = false;
                mRI = this.exportService.userRef(ctx, it);
            } else {
                mRI = null;
            }
        } else {
            mRI = null;
        }
        return mRI;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull RoleWrapper entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public RoleWrapper extractServerEntity(@NotNull ExportContext ctx, int entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    public static final /* synthetic */ void access$mapRoleActors(AssetsRoleExporter $this, ExportContext ctx, RoleWrapper entity) {
        $this.mapRoleActors(ctx, entity);
    }

    public static final /* synthetic */ boolean access$hasValidTypeAndTypeParameter(AssetsRoleExporter $this, ExportContext ctx, RoleActorWrapper roleActor) {
        return $this.hasValidTypeAndTypeParameter(ctx, roleActor);
    }

    public static final /* synthetic */ Logger access$getLog$p(AssetsRoleExporter $this) {
        return $this.log;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/assets/AssetsRoleExporter$Companion;", "", "()V", "ROLE_TYPE_MAX_VALUE", "", "ROLE_TYPE_MIN_VALUE", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

