/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.assets;

import com.atlassian.jira.migration.export.assets.ObjectAttributeValueMetadata;
import com.atlassian.jira.migration.export.assets.validation.AssetsDataValidator;
import com.atlassian.jira.migration.export.db.assets.NonReferencedObjectAttributeValuesWrapper;
import com.atlassian.jira.migration.export.db.assets.ObjectAttributeReader;
import com.atlassian.jira.migration.export.db.assets.ObjectAttributeWrapper;
import com.atlassian.jira.migration.export.db.assets.ObjectCommentReader;
import com.atlassian.jira.migration.export.db.assets.ObjectCommentWrapper;
import com.atlassian.jira.migration.export.db.assets.ObjectEntityWrapper;
import com.atlassian.jira.migration.export.db.assets.ObjectHistoryReader;
import com.atlassian.jira.migration.export.db.assets.ObjectHistoryWrapper;
import com.atlassian.jira.migration.export.db.assets.ReferencedObjectAttributeValuesWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.assets.ObjectAttribute;
import com.atlassian.migration.jira.assets.ObjectEntity;
import com.atlassian.migration.jira.assets.ObjectType;
import com.atlassian.migration.jira.assets.ObjectTypeAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001BQ\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e\u00a2\u0006\u0002\u0010\u0014J$\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0018\u0010#\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0018\u0010%\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003H\u0002J&\u0010&\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u00022\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001dH\u0002J\u0018\u0010*\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003H\u0016J$\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u001d2\u0006\u0010 \u001a\u00020!2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020)0\u001dH\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0010\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020\u0002H\u0016J\b\u00102\u001a\u00020\u001fH\u0007J\u0010\u00103\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/atlassian/jira/migration/export/assets/ObjectEntityExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/assets/ObjectEntityWrapper;", "Lcom/atlassian/migration/jira/assets/ObjectEntity;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "objectAttributeReader", "Lcom/atlassian/jira/migration/export/db/assets/ObjectAttributeReader;", "objectHistoryReader", "Lcom/atlassian/jira/migration/export/db/assets/ObjectHistoryReader;", "objectCommentReader", "Lcom/atlassian/jira/migration/export/db/assets/ObjectCommentReader;", "objectHistoryValidator", "Lcom/atlassian/jira/migration/export/assets/validation/AssetsDataValidator;", "Lcom/atlassian/jira/migration/export/db/assets/ObjectHistoryWrapper;", "objectCommentValidator", "Lcom/atlassian/jira/migration/export/db/assets/ObjectCommentWrapper;", "objectAttributeValueValidator", "Lcom/atlassian/jira/migration/export/assets/ObjectAttributeValueMetadata;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/db/assets/ObjectAttributeReader;Lcom/atlassian/jira/migration/export/db/assets/ObjectHistoryReader;Lcom/atlassian/jira/migration/export/db/assets/ObjectCommentReader;Lcom/atlassian/jira/migration/export/assets/validation/AssetsDataValidator;Lcom/atlassian/jira/migration/export/assets/validation/AssetsDataValidator;Lcom/atlassian/jira/migration/export/assets/validation/AssetsDataValidator;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "childrenActions", "", "Lkotlin/Function0;", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportData", "exportObjectComment", "exportObjectHistory", "exportReferencedAttributes", "objectId", "referencedObjAttributeWrappers", "Lcom/atlassian/jira/migration/export/db/assets/ObjectAttributeWrapper;", "exportUsersAndGroups", "getObjectAttributes", "Lcom/atlassian/migration/jira/assets/ObjectAttribute;", "objectAttributeWrappers", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "validateObjectWrapper", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nObjectEntityExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectEntityExporter.kt\ncom/atlassian/jira/migration/export/assets/ObjectEntityExporter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,164:1\n2707#2,10:165\n1313#2,2:175\n1313#2,2:177\n1477#3:179\n1502#3,3:180\n1505#3,3:190\n1477#3:204\n1502#3,3:205\n1505#3,3:215\n1549#3:221\n1620#3,3:222\n372#4,7:183\n526#4:193\n511#4,6:194\n372#4,7:208\n125#5:200\n152#5,3:201\n125#5:218\n152#5,2:219\n154#5:225\n*S KotlinDebug\n*F\n+ 1 ObjectEntityExporter.kt\ncom/atlassian/jira/migration/export/assets/ObjectEntityExporter\n*L\n60#1:165,10\n88#1:175,2\n96#1:177,2\n132#1:179\n132#1:180,3\n132#1:190,3\n148#1:204\n148#1:205,3\n148#1:215,3\n154#1:221\n154#1:222,3\n132#1:183,7\n132#1:193\n132#1:194,6\n148#1:208,7\n134#1:200\n134#1:201,3\n149#1:218\n149#1:219,2\n149#1:225\n*E\n"})
public final class ObjectEntityExporter
implements Exporter<Integer, ObjectEntityWrapper, ObjectEntity> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ObjectAttributeReader objectAttributeReader;
    @NotNull
    private final ObjectHistoryReader objectHistoryReader;
    @NotNull
    private final ObjectCommentReader objectCommentReader;
    @NotNull
    private final AssetsDataValidator<ObjectHistoryWrapper> objectHistoryValidator;
    @NotNull
    private final AssetsDataValidator<ObjectCommentWrapper> objectCommentValidator;
    @NotNull
    private final AssetsDataValidator<ObjectAttributeValueMetadata> objectAttributeValueValidator;
    private final Logger log;

    @Inject
    public ObjectEntityExporter(@NotNull ExportService exportService, @NotNull ObjectAttributeReader objectAttributeReader, @NotNull ObjectHistoryReader objectHistoryReader, @NotNull ObjectCommentReader objectCommentReader, @NotNull AssetsDataValidator<ObjectHistoryWrapper> objectHistoryValidator, @NotNull AssetsDataValidator<ObjectCommentWrapper> objectCommentValidator, @NotNull AssetsDataValidator<ObjectAttributeValueMetadata> objectAttributeValueValidator) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)objectAttributeReader, (String)"objectAttributeReader");
        Intrinsics.checkNotNullParameter((Object)objectHistoryReader, (String)"objectHistoryReader");
        Intrinsics.checkNotNullParameter((Object)objectCommentReader, (String)"objectCommentReader");
        Intrinsics.checkNotNullParameter(objectHistoryValidator, (String)"objectHistoryValidator");
        Intrinsics.checkNotNullParameter(objectCommentValidator, (String)"objectCommentValidator");
        Intrinsics.checkNotNullParameter(objectAttributeValueValidator, (String)"objectAttributeValueValidator");
        this.exportService = exportService;
        this.objectAttributeReader = objectAttributeReader;
        this.objectHistoryReader = objectHistoryReader;
        this.objectCommentReader = objectCommentReader;
        this.objectHistoryValidator = objectHistoryValidator;
        this.objectCommentValidator = objectCommentValidator;
        this.objectAttributeValueValidator = objectAttributeValueValidator;
        this.log = LoggerFactory.getLogger(ObjectEntityExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, ObjectEntityWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(ObjectEntity.Companion.getEntityType());
    }

    @Override
    @NotNull
    public MRI mriForKey(int entityKey) {
        return MriExtensionsKt.mri$default(ObjectEntity.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull ObjectEntityWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ObjectEntity exportData(@NotNull ExportContext ctx, @NotNull ObjectEntityWrapper entity) {
        void $this$partition$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.validateObjectWrapper(entity);
        Sequence<ObjectAttributeWrapper> sequence = this.objectAttributeReader.getAttributeValuesByObjectId(entity.getId());
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            ObjectAttributeWrapper it = (ObjectAttributeWrapper)element$iv;
            boolean bl = false;
            Integer n = it.getAttributeType();
            int n2 = ObjectTypeAttribute.AttributeType.REFERENCED_OBJECT.getId();
            if (n != null && n == n2) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List referencedAttributes = (List)pair.component1();
        List nonReferencedAttributes = (List)pair.component2();
        this.exportReferencedAttributes(ctx, entity.getId(), referencedAttributes);
        Comparable<Date> comparable = entity.getCreated();
        if (comparable == null || (comparable = comparable.toInstant()) == null) {
            comparable = Instant.now();
        }
        Comparable<Date> createdInstant = comparable;
        MRI mRI = this.mriForEntity(entity);
        String string = entity.getName();
        Intrinsics.checkNotNull((Object)string);
        String string2 = entity.getLabel();
        Intrinsics.checkNotNull((Object)string2);
        EntityType entityType = ObjectType.Companion.getEntityType();
        Integer n = entity.getObjectTypeId();
        Intrinsics.checkNotNull((Object)n);
        MRI mRI2 = MriExtensionsKt.mri$default(entityType, n, null, 2, null);
        String string3 = entity.getObjectKey();
        Intrinsics.checkNotNull((Object)createdInstant);
        Comparable<Date> comparable2 = entity.getUpdated();
        if (comparable2 == null || (comparable2 = comparable2.toInstant()) == null) {
            comparable2 = createdInstant;
        }
        Boolean bl = entity.getHasAvatar();
        return new ObjectEntity(mRI, null, string, string2, mRI2, string3, (Instant)createdInstant, (Instant)comparable2, bl != null ? bl : false, this.getObjectAttributes(ctx, nonReferencedAttributes), null, 1026, null);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull ObjectEntityWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Function0[]{new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ObjectEntityExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ObjectEntityWrapper $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                ObjectEntityExporter.access$exportObjectHistory(this.this$0, this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ObjectEntityExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ObjectEntityWrapper $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                ObjectEntityExporter.access$exportObjectComment(this.this$0, this.$ctx, this.$entity);
            }
        }};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final void exportObjectComment(ExportContext ctx, ObjectEntityWrapper entity) {
        Sequence $this$forEach$iv = SequencesKt.filter(this.objectCommentReader.getCommentsByObjectId(entity.getId()), (Function1)((Function1)new Function1<ObjectCommentWrapper, Boolean>(this, ctx){
            final /* synthetic */ ObjectEntityExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ObjectCommentWrapper it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ObjectEntityExporter.access$getObjectCommentValidator$p(this.this$0).validate(this.$ctx, it);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObjectCommentWrapper it = (ObjectCommentWrapper)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    private final void exportObjectHistory(ExportContext ctx, ObjectEntityWrapper entity) {
        Sequence $this$forEach$iv = SequencesKt.filter(this.objectHistoryReader.getHistoryByObjectId(entity.getId()), (Function1)((Function1)new Function1<ObjectHistoryWrapper, Boolean>(this, ctx){
            final /* synthetic */ ObjectEntityExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ObjectHistoryWrapper it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ObjectEntityExporter.access$getObjectHistoryValidator$p(this.this$0).validate(this.$ctx, it);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObjectHistoryWrapper it = (ObjectHistoryWrapper)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    private final void validateObjectWrapper(ObjectEntityWrapper entity) {
        List list;
        List $this$validateObjectWrapper_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CharSequence charSequence = entity.getName();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            $this$validateObjectWrapper_u24lambda_u243.add("Object cannot have a blank name.");
        }
        if ((charSequence = (CharSequence)entity.getLabel()) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            $this$validateObjectWrapper_u24lambda_u243.add("Object cannot have a blank label.");
        }
        if (entity.getHasAvatar() == null) {
            this.log.info("Object with id : " + entity.getId() + " has no Avatar, defaulting it to false.");
        }
        List errors = CollectionsKt.build((List)list);
        if (!((Collection)errors).isEmpty()) {
            throw new ExportException(this.mriForEntity(entity), ExportErrorCode.ASSET_OBJECT_HAS_INVALID_DATA, "Object with Id: " + entity.getId() + " has the following errors:\n" + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), "Please fix the data in object.", null, null, null, 112, null);
        }
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull ObjectEntityWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting users and groups for objectEntity with id {} for migration {} under exportMode {}", objectArray);
        this.getObjectAttributes(ctx, SequencesKt.toList(this.objectAttributeReader.getUserReferencedAttributeValuesByObjectId(entity.getId())));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ObjectAttribute> getObjectAttributes(ExportContext ctx, List<ObjectAttributeWrapper> objectAttributeWrappers) {
        void $this$mapTo$iv$iv;
        Map $this$filterTo$iv$iv;
        Object it;
        Object element$iv$iv;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = objectAttributeWrappers;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            element$iv$iv = iterator2.next();
            it = (ObjectAttributeWrapper)element$iv$iv;
            boolean bl = false;
            long l = ((ObjectAttributeWrapper)it).getId();
            Long l2 = ((ObjectAttributeWrapper)it).getObjectTypeAttributeId();
            Intrinsics.checkNotNull((Object)l2);
            long l3 = l2;
            Integer n = ((ObjectAttributeWrapper)it).getAttributeType();
            Intrinsics.checkNotNull((Object)n);
            ObjectAttributeValueMetadata key$iv$iv = new ObjectAttributeValueMetadata(l, l3, n);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            if (!this.objectAttributeValueValidator.validate(ctx, (ObjectAttributeValueMetadata)it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            ObjectAttributeValueMetadata idTriple = (ObjectAttributeValueMetadata)entry.getKey();
            List objectAttributeValues = (List)entry.getValue();
            object.add(this.exportService.exportObjectOrThrow(ctx, new NonReferencedObjectAttributeValuesWrapper(idTriple.getId(), idTriple.getObjectTypeAttributeId(), idTriple.getAttributeType(), objectAttributeValues), ObjectAttribute.class));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void exportReferencedAttributes(ExportContext ctx, int objectId, List<ObjectAttributeWrapper> referencedObjAttributeWrappers) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv = referencedObjAttributeWrappers;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ObjectAttributeWrapper it = (ObjectAttributeWrapper)element$iv$iv;
            boolean bl = false;
            Pair key$iv$iv = new Pair((Object)it.getId(), (Object)it.getObjectTypeAttributeId());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            Pair idPair = (Pair)entry.getKey();
            List objectAttributeWrappers = (List)entry.getValue();
            ExportOrThrow exportOrThrow = this.exportService;
            long l = ((Number)idPair.getFirst()).longValue();
            Object object2 = idPair.getSecond();
            Intrinsics.checkNotNull((Object)object2);
            Iterable $i$f$getOrPut = objectAttributeWrappers;
            int n = objectId;
            long l2 = ((Number)object2).longValue();
            long l3 = l;
            ExportContext exportContext = ctx;
            ExportOrThrow exportOrThrow2 = exportOrThrow;
            boolean $i$f$map2 = false;
            void var24_26 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                ObjectAttributeWrapper objectAttributeWrapper = (ObjectAttributeWrapper)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                Integer n2 = it.getReferencedObjectBeanId();
                Intrinsics.checkNotNull((Object)n2);
                collection.add(n2);
            }
            Collection<Integer> collection2 = collection = (List)destination$iv$iv2;
            int n3 = n;
            long l4 = l2;
            long l5 = l3;
            object.add(ExportOrThrow.DefaultImpls.exportOrThrow$default(exportOrThrow2, exportContext, new ReferencedObjectAttributeValuesWrapper(l5, l4, n3, (List<Integer>)collection2), false, 4, null));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public ObjectEntityWrapper extractServerEntity(@NotNull ExportContext ctx, int entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    public static final /* synthetic */ void access$exportObjectHistory(ObjectEntityExporter $this, ExportContext ctx, ObjectEntityWrapper entity) {
        $this.exportObjectHistory(ctx, entity);
    }

    public static final /* synthetic */ void access$exportObjectComment(ObjectEntityExporter $this, ExportContext ctx, ObjectEntityWrapper entity) {
        $this.exportObjectComment(ctx, entity);
    }

    public static final /* synthetic */ AssetsDataValidator access$getObjectCommentValidator$p(ObjectEntityExporter $this) {
        return $this.objectCommentValidator;
    }

    public static final /* synthetic */ AssetsDataValidator access$getObjectHistoryValidator$p(ObjectEntityExporter $this) {
        return $this.objectHistoryValidator;
    }
}

