/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.assets;

import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.export.assets.ObjectHistoryJsonValue;
import com.atlassian.jira.migration.export.assets.ValuesWrapper;
import com.atlassian.jira.migration.export.db.assets.ObjectHistoryWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.log.ExportMessageSeverity;
import com.atlassian.jira.migration.log.ExportPhase;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.assets.ObjectEntity;
import com.atlassian.migration.jira.assets.ObjectHistory;
import com.atlassian.migration.jira.assets.ObjectTypeAttribute;
import com.atlassian.migration.jira.assets.Status;
import com.atlassian.migration.jira.classic.Project;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J$\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010!2\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u001c\u0010\"\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010!H\u0002J4\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010!2\b\u0010&\u001a\u0004\u0018\u00010!H\u0002J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u0002H\u0016J\b\u0010*\u001a\u00020\u0018H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/atlassian/jira/migration/export/assets/ObjectHistoryExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/assets/ObjectHistoryWrapper;", "Lcom/atlassian/migration/jira/assets/ObjectHistory;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "getAttributeValue", "Lcom/atlassian/migration/jira/assets/ObjectHistory$ObjectHistoryKeyValue;", "value", "Lcom/atlassian/jira/migration/export/assets/ObjectHistoryJsonValue;", "handleAttributeType", "mapActorUserKey", "Lcom/atlassian/migration/base/mri/MRI;", "mapGroupFromGroupAttributeValue", "", "mapUserFromUserAttributeValue", "mapValue", "", "Lcom/atlassian/migration/jira/assets/ObjectHistory$ObjectHistoryValue;", "keyValues", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nObjectHistoryExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectHistoryExporter.kt\ncom/atlassian/jira/migration/export/assets/ObjectHistoryExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,223:1\n1#2:224\n37#3,2:225\n37#3,2:227\n1549#4:229\n1620#4,3:230\n1559#4:235\n1590#4,4:236\n58#5:233\n51#5:234\n*S KotlinDebug\n*F\n+ 1 ObjectHistoryExporter.kt\ncom/atlassian/jira/migration/export/assets/ObjectHistoryExporter\n*L\n67#1:225,2\n69#1:227,2\n85#1:229\n85#1:230,3\n93#1:235\n93#1:236,4\n87#1:233\n87#1:234\n*E\n"})
public final class ObjectHistoryExporter
implements Exporter<Integer, ObjectHistoryWrapper, ObjectHistory> {
    @NotNull
    private final ExportService exportService;
    private final Logger log;
    @NotNull
    private final ObjectMapper mapper;

    @Inject
    public ObjectHistoryExporter(@NotNull ExportService exportService, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.exportService = exportService;
        this.log = LoggerFactory.getLogger(ObjectHistoryExporter.class);
        this.mapper = objectMapperFactory.createObjectMapper();
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, ObjectHistoryWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(ObjectHistory.Companion.getEntityType());
    }

    @Override
    @NotNull
    public MRI mriForKey(int entityKey) {
        return MriExtensionsKt.mri$default(ObjectHistory.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull ObjectHistoryWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public ObjectHistory exportData(@NotNull ExportContext ctx, @NotNull ObjectHistoryWrapper entity) {
        MRI mRI;
        Integer n;
        Comparable<Date> comparable;
        String string;
        String string2;
        MRI mRI2;
        MRI mRI3;
        block12: {
            int n2;
            block11: {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                mRI3 = this.mriForEntity(entity);
                MRI mRI4 = this.mapActorUserKey(ctx, entity);
                if (mRI4 == null) {
                    throw new ExportException(this.mriForEntity(entity), ExportErrorCode.ASSETS_OBJECT_HISTORY_HAS_INVALID_DATA, "Actor user key for Object History with id: " + entity.getId() + " and objectId: " + entity.getObjectId() + " is null.", "Please add a userKey to the objectHistory with id " + entity.getId(), null, null, null, 112, null);
                }
                mRI2 = mRI4;
                string2 = entity.getAffectedAttribute();
                string = entity.getInsightVersion();
                Comparable<Date> comparable2 = entity.getCreated();
                if (comparable2 == null || (comparable2 = comparable2.toInstant()) == null) {
                    comparable2 = comparable = Instant.now();
                }
                if ((n = entity.getType()) == null) break block11;
                int it = ((Number)n).intValue();
                boolean bl = false;
                ObjectHistory.ObjectHistoryType objectHistoryType = ObjectHistory.ObjectHistoryType.Companion.fromId(it);
                n = objectHistoryType;
                if (objectHistoryType != null) break block12;
            }
            Object $this$toTypedArray$iv = (Object[])EntriesMappings.entries$0;
            boolean $i$f$toTypedArray = false;
            Object[] thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = thisCollection$iv.toArray(new ObjectHistory.ObjectHistoryType[0]);
            StringBuilder stringBuilder = new StringBuilder().append("Please add a valid type between ");
            String string3 = "Type for Object History with id: " + entity.getId() + " and objectId: " + entity.getObjectId() + " is invalid.";
            ExportErrorCode exportErrorCode = ExportErrorCode.ASSETS_OBJECT_HISTORY_HAS_INVALID_DATA;
            MRI mRI5 = this.mriForEntity(entity);
            if (((ObjectHistory.ObjectHistoryType[])$this$toTypedArray$iv).length == 0) {
                throw new NoSuchElementException();
            }
            ObjectHistory.ObjectHistoryType it22 = $this$toTypedArray$iv[0];
            boolean $i$a$-minOf-ObjectHistoryExporter$exportData$32 = false;
            int it22 = it22.getId();
            IntIterator $i$a$-minOf-ObjectHistoryExporter$exportData$32 = new IntRange(1, ArraysKt.getLastIndex((Object[])$this$toTypedArray$iv)).iterator();
            while ($i$a$-minOf-ObjectHistoryExporter$exportData$32.hasNext()) {
                n2 = $i$a$-minOf-ObjectHistoryExporter$exportData$32.nextInt();
                ObjectHistory.ObjectHistoryType it32 = (ObjectHistory.ObjectHistoryType)$this$toTypedArray$iv[n2];
                boolean bl = false;
                int it32 = it32.getId();
                if (it22 <= it32) continue;
                it22 = it32;
            }
            int n3 = it22;
            $this$toTypedArray$iv = (Collection)EntriesMappings.entries$0;
            $i$f$toTypedArray = false;
            Object thisCollection$iv2 = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv2.toArray(new ObjectHistory.ObjectHistoryType[0]);
            stringBuilder = stringBuilder.append(n3).append(" and ");
            if (objectArray.length == 0) {
                throw new NoSuchElementException();
            }
            ObjectHistory.ObjectHistoryType it = objectArray[0];
            boolean $i$a$-maxOf-ObjectHistoryExporter$exportData$42 = false;
            int n4 = it.getId();
            IntIterator $i$a$-maxOf-ObjectHistoryExporter$exportData$42 = new IntRange(1, ArraysKt.getLastIndex((Object[])objectArray)).iterator();
            while ($i$a$-maxOf-ObjectHistoryExporter$exportData$42.hasNext()) {
                n2 = $i$a$-maxOf-ObjectHistoryExporter$exportData$42.nextInt();
                ObjectHistory.ObjectHistoryType it3 = (ObjectHistory.ObjectHistoryType)objectArray[n2];
                boolean bl = false;
                int n5 = it3.getId();
                if (n4 >= n5) continue;
                n4 = n5;
            }
            n3 = n4;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n6 = 112;
            ExportPhase exportPhase = null;
            String string4 = null;
            ExportMessageSeverity exportMessageSeverity = null;
            String string5 = stringBuilder.append(n3).toString();
            String string6 = string3;
            ExportErrorCode exportErrorCode2 = exportErrorCode;
            MRI mRI6 = mRI5;
            throw new ExportException(mRI6, exportErrorCode2, string6, string5, exportMessageSeverity, string4, exportPhase, n6, defaultConstructorMarker);
        }
        Integer n7 = n;
        MRI mRI7 = MriExtensionsKt.mri$default(ObjectEntity.Companion.getEntityType(), entity.getObjectId(), null, 2, null);
        Integer n8 = entity.getObjectTypeAttributeId();
        if (n8 != null) {
            int it = ((Number)n8).intValue();
            boolean bl = false;
            mRI = MriExtensionsKt.mri$default(ObjectTypeAttribute.Companion.getEntityType(), it, null, 2, null);
        } else {
            mRI = null;
        }
        MRI mRI8 = mRI;
        List<ObjectHistory.ObjectHistoryValue> list = this.mapValue(entity, ctx, entity.getOldValue(), entity.getOldKeyValues());
        List<ObjectHistory.ObjectHistoryValue> list2 = this.mapValue(entity, ctx, entity.getNewValue(), entity.getNewKeyValues());
        Intrinsics.checkNotNull((Object)comparable);
        return new ObjectHistory(mRI3, mRI7, mRI8, string2, mRI2, (Instant)comparable, string, list2, list, (ObjectHistory.ObjectHistoryType)n7);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ObjectHistory.ObjectHistoryValue> mapValue(ObjectHistoryWrapper entity, ExportContext ctx, String value, String keyValues) {
        void $this$mapIndexedTo$iv$iv;
        Object $i$a$-runCatching-ObjectHistoryExporter$mapValue$parsedData$22;
        Collection collection;
        void $this$mapTo$iv$iv;
        if (value == null) {
            return null;
        }
        String[] stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        List valuesList = (List)destination$iv$iv;
        try {
            ValuesWrapper valuesWrapper;
            boolean $i$a$-runCatching-ObjectHistoryExporter$mapValue$parsedData$22 = false;
            String string = keyValues;
            if (string != null) {
                Object it = string;
                boolean bl = false;
                ObjectMapper $this$readValue$iv = this.mapper;
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                valuesWrapper = (ValuesWrapper)$this$readValue$iv.readValue((String)it, (TypeReference)new TypeReference<ValuesWrapper>(){});
            } else {
                valuesWrapper = null;
            }
            $i$a$-runCatching-ObjectHistoryExporter$mapValue$parsedData$22 = Result.constructor-impl(valuesWrapper);
        }
        catch (Throwable it) {
            $i$a$-runCatching-ObjectHistoryExporter$mapValue$parsedData$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)$i$a$-runCatching-ObjectHistoryExporter$mapValue$parsedData$22);
        if (throwable != null) {
            Object e = it = throwable;
            boolean bl = false;
            this.log.info("Failed to extract values from Asset History id: " + entity.getId() + " for object id: " + entity.getObjectId(), (Throwable)e);
        }
        ValuesWrapper parsedData = (ValuesWrapper)(Result.isFailure-impl((Object)$i$a$-runCatching-ObjectHistoryExporter$mapValue$parsedData$22) ? null : $i$a$-runCatching-ObjectHistoryExporter$mapValue$parsedData$22);
        Iterable $this$mapIndexed$iv = valuesList;
        boolean $i$f$mapIndexed = false;
        Iterable e = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            ObjectHistory.ObjectHistoryKeyValue objectHistoryKeyValue;
            void index;
            void valueItem;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv2;
            boolean bl = false;
            void v3 = valueItem;
            Object object = parsedData;
            if (object != null && (object = ((ValuesWrapper)object).getValues()) != null && (object = (ObjectHistoryJsonValue)CollectionsKt.getOrNull((List)object, (int)index)) != null) {
                void it;
                Object object2 = object;
                void var20_35 = v3;
                boolean bl2 = false;
                objectHistoryKeyValue = this.getAttributeValue(ctx, entity, (ObjectHistoryJsonValue)it);
                v3 = var20_35;
            } else {
                objectHistoryKeyValue = null;
            }
            ObjectHistory.ObjectHistoryKeyValue objectHistoryKeyValue2 = objectHistoryKeyValue;
            void var24_38 = v3;
            collection.add(new ObjectHistory.ObjectHistoryValue((String)var24_38, objectHistoryKeyValue2));
        }
        return (List)destination$iv$iv2;
    }

    private final ObjectHistory.ObjectHistoryKeyValue getAttributeValue(ExportContext ctx, ObjectHistoryWrapper entity, ObjectHistoryJsonValue value) {
        ObjectHistory.ObjectHistoryKeyValue objectHistoryKeyValue;
        Integer n = entity.getType();
        Intrinsics.checkNotNull((Object)n);
        ObjectHistory.ObjectHistoryType objectHistoryType = ObjectHistory.ObjectHistoryType.Companion.fromId(n.intValue());
        Intrinsics.checkNotNull((Object)objectHistoryType);
        ObjectHistory.ObjectHistoryType type = objectHistoryType;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                objectHistoryKeyValue = new ObjectHistory.ObjectHistoryKeyValue(null, null, null, null, null, null, null, MriExtensionsKt.mri$default(ObjectEntity.Companion.getEntityType(), String.valueOf(value.getReferencedObjectBeanId()), null, 2, null), null, 383, null);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectHistoryKeyValue = new ObjectHistory.ObjectHistoryKeyValue(null, this.mapUserFromUserAttributeValue(ctx, String.valueOf(value.getTextValue())), null, null, null, null, null, null, null, 509, null);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectHistoryKeyValue = new ObjectHistory.ObjectHistoryKeyValue(null, this.mapGroupFromGroupAttributeValue(ctx, String.valueOf(value.getTextValue()), entity), null, null, null, null, null, null, null, 509, null);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectHistoryKeyValue = new ObjectHistory.ObjectHistoryKeyValue(null, null, null, null, null, null, MriExtensionsKt.mri$default(Project.Companion.getEntityType(), String.valueOf(value.getIntegerValue()), null, 2, null), null, null, 447, null);
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectHistoryKeyValue = this.handleAttributeType(entity, value);
                break;
            }
            default: {
                String string = value.getTextValue();
                Integer n2 = value.getIntegerValue();
                Boolean bl = value.getBooleanValue();
                Double d = value.getDoubleValue();
                Long l = value.getDateValue();
                String string2 = value.getAdditionalValue();
                objectHistoryKeyValue = new ObjectHistory.ObjectHistoryKeyValue(string, null, bl, d, l, n2, null, null, string2, 194, null);
            }
        }
        return objectHistoryKeyValue;
    }

    private final ObjectHistory.ObjectHistoryKeyValue handleAttributeType(ObjectHistoryWrapper entity, ObjectHistoryJsonValue value) {
        Integer n = value.getIntegerValue();
        if (n != null) {
            int intValue = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = entity.getAttributeType();
            int n3 = ObjectTypeAttribute.AttributeType.STATUS.getId();
            return n2 != null && n2 == n3 ? new ObjectHistory.ObjectHistoryKeyValue(null, null, null, null, null, null, MriExtensionsKt.mri$default(Status.Companion.getEntityType(), intValue, null, 2, null), null, null, 447, null) : new ObjectHistory.ObjectHistoryKeyValue(null, null, null, null, null, Integer.valueOf(intValue), null, null, null, 479, null);
        }
        return new ObjectHistory.ObjectHistoryKeyValue(value.getTextValue(), null, value.getBooleanValue(), value.getDoubleValue(), value.getDateValue(), null, null, null, value.getAdditionalValue(), 226, null);
    }

    private final MRI mapGroupFromGroupAttributeValue(ExportContext ctx, String value, ObjectHistoryWrapper entity) {
        GroupRefModel groupRef = new GroupRefModel(String.valueOf(value), "Assets History item with id [" + entity.getId() + ']', String.valueOf(entity.getId()));
        return this.exportService.groupRefSkipInvalid(ctx, groupRef);
    }

    private final MRI mapUserFromUserAttributeValue(ExportContext ctx, String value) {
        MRI mRI;
        UserRef userRef = UserRef.Companion.fromString(value);
        if (userRef != null) {
            UserRef it = userRef;
            boolean bl = false;
            mRI = this.exportService.userRef(ctx, it);
        } else {
            mRI = null;
        }
        return mRI;
    }

    private final MRI mapActorUserKey(ExportContext ctx, ObjectHistoryWrapper entity) {
        MRI mRI;
        UserRef userRef = UserRef.Companion.fromString(entity.getActorUserKey());
        if (userRef != null) {
            UserRef it = userRef;
            boolean bl = false;
            mRI = this.exportService.userRef(ctx, it);
        } else {
            mRI = null;
        }
        return mRI;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull ObjectHistoryWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting users and groups for objectHistory with id {} for migration {} under exportMode {}", objectArray);
        this.mapActorUserKey(ctx, entity);
        this.mapValue(entity, ctx, entity.getNewValue(), entity.getNewKeyValues());
        this.mapValue(entity, ctx, entity.getOldValue(), entity.getOldKeyValues());
    }

    @Override
    @Nullable
    public ObjectHistoryWrapper extractServerEntity(@NotNull ExportContext ctx, int entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull ObjectHistoryWrapper entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<ObjectHistory.ObjectHistoryType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])ObjectHistory.ObjectHistoryType.values()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ObjectHistory.ObjectHistoryType.values().length];
            try {
                nArray[ObjectHistory.ObjectHistoryType.TYPE_ADDED_REFERENCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectHistory.ObjectHistoryType.TYPE_CHANGED_REFERENCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectHistory.ObjectHistoryType.TYPE_DELETED_REFERENCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectHistory.ObjectHistoryType.TYPE_ADDED_USER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectHistory.ObjectHistoryType.TYPE_CHANGED_USER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectHistory.ObjectHistoryType.TYPE_DELETED_USER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectHistory.ObjectHistoryType.TYPE_ADDED_GROUP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectHistory.ObjectHistoryType.TYPE_CHANGED_GROUP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectHistory.ObjectHistoryType.TYPE_DELETED_GROUP.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectHistory.ObjectHistoryType.TYPE_ADDED_PROJECT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectHistory.ObjectHistoryType.TYPE_CHANGED_PROJECT.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectHistory.ObjectHistoryType.TYPE_DELETED_PROJECT.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectHistory.ObjectHistoryType.TYPE_ADDED_ATTRIBUTE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectHistory.ObjectHistoryType.TYPE_CHANGED_ATTRIBUTE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectHistory.ObjectHistoryType.TYPE_DELETED_ATTRIBUTE.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

