/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.assets;

import com.atlassian.jira.migration.export.assets.AssetMultipleParentObjectTypeReferenceException;
import com.atlassian.jira.migration.export.assets.AssetsCircularObjectTypeReferenceException;
import com.atlassian.jira.migration.export.assets.ObjectTypeUnionService;
import com.atlassian.jira.migration.export.assets.ObjectTypeUnionWrapper;
import com.atlassian.jira.migration.export.db.assets.ObjectSchemaPropertiesWrapper;
import com.atlassian.jira.migration.export.db.assets.ObjectSchemaReader;
import com.atlassian.jira.migration.export.db.assets.ObjectSchemaWrapper;
import com.atlassian.jira.migration.export.db.assets.ObjectTypeReader;
import com.atlassian.jira.migration.export.db.assets.ReferenceReader;
import com.atlassian.jira.migration.export.db.assets.ReferenceWrapper;
import com.atlassian.jira.migration.export.db.assets.RoleReader;
import com.atlassian.jira.migration.export.db.assets.RoleWrapper;
import com.atlassian.jira.migration.export.db.assets.StatusReader;
import com.atlassian.jira.migration.export.db.assets.StatusWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.assets.ObjectSchema;
import com.atlassian.migration.jira.assets.ObjectSchemaProperty;
import java.time.Instant;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B?\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J$\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0018\u0010'\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0018\u0010(\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0018\u0010)\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010!\u001a\u00020\u0003H\u0016J\u0010\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020\u0002H\u0016J\b\u0010.\u001a\u00020\u001eH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/atlassian/jira/migration/export/assets/ObjectSchemaExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/assets/ObjectSchemaWrapper;", "Lcom/atlassian/migration/jira/assets/ObjectSchema;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "objectSchemaReader", "Lcom/atlassian/jira/migration/export/db/assets/ObjectSchemaReader;", "roleReader", "Lcom/atlassian/jira/migration/export/db/assets/RoleReader;", "statusReader", "Lcom/atlassian/jira/migration/export/db/assets/StatusReader;", "referenceReader", "Lcom/atlassian/jira/migration/export/db/assets/ReferenceReader;", "objectTypeReader", "Lcom/atlassian/jira/migration/export/db/assets/ObjectTypeReader;", "objectTypeUnionService", "Lcom/atlassian/jira/migration/export/assets/ObjectTypeUnionService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/db/assets/ObjectSchemaReader;Lcom/atlassian/jira/migration/export/db/assets/RoleReader;Lcom/atlassian/jira/migration/export/db/assets/StatusReader;Lcom/atlassian/jira/migration/export/db/assets/ReferenceReader;Lcom/atlassian/jira/migration/export/db/assets/ObjectTypeReader;Lcom/atlassian/jira/migration/export/assets/ObjectTypeUnionService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "childrenActions", "", "Lkotlin/Function0;", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportData", "fetchSchemaProperties", "Ljava/util/EnumSet;", "Lcom/atlassian/migration/jira/assets/ObjectSchemaProperty;", "mapObjectTypeUnion", "mapReferences", "mapRoles", "mapStatuses", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nObjectSchemaExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectSchemaExporter.kt\ncom/atlassian/jira/migration/export/assets/ObjectSchemaExporter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1313#2,2:133\n1313#2,2:135\n1313#2,2:137\n1855#3,2:139\n*S KotlinDebug\n*F\n+ 1 ObjectSchemaExporter.kt\ncom/atlassian/jira/migration/export/assets/ObjectSchemaExporter\n*L\n84#1:133,2\n90#1:135,2\n96#1:137,2\n106#1:139,2\n*E\n"})
public final class ObjectSchemaExporter
implements Exporter<Integer, ObjectSchemaWrapper, ObjectSchema> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ObjectSchemaReader objectSchemaReader;
    @NotNull
    private final RoleReader roleReader;
    @NotNull
    private final StatusReader statusReader;
    @NotNull
    private final ReferenceReader referenceReader;
    @NotNull
    private final ObjectTypeReader objectTypeReader;
    @NotNull
    private final ObjectTypeUnionService objectTypeUnionService;
    private final Logger log;

    @Inject
    public ObjectSchemaExporter(@NotNull ExportService exportService, @NotNull ObjectSchemaReader objectSchemaReader, @NotNull RoleReader roleReader, @NotNull StatusReader statusReader, @NotNull ReferenceReader referenceReader, @NotNull ObjectTypeReader objectTypeReader, @NotNull ObjectTypeUnionService objectTypeUnionService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)objectSchemaReader, (String)"objectSchemaReader");
        Intrinsics.checkNotNullParameter((Object)roleReader, (String)"roleReader");
        Intrinsics.checkNotNullParameter((Object)statusReader, (String)"statusReader");
        Intrinsics.checkNotNullParameter((Object)referenceReader, (String)"referenceReader");
        Intrinsics.checkNotNullParameter((Object)objectTypeReader, (String)"objectTypeReader");
        Intrinsics.checkNotNullParameter((Object)objectTypeUnionService, (String)"objectTypeUnionService");
        this.exportService = exportService;
        this.objectSchemaReader = objectSchemaReader;
        this.roleReader = roleReader;
        this.statusReader = statusReader;
        this.referenceReader = referenceReader;
        this.objectTypeReader = objectTypeReader;
        this.objectTypeUnionService = objectTypeUnionService;
        this.log = LoggerFactory.getLogger(ObjectSchemaExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, ObjectSchemaWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(ObjectSchema.Companion.getEntityType());
    }

    @Override
    @NotNull
    public MRI mriForKey(int entityKey) {
        return MriExtensionsKt.mri$default(ObjectSchema.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull ObjectSchemaWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public ObjectSchema exportData(@NotNull ExportContext ctx, @NotNull ObjectSchemaWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Comparable<Date> comparable = entity.getCreated();
        if (comparable == null || (comparable = comparable.toInstant()) == null) {
            comparable = Instant.now();
        }
        Comparable<Date> created = comparable;
        MRI mRI = this.mriForEntity(entity);
        String string = entity.getName();
        if (string == null) {
            throw new ExportException(this.mriForEntity(entity), ExportErrorCode.ASSETS_OBJECT_SCHEMA_HAS_INVALID_NAME, "ObjectSchema with id: " + entity.getId() + " cannot have null name.", "Please set a name for object schema.", null, null, null, 112, null);
        }
        String string2 = string;
        String string3 = entity.getObjectSchemaKey();
        Intrinsics.checkNotNull((Object)string3);
        String string4 = string3;
        EnumSet<ObjectSchemaProperty> enumSet = this.fetchSchemaProperties(entity);
        Comparable<Date> comparable2 = entity.getUpdated();
        if (comparable2 == null || (comparable2 = comparable2.toInstant()) == null) {
            comparable2 = created;
        }
        Comparable<Date> comparable3 = comparable2;
        String string5 = entity.getDescription();
        Intrinsics.checkNotNull((Object)created);
        Intrinsics.checkNotNull((Object)comparable3);
        return new ObjectSchema(mRI, string2, string4, string5, null, null, (Instant)created, (Instant)comparable3, enumSet, 48, null);
    }

    private final EnumSet<ObjectSchemaProperty> fetchSchemaProperties(ObjectSchemaWrapper entity) {
        EnumSet<ObjectSchemaProperty> enumSet;
        ObjectSchemaPropertiesWrapper objectSchemaPropertiesWrapper = this.objectSchemaReader.getSchemaPropertiesById(entity.getId());
        if (objectSchemaPropertiesWrapper == null) {
            EnumSet<ObjectSchemaProperty> enumSet2 = EnumSet.noneOf(ObjectSchemaProperty.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            return enumSet2;
        }
        ObjectSchemaPropertiesWrapper objectSchemaProperties = objectSchemaPropertiesWrapper;
        EnumSet<ObjectSchemaProperty> $this$fetchSchemaProperties_u24lambda_u241 = enumSet = EnumSet.noneOf(ObjectSchemaProperty.class);
        boolean bl = false;
        ObjectSchemaPropertiesWrapper $this$fetchSchemaProperties_u24lambda_u241_u24lambda_u240 = objectSchemaProperties;
        boolean bl2 = false;
        if ($this$fetchSchemaProperties_u24lambda_u241_u24lambda_u240.getAllowOtherObjectSchema()) {
            $this$fetchSchemaProperties_u24lambda_u241.add(ObjectSchemaProperty.ALLOW_OTHER_OBJECT_SCHEMA);
        }
        if ($this$fetchSchemaProperties_u24lambda_u241_u24lambda_u240.getQuickCreateObjects()) {
            $this$fetchSchemaProperties_u24lambda_u241.add(ObjectSchemaProperty.QUICK_CREATE_OBJECTS);
        }
        if ($this$fetchSchemaProperties_u24lambda_u241_u24lambda_u240.getCreateObjectCustomField()) {
            $this$fetchSchemaProperties_u24lambda_u241.add(ObjectSchemaProperty.CREATE_OBJECT_CUSTOM_FIELD);
        }
        if ($this$fetchSchemaProperties_u24lambda_u241_u24lambda_u240.getServiceDescCustomersEnabled()) {
            $this$fetchSchemaProperties_u24lambda_u241.add(ObjectSchemaProperty.SERVICE_DESC_CUSTOMERS_ENABLED);
        }
        if ($this$fetchSchemaProperties_u24lambda_u241_u24lambda_u240.getValidateQuickCreate()) {
            $this$fetchSchemaProperties_u24lambda_u241.add(ObjectSchemaProperty.VALIDATE_QUICK_CREATE);
        }
        EnumSet<ObjectSchemaProperty> enumSet3 = enumSet;
        Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"apply(...)");
        return enumSet3;
    }

    private final void mapRoles(ExportContext ctx, ObjectSchemaWrapper entity) {
        Sequence<RoleWrapper> $this$forEach$iv = this.roleReader.fetchRolesForObjectSchema(entity.getId());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RoleWrapper it = (RoleWrapper)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    private final void mapStatuses(ExportContext ctx, ObjectSchemaWrapper entity) {
        Sequence<StatusWrapper> $this$forEach$iv = this.statusReader.fetchStatusesForObjectSchema(entity.getId());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StatusWrapper it = (StatusWrapper)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    private final void mapReferences(ExportContext ctx, ObjectSchemaWrapper entity) {
        Sequence<ReferenceWrapper> $this$forEach$iv = this.referenceReader.fetchReferencesForObjectSchema(entity.getId());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReferenceWrapper it = (ReferenceWrapper)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    private final void mapObjectTypeUnion(ExportContext ctx, ObjectSchemaWrapper entity) {
        block3: {
            try {
                Iterable $this$forEach$iv = this.objectTypeUnionService.createDisjointSetsOfObjectTypeUnion(entity.getId(), SequencesKt.toList(this.objectTypeReader.getObjectTypesBySchemaId(entity.getId())));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ObjectTypeUnionWrapper it = (ObjectTypeUnionWrapper)element$iv;
                    boolean bl = false;
                    ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
                }
            }
            catch (Exception e) {
                Exception exception = e;
                if (!(exception instanceof AssetsCircularObjectTypeReferenceException ? true : exception instanceof AssetMultipleParentObjectTypeReferenceException)) break block3;
                this.log.error("Error occurred when exporting Object Schema " + entity.getId() + ": " + e.getMessage());
                throw new ExportException(this.mriForEntity(entity), ExportErrorCode.ASSETS_OBJECT_SCHEMA_HAS_INVALID_OBJECT_TYPE_DATA, "Object schema with id : " + entity.getId() + " has following errors: " + e.getMessage(), null, null, null, null, 120, null);
            }
        }
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull ObjectSchemaWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Function0[]{new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ObjectSchemaExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ObjectSchemaWrapper $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                ObjectSchemaExporter.access$mapRoles(this.this$0, this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ObjectSchemaExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ObjectSchemaWrapper $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                ObjectSchemaExporter.access$mapStatuses(this.this$0, this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ObjectSchemaExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ObjectSchemaWrapper $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                ObjectSchemaExporter.access$mapReferences(this.this$0, this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ObjectSchemaExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ObjectSchemaWrapper $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                ObjectSchemaExporter.access$mapObjectTypeUnion(this.this$0, this.$ctx, this.$entity);
            }
        }};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull ObjectSchemaWrapper entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public ObjectSchemaWrapper extractServerEntity(@NotNull ExportContext ctx, int entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    public static final /* synthetic */ void access$mapRoles(ObjectSchemaExporter $this, ExportContext ctx, ObjectSchemaWrapper entity) {
        $this.mapRoles(ctx, entity);
    }

    public static final /* synthetic */ void access$mapStatuses(ObjectSchemaExporter $this, ExportContext ctx, ObjectSchemaWrapper entity) {
        $this.mapStatuses(ctx, entity);
    }

    public static final /* synthetic */ void access$mapReferences(ObjectSchemaExporter $this, ExportContext ctx, ObjectSchemaWrapper entity) {
        $this.mapReferences(ctx, entity);
    }

    public static final /* synthetic */ void access$mapObjectTypeUnion(ObjectSchemaExporter $this, ExportContext ctx, ObjectSchemaWrapper entity) {
        $this.mapObjectTypeUnion(ctx, entity);
    }
}

