/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.assets;

import com.atlassian.jira.migration.export.db.assets.ObjectSchemaReader;
import com.atlassian.jira.migration.export.db.assets.ObjectSchemaWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tJ\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\tR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/export/assets/ObjectSchemaService;", "", "objectSchemaReader", "Lcom/atlassian/jira/migration/export/db/assets/ObjectSchemaReader;", "(Lcom/atlassian/jira/migration/export/db/assets/ObjectSchemaReader;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getAllObjectSchemas", "", "Lcom/atlassian/jira/migration/export/db/assets/ObjectSchemaWrapper;", "getObjectSchemaByObjectSchemas", "schemas", "getObjectSchemaByObjectSchemasByKeys", "schemasKeys", "", "getObjectSchemaForProjects", "projectIds", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nObjectSchemaService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectSchemaService.kt\ncom/atlassian/jira/migration/export/assets/ObjectSchemaService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1194#2,2:44\n1222#2,4:46\n1549#2:50\n1620#2,3:51\n766#2:54\n857#2,2:55\n1549#2:57\n1620#2,3:58\n*S KotlinDebug\n*F\n+ 1 ObjectSchemaService.kt\ncom/atlassian/jira/migration/export/assets/ObjectSchemaService\n*L\n30#1:44,2\n30#1:46,4\n33#1:50\n33#1:51,3\n34#1:54\n34#1:55,2\n35#1:57\n35#1:58,3\n*E\n"})
public final class ObjectSchemaService {
    @NotNull
    private final ObjectSchemaReader objectSchemaReader;
    private final Logger log;

    @Inject
    public ObjectSchemaService(@NotNull ObjectSchemaReader objectSchemaReader) {
        Intrinsics.checkNotNullParameter((Object)objectSchemaReader, (String)"objectSchemaReader");
        this.objectSchemaReader = objectSchemaReader;
        this.log = LoggerFactory.getLogger(ObjectSchemaService.class);
    }

    @NotNull
    public final List<ObjectSchemaWrapper> getAllObjectSchemas() {
        return SequencesKt.toList(this.objectSchemaReader.getAllObjectSchemas());
    }

    @NotNull
    public final List<ObjectSchemaWrapper> getObjectSchemaForProjects(@NotNull List<Long> projectIds) {
        Intrinsics.checkNotNullParameter(projectIds, (String)"projectIds");
        List schemaWithProjectReferenced = SequencesKt.toList(this.objectSchemaReader.getObjectSchemaByProjectsIds(projectIds));
        this.log.info("Found " + schemaWithProjectReferenced.size() + " direct referenced schema(s) for selected projects");
        List<ObjectSchemaWrapper> allScopedSchemas = this.getObjectSchemaByObjectSchemas(schemaWithProjectReferenced);
        this.log.info("Found " + allScopedSchemas.size() + " scoped schema(s)");
        return allScopedSchemas;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ObjectSchemaWrapper> getObjectSchemaByObjectSchemas(@NotNull List<ObjectSchemaWrapper> schemas) {
        Object object;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        List newDiscoveredSchemas = schemas;
        Iterable $this$associateBy$iv = newDiscoveredSchemas;
        boolean $i$f$associateBy = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ObjectSchemaWrapper objectSchemaWrapper = (ObjectSchemaWrapper)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(it.getId(), element$iv$iv);
        }
        Map uniqueSchemaMap = MapsKt.toMutableMap((Map)destination$iv$iv);
        while (!((Collection)newDiscoveredSchemas).isEmpty()) {
            Iterable $this$filterTo$iv$iv;
            void $this$filter$iv;
            ObjectSchemaWrapper it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            $this$associateBy$iv = newDiscoveredSchemas;
            object = this.objectSchemaReader;
            boolean $i$f$map = false;
            void capacity$iv2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object element$iv$iv;
                element$iv$iv = (ObjectSchemaWrapper)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getId());
            }
            $this$map$iv = ((ObjectSchemaReader)object).getRelatedObjectSchemaBySchemaIds((List)destination$iv$iv2);
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ObjectSchemaWrapper)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !uniqueSchemaMap.containsKey(it.getId());
                if (!bl2) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            newDiscoveredSchemas = (List)destination$iv$iv2;
            $this$map$iv = newDiscoveredSchemas;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ObjectSchemaWrapper)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                uniqueSchemaMap.put(it.getId(), it);
                object.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv2;
        }
        return CollectionsKt.toList((Iterable)uniqueSchemaMap.values());
    }

    @NotNull
    public final List<ObjectSchemaWrapper> getObjectSchemaByObjectSchemasByKeys(@NotNull List<String> schemasKeys) {
        Intrinsics.checkNotNullParameter(schemasKeys, (String)"schemasKeys");
        return this.getObjectSchemaByObjectSchemas(this.objectSchemaReader.getObjectSchemaByKeys(schemasKeys));
    }
}

