/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.assets;

import com.atlassian.jira.migration.export.db.assets.ObjectTypeAttributeWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.assets.AQL;
import com.atlassian.migration.jira.assets.ObjectType;
import com.atlassian.migration.jira.assets.ObjectTypeAttribute;
import com.atlassian.migration.jira.assets.Reference;
import com.atlassian.migration.jira.assets.Status;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0002J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\b\u0010 \u001a\u00020\u0016H\u0007J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0003H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/export/assets/ObjectTypeAttributeExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/assets/ObjectTypeAttributeWrapper;", "Lcom/atlassian/migration/jira/assets/ObjectTypeAttribute;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;)V", "getExportService", "()Lcom/atlassian/jira/migration/export/service/ExportService;", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "fetchTypeValues", "", "", "typeValue", "mapTypeValue", "Lcom/atlassian/migration/base/mri/MRI;", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "validateEntity", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nObjectTypeAttributeExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectTypeAttributeExporter.kt\ncom/atlassian/jira/migration/export/assets/ObjectTypeAttributeExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1#2:115\n1#2:130\n1549#3:116\n1620#3,3:117\n1603#3,9:120\n1855#3:129\n1856#3:131\n1612#3:132\n1549#3:133\n1620#3,3:134\n*S KotlinDebug\n*F\n+ 1 ObjectTypeAttributeExporter.kt\ncom/atlassian/jira/migration/export/assets/ObjectTypeAttributeExporter\n*L\n104#1:130\n103#1:116\n103#1:117,3\n104#1:120,9\n104#1:129\n104#1:131\n104#1:132\n112#1:133\n112#1:134,3\n*E\n"})
public final class ObjectTypeAttributeExporter
implements Exporter<Integer, ObjectTypeAttributeWrapper, ObjectTypeAttribute> {
    @NotNull
    private final ExportService exportService;
    private final Logger log;
    @NotNull
    private final ExporterKey key;

    @Inject
    public ObjectTypeAttributeExporter(@NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.exportService = exportService;
        this.log = LoggerFactory.getLogger(ObjectTypeAttributeExporter.class);
        this.key = new ExporterKey(ObjectTypeAttribute.Companion.getEntityType());
    }

    @NotNull
    public final ExportService getExportService() {
        return this.exportService;
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, ObjectTypeAttributeWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForKey(int entityKey) {
        return MriExtensionsKt.mri$default(ObjectTypeAttribute.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull ObjectTypeAttributeWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public ObjectTypeAttribute exportData(@NotNull ExportContext ctx, @NotNull ObjectTypeAttributeWrapper entity) {
        AQL aQL;
        MRI mRI;
        MRI mRI2;
        MRI mRI3;
        MRI mRI4;
        int it;
        MRI mRI5;
        MRI mRI6;
        String string;
        String string2;
        String string3;
        int n;
        Instant instant;
        Instant instant2;
        boolean bl;
        boolean bl2;
        Boolean bl3;
        String string4;
        String string5;
        boolean bl4;
        String string6;
        int n2;
        int n3;
        boolean bl5;
        boolean bl6;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.validateEntity(entity);
        MRI mRI7 = this.mriForKey(entity.getId());
        MRI mRI8 = MriExtensionsKt.mri$default(ObjectType.Companion.getEntityType(), entity.getObjectTypeId(), null, 2, null);
        String string7 = null;
        String string8 = entity.getName();
        String string9 = string8;
        Intrinsics.checkNotNull((Object)string8);
        String string10 = entity.getDescription();
        Integer n4 = entity.getPosition();
        Intrinsics.checkNotNull((Object)n4);
        int n5 = n4;
        Instant instant3 = entity.getCreated();
        Instant instant4 = entity.getUpdated();
        Boolean bl7 = entity.isHidden();
        boolean bl8 = bl7 != null ? bl7 : false;
        Boolean bl9 = entity.isUnique();
        boolean bl10 = bl9 != null ? bl9 : false;
        Boolean bl11 = entity.getIncludeChildObjectTypes();
        String string11 = entity.getRegexValidation();
        String string12 = entity.getSuffix();
        Boolean bl12 = entity.getSummable();
        boolean bl13 = bl12 != null ? bl12 : false;
        String string13 = entity.getOptions();
        Integer n6 = entity.getMaxCardinality();
        Intrinsics.checkNotNull((Object)n6);
        int n7 = n6;
        Integer n8 = entity.getMinCardinality();
        Intrinsics.checkNotNull((Object)n8);
        int n9 = n8;
        Boolean bl14 = entity.getLabel();
        boolean bl15 = bl14 != null ? bl14 : false;
        Boolean bl16 = entity.getRemovable();
        boolean bl17 = bl16 != null ? bl16 : false;
        Integer n10 = entity.getReferencedObjectTypeId();
        if (n10 != null) {
            int n11 = ((Number)n10).intValue();
            bl6 = bl17;
            bl5 = bl15;
            n3 = n9;
            n2 = n7;
            string6 = string13;
            bl4 = bl13;
            string5 = string12;
            string4 = string11;
            bl3 = bl11;
            bl2 = bl10;
            bl = bl8;
            instant2 = instant4;
            instant = instant3;
            n = n5;
            string3 = string10;
            string2 = string9;
            string = string7;
            mRI6 = mRI8;
            mRI5 = mRI7;
            boolean bl18 = false;
            mRI4 = MriExtensionsKt.mri$default(ObjectType.Companion.getEntityType(), it, null, 2, null);
            mRI7 = mRI5;
            mRI8 = mRI6;
            string7 = string;
            string9 = string2;
            string10 = string3;
            n5 = n;
            instant3 = instant;
            instant4 = instant2;
            bl8 = bl;
            bl10 = bl2;
            bl11 = bl3;
            string11 = string4;
            string12 = string5;
            bl13 = bl4;
            string13 = string6;
            n7 = n2;
            n9 = n3;
            bl15 = bl5;
            bl17 = bl6;
            mRI3 = mRI4;
        } else {
            mRI3 = null;
        }
        Integer n12 = entity.getReferenceId();
        if (n12 != null) {
            it = ((Number)n12).intValue();
            mRI4 = mRI3;
            bl6 = bl17;
            bl5 = bl15;
            n3 = n9;
            n2 = n7;
            string6 = string13;
            bl4 = bl13;
            string5 = string12;
            string4 = string11;
            bl3 = bl11;
            bl2 = bl10;
            bl = bl8;
            instant2 = instant4;
            instant = instant3;
            n = n5;
            string3 = string10;
            string2 = string9;
            string = string7;
            mRI6 = mRI8;
            mRI5 = mRI7;
            boolean bl19 = false;
            mRI2 = MriExtensionsKt.mri$default(Reference.Companion.getEntityType(), it, null, 2, null);
            mRI7 = mRI5;
            mRI8 = mRI6;
            string7 = string;
            string9 = string2;
            string10 = string3;
            n5 = n;
            instant3 = instant;
            instant4 = instant2;
            bl8 = bl;
            bl10 = bl2;
            bl11 = bl3;
            string11 = string4;
            string12 = string5;
            bl13 = bl4;
            string13 = string6;
            n7 = n2;
            n9 = n3;
            bl15 = bl5;
            bl17 = bl6;
            mRI3 = mRI4;
            mRI = mRI2;
        } else {
            mRI = null;
        }
        String string14 = entity.getAdditionalValue();
        Integer n13 = entity.getDefaultTypeId();
        Intrinsics.checkNotNull((Object)n13);
        ObjectTypeAttribute.DefaultAttributeType defaultAttributeType = ObjectTypeAttribute.DefaultAttributeType.Companion.fromId(n13.intValue());
        ObjectTypeAttribute.DefaultAttributeType defaultAttributeType2 = defaultAttributeType;
        Intrinsics.checkNotNull((Object)defaultAttributeType);
        Integer n14 = entity.getType();
        Intrinsics.checkNotNull((Object)n14);
        ObjectTypeAttribute.AttributeType attributeType = ObjectTypeAttribute.AttributeType.Companion.fromId(n14.intValue());
        ObjectTypeAttribute.AttributeType attributeType2 = attributeType;
        Intrinsics.checkNotNull((Object)attributeType);
        List<MRI> list = this.mapTypeValue(ctx, entity);
        String string15 = entity.getIql();
        if (string15 != null) {
            String it2 = string15;
            List<MRI> list2 = list;
            ObjectTypeAttribute.AttributeType attributeType3 = attributeType2;
            ObjectTypeAttribute.DefaultAttributeType defaultAttributeType3 = defaultAttributeType2;
            String string16 = string14;
            mRI2 = mRI;
            mRI4 = mRI3;
            bl6 = bl17;
            bl5 = bl15;
            n3 = n9;
            n2 = n7;
            string6 = string13;
            bl4 = bl13;
            string5 = string12;
            string4 = string11;
            bl3 = bl11;
            bl2 = bl10;
            bl = bl8;
            instant2 = instant4;
            instant = instant3;
            n = n5;
            string3 = string10;
            string2 = string9;
            string = string7;
            mRI6 = mRI8;
            mRI5 = mRI7;
            boolean bl20 = false;
            AQL aQL2 = new AQL(it2);
            mRI7 = mRI5;
            mRI8 = mRI6;
            string7 = string;
            string9 = string2;
            string10 = string3;
            n5 = n;
            instant3 = instant;
            instant4 = instant2;
            bl8 = bl;
            bl10 = bl2;
            bl11 = bl3;
            string11 = string4;
            string12 = string5;
            bl13 = bl4;
            string13 = string6;
            n7 = n2;
            n9 = n3;
            bl15 = bl5;
            bl17 = bl6;
            mRI3 = mRI4;
            mRI = mRI2;
            string14 = string16;
            defaultAttributeType2 = defaultAttributeType3;
            attributeType2 = attributeType3;
            list = list2;
            aQL = aQL2;
        } else {
            aQL = null;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n15 = 4;
        AQL aQL3 = aQL;
        List<MRI> list3 = list;
        ObjectTypeAttribute.AttributeType attributeType4 = attributeType2;
        ObjectTypeAttribute.DefaultAttributeType defaultAttributeType4 = defaultAttributeType2;
        String string17 = string14;
        MRI mRI9 = mRI;
        MRI mRI10 = mRI3;
        boolean bl21 = bl17;
        boolean bl22 = bl15;
        int n16 = n9;
        int n17 = n7;
        String string18 = string13;
        boolean bl23 = bl13;
        String string19 = string12;
        String string20 = string11;
        Boolean bl24 = bl11;
        boolean bl25 = bl10;
        boolean bl26 = bl8;
        Instant instant5 = instant4;
        Instant instant6 = instant3;
        int n18 = n5;
        String string21 = string10;
        String string22 = string9;
        String string23 = string7;
        MRI mRI11 = mRI8;
        MRI mRI12 = mRI7;
        return new ObjectTypeAttribute(mRI12, mRI11, string23, string22, string21, n18, instant6, instant5, bl26, bl25, bl24, string20, string19, bl23, string18, n17, n16, bl22, bl21, mRI10, mRI9, string17, defaultAttributeType4, attributeType4, list3, aQL3, n15, defaultConstructorMarker);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull ObjectTypeAttributeWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getObjectTypeId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting users and groups for objectType with id {} for migration {} under exportMode {}", objectArray);
        this.mapTypeValue(ctx, entity);
    }

    private final void validateEntity(ObjectTypeAttributeWrapper entity) {
        List list;
        List $this$validateEntity_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CharSequence charSequence = entity.getName();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            $this$validateEntity_u24lambda_u243.add("Object Type Attribute cannot have a blank name.");
        }
        if (entity.getPosition() == null) {
            $this$validateEntity_u24lambda_u243.add("Object Type Attribute must have a position.");
        }
        List errors = CollectionsKt.build((List)list);
        if (!((Collection)errors).isEmpty()) {
            throw new ExportException(this.mriForEntity(entity), ExportErrorCode.ASSETS_OBJECT_TYPE_ATTRIBUTE_HAS_INVALID_DATA, "Object Type with Id: " + entity.getObjectTypeId() + " has the following errors for its Attribute with Id: " + entity.getId() + '\n' + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), "Please fix the data in your Attribute of Object Type.", null, null, null, 112, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<MRI> mapTypeValue(ExportContext ctx, ObjectTypeAttributeWrapper entity) {
        List list;
        Integer n = entity.getType();
        Intrinsics.checkNotNull((Object)n);
        ObjectTypeAttribute.AttributeType attributeType = ObjectTypeAttribute.AttributeType.Companion.fromId(n.intValue());
        switch (attributeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[attributeType.ordinal()]) {
            case 1: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.fetchTypeValues(entity.getTypeValue());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(MriExtensionsKt.mri$default(Status.Companion.getEntityType(), it, null, 2, null));
                }
                list = (List)destination$iv$iv;
                break;
            }
            case 2: {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = this.fetchTypeValues(entity.getTypeValue());
                boolean $i$f$mapNotNull = false;
                Iterable $this$mapTo$iv$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    MRI it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (this.exportService.groupRefOrNull(ctx, it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
                break;
            }
            default: {
                list = CollectionsKt.emptyList();
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> fetchTypeValues(String typeValue) {
        List list;
        String[] stringArray = (String[])typeValue;
        if (stringArray == null || StringsKt.isBlank((CharSequence)stringArray)) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)typeValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @Override
    @Nullable
    public ObjectTypeAttributeWrapper extractServerEntity(@NotNull ExportContext ctx, int entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull ObjectTypeAttributeWrapper entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ObjectTypeAttribute.AttributeType.values().length];
            try {
                nArray[ObjectTypeAttribute.AttributeType.STATUS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectTypeAttribute.AttributeType.USER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

