/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.assets;

import com.atlassian.jira.migration.export.assets.validation.AssetsDataValidator;
import com.atlassian.jira.migration.export.db.assets.ObjectEntityReader;
import com.atlassian.jira.migration.export.db.assets.ObjectEntityWrapper;
import com.atlassian.jira.migration.export.db.assets.ObjectTypeAttributeReader;
import com.atlassian.jira.migration.export.db.assets.ObjectTypeAttributeWrapper;
import com.atlassian.jira.migration.export.db.assets.ObjectTypeWrapper;
import com.atlassian.jira.migration.export.db.assets.RoleReader;
import com.atlassian.jira.migration.export.db.assets.RoleWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.progress.v3.ConvertorHelpers;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.assets.Icon;
import com.atlassian.migration.jira.assets.ObjectType;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B5\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J$\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0002H\u0016J\b\u0010$\u001a\u00020\u0018H\u0007J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/atlassian/jira/migration/export/assets/ObjectTypeExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/assets/ObjectTypeWrapper;", "Lcom/atlassian/migration/jira/assets/ObjectType;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "objectTypeAttributeReader", "Lcom/atlassian/jira/migration/export/db/assets/ObjectTypeAttributeReader;", "objectEntityReader", "Lcom/atlassian/jira/migration/export/db/assets/ObjectEntityReader;", "roleReader", "Lcom/atlassian/jira/migration/export/db/assets/RoleReader;", "objectTypeAttributeValidator", "Lcom/atlassian/jira/migration/export/assets/validation/AssetsDataValidator;", "Lcom/atlassian/jira/migration/export/db/assets/ObjectTypeAttributeWrapper;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/db/assets/ObjectTypeAttributeReader;Lcom/atlassian/jira/migration/export/db/assets/ObjectEntityReader;Lcom/atlassian/jira/migration/export/db/assets/RoleReader;Lcom/atlassian/jira/migration/export/assets/validation/AssetsDataValidator;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "childrenActions", "", "Lkotlin/Function0;", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportData", "exportObjectEntities", "exportObjectTypeAttributes", "exportRole", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "validateEntity", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nObjectTypeExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectTypeExporter.kt\ncom/atlassian/jira/migration/export/assets/ObjectTypeExporter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,106:1\n1313#2,2:107\n1313#2,2:109\n1313#2,2:111\n*S KotlinDebug\n*F\n+ 1 ObjectTypeExporter.kt\ncom/atlassian/jira/migration/export/assets/ObjectTypeExporter\n*L\n92#1:107,2\n100#1:109,2\n104#1:111,2\n*E\n"})
public final class ObjectTypeExporter
implements Exporter<Integer, ObjectTypeWrapper, ObjectType> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ObjectTypeAttributeReader objectTypeAttributeReader;
    @NotNull
    private final ObjectEntityReader objectEntityReader;
    @NotNull
    private final RoleReader roleReader;
    @NotNull
    private final AssetsDataValidator<ObjectTypeAttributeWrapper> objectTypeAttributeValidator;
    @NotNull
    private final ExporterKey key;

    @Inject
    public ObjectTypeExporter(@NotNull ExportService exportService, @NotNull ObjectTypeAttributeReader objectTypeAttributeReader, @NotNull ObjectEntityReader objectEntityReader, @NotNull RoleReader roleReader, @NotNull AssetsDataValidator<ObjectTypeAttributeWrapper> objectTypeAttributeValidator) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)objectTypeAttributeReader, (String)"objectTypeAttributeReader");
        Intrinsics.checkNotNullParameter((Object)objectEntityReader, (String)"objectEntityReader");
        Intrinsics.checkNotNullParameter((Object)roleReader, (String)"roleReader");
        Intrinsics.checkNotNullParameter(objectTypeAttributeValidator, (String)"objectTypeAttributeValidator");
        this.exportService = exportService;
        this.objectTypeAttributeReader = objectTypeAttributeReader;
        this.objectEntityReader = objectEntityReader;
        this.roleReader = roleReader;
        this.objectTypeAttributeValidator = objectTypeAttributeValidator;
        this.key = new ExporterKey(ObjectType.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, ObjectTypeWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForKey(int entityKey) {
        return MriExtensionsKt.mri$default(ObjectType.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull ObjectTypeWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public ObjectType exportData(@NotNull ExportContext ctx, @NotNull ObjectTypeWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.validateEntity(entity);
        MRI mRI = this.mriForKey(entity.getId());
        String string = entity.getName();
        Intrinsics.checkNotNull((Object)string);
        String string2 = entity.getDescription();
        EntityType entityType = Icon.Companion.getEntityType();
        Integer n = entity.getIconId();
        Intrinsics.checkNotNull((Object)n);
        MRI mRI2 = MriExtensionsKt.mri$default(entityType, n, null, 2, null);
        Integer n2 = entity.getPosition();
        Intrinsics.checkNotNull((Object)n2);
        Boolean bl = entity.isAbstract();
        Boolean bl2 = entity.isInherited();
        return new ObjectType(mRI, null, string, string2, mRI2, n2.intValue(), entity.getCreated(), entity.getUpdated(), ConvertorHelpers.Companion.asLongOrNull(entity.getParentObjectTypeId()), bl != null ? bl : false, bl2 != null ? bl2 : false, entity.getProcessingOrder(), null, 4098, null);
    }

    private final void validateEntity(ObjectTypeWrapper entity) {
        List list;
        List $this$validateEntity_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CharSequence charSequence = entity.getName();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            $this$validateEntity_u24lambda_u240.add("Object Type cannot have a blank name.");
        }
        if (entity.getIconId() == null) {
            $this$validateEntity_u24lambda_u240.add("Object Type must have an icon.");
        }
        if (entity.getPosition() == null) {
            $this$validateEntity_u24lambda_u240.add("Object Type must have a position.");
        }
        List errors = CollectionsKt.build((List)list);
        if (!((Collection)errors).isEmpty()) {
            throw new ExportException(this.mriForEntity(entity), ExportErrorCode.ASSETS_OBJECT_TYPE_HAS_INVALID_DATA, "Object Type with Id: " + entity.getId() + " has the following errors:\n" + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), "Please fix the data in your Object Type.", null, null, null, 112, null);
        }
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull ObjectTypeWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Function0[]{new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ObjectTypeExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ObjectTypeWrapper $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                ObjectTypeExporter.access$exportObjectTypeAttributes(this.this$0, this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ObjectTypeExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ObjectTypeWrapper $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                ObjectTypeExporter.access$exportObjectEntities(this.this$0, this.$ctx, this.$entity);
            }
        }, new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ ObjectTypeExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ ObjectTypeWrapper $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                ObjectTypeExporter.access$exportRole(this.this$0, this.$ctx, this.$entity);
            }
        }};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final void exportRole(ExportContext ctx, ObjectTypeWrapper entity) {
        Sequence<RoleWrapper> $this$forEach$iv = this.roleReader.fetchRolesForObjectType(entity.getId());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RoleWrapper it = (RoleWrapper)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    private final void exportObjectTypeAttributes(ExportContext ctx, ObjectTypeWrapper entity) {
        Sequence $this$forEach$iv = SequencesKt.filter(this.objectTypeAttributeReader.getObjectTypeAttributesByObjectType(entity.getId()), (Function1)((Function1)new Function1<ObjectTypeAttributeWrapper, Boolean>(this, ctx){
            final /* synthetic */ ObjectTypeExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ObjectTypeAttributeWrapper it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ObjectTypeExporter.access$getObjectTypeAttributeValidator$p(this.this$0).validate(this.$ctx, it);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObjectTypeAttributeWrapper it = (ObjectTypeAttributeWrapper)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    private final void exportObjectEntities(ExportContext ctx, ObjectTypeWrapper entity) {
        Sequence<ObjectEntityWrapper> $this$forEach$iv = this.objectEntityReader.getObjectsByObjectTypeId(entity.getId());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObjectEntityWrapper it = (ObjectEntityWrapper)element$iv;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull ObjectTypeWrapper entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public ObjectTypeWrapper extractServerEntity(@NotNull ExportContext ctx, int entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    public static final /* synthetic */ void access$exportObjectTypeAttributes(ObjectTypeExporter $this, ExportContext ctx, ObjectTypeWrapper entity) {
        $this.exportObjectTypeAttributes(ctx, entity);
    }

    public static final /* synthetic */ void access$exportObjectEntities(ObjectTypeExporter $this, ExportContext ctx, ObjectTypeWrapper entity) {
        $this.exportObjectEntities(ctx, entity);
    }

    public static final /* synthetic */ void access$exportRole(ObjectTypeExporter $this, ExportContext ctx, ObjectTypeWrapper entity) {
        $this.exportRole(ctx, entity);
    }

    public static final /* synthetic */ AssetsDataValidator access$getObjectTypeAttributeValidator$p(ObjectTypeExporter $this) {
        return $this.objectTypeAttributeValidator;
    }
}

