/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.assets;

import com.atlassian.jira.migration.export.db.assets.ReferenceWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.assets.ObjectSchema;
import com.atlassian.migration.jira.assets.Reference;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/export/assets/ReferenceExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/assets/ReferenceWrapper;", "Lcom/atlassian/migration/jira/assets/Reference;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nReferenceExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReferenceExporter.kt\ncom/atlassian/jira/migration/export/assets/ReferenceExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class ReferenceExporter
implements Exporter<Integer, ReferenceWrapper, Reference> {
    @NotNull
    private final ExportService exportService;

    @Inject
    public ReferenceExporter(@NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.exportService = exportService;
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, ReferenceWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(Reference.Companion.getEntityType());
    }

    @Override
    @NotNull
    public MRI mriForKey(int entityKey) {
        return MriExtensionsKt.mri$default(Reference.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull ReferenceWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Reference exportData(@NotNull ExportContext ctx, @NotNull ReferenceWrapper entity) {
        MRI mRI;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        MRI mRI2 = this.mriForEntity(entity);
        String string = entity.getName();
        if (string == null) {
            throw new ExportException(this.mriForEntity(entity), ExportErrorCode.ASSET_REFERENCE_HAS_NO_NAME, "Asset Reference with id " + entity.getId() + " for schema with id " + entity.getObjectSchemaId() + " has no name assigned.", null, null, null, null, 120, null);
        }
        String string2 = entity.getDescription();
        String string3 = entity.getColor();
        if (string3 == null) {
            throw new ExportException(this.mriForEntity(entity), ExportErrorCode.ASSET_REFERENCE_HAS_NO_COLOR, "Asset Reference with id " + entity.getId() + " for schema with id " + entity.getObjectSchemaId() + " has no color assigned.", null, null, null, null, 120, null);
        }
        Integer n = entity.getObjectSchemaId();
        if (n != null) {
            void it;
            int n2 = ((Number)n).intValue();
            String string4 = string3;
            String string5 = string2;
            String string6 = string;
            MRI mRI3 = mRI2;
            boolean bl = false;
            MRI mRI4 = MriExtensionsKt.mri$default(ObjectSchema.Companion.getEntityType(), (int)it, null, 2, null);
            mRI2 = mRI3;
            string = string6;
            string2 = string5;
            string3 = string4;
            mRI = mRI4;
        } else {
            mRI = null;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n3 = 32;
        String string7 = null;
        MRI mRI5 = mRI;
        String string8 = string3;
        String string9 = string2;
        String string10 = string;
        MRI mRI6 = mRI2;
        return new Reference(mRI6, string10, string9, string8, mRI5, string7, n3, defaultConstructorMarker);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull ReferenceWrapper entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public ReferenceWrapper extractServerEntity(@NotNull ExportContext ctx, int entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull ReferenceWrapper entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

