/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.assets.validation;

import com.atlassian.jira.migration.export.assets.AssetsConstants;
import com.atlassian.jira.migration.export.assets.validation.AssetsDataValidator;
import com.atlassian.jira.migration.export.db.assets.ObjectHistoryWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.migration.jira.assets.ObjectHistory;
import com.atlassian.migration.jira.assets.ObjectTypeAttribute;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/export/assets/validation/ObjectHistoryValidator;", "Lcom/atlassian/jira/migration/export/assets/validation/AssetsDataValidator;", "Lcom/atlassian/jira/migration/export/db/assets/ObjectHistoryWrapper;", "()V", "isAttributeTypeValid", "", "obj", "isAuthorValid", "isHistoryTypeValid", "validate", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nObjectHistoryValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectHistoryValidator.kt\ncom/atlassian/jira/migration/export/assets/validation/ObjectHistoryValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class ObjectHistoryValidator
implements AssetsDataValidator<ObjectHistoryWrapper> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(ObjectHistoryValidator.class);

    @Override
    public boolean validate(@NotNull ExportContext ctx, @NotNull ObjectHistoryWrapper obj) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        boolean it = bl = this.isHistoryTypeValid(obj) && this.isAttributeTypeValid(obj) && this.isAuthorValid(obj);
        boolean bl2 = false;
        if (!it) {
            log.debug("Skipping ObjectHistory with id: " + obj.getId());
        }
        return bl;
    }

    private final boolean isAuthorValid(ObjectHistoryWrapper obj) {
        return UserRef.Companion.fromString(obj.getActorUserKey()) != null;
    }

    private final boolean isAttributeTypeValid(ObjectHistoryWrapper obj) {
        Integer n = obj.getAttributeType();
        if (n == null) {
            return true;
        }
        n.intValue();
        ObjectTypeAttribute.AttributeType type = ObjectTypeAttribute.AttributeType.Companion.fromId(obj.getAttributeType().intValue());
        return type != null && !AssetsConstants.INSTANCE.getUnsupportedAttributeTypes().contains(type);
    }

    private final boolean isHistoryTypeValid(ObjectHistoryWrapper obj) {
        ObjectHistory.ObjectHistoryType objectHistoryType;
        Integer n = obj.getType();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            objectHistoryType = ObjectHistory.ObjectHistoryType.Companion.fromId(it);
        } else {
            objectHistoryType = null;
        }
        ObjectHistory.ObjectHistoryType historyType = objectHistoryType;
        return historyType != null && !AssetsConstants.INSTANCE.getUnsupportedHistoryTypes().contains(historyType);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/assets/validation/ObjectHistoryValidator$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

