/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core;

import com.atlassian.jira.migration.common.IdentifiableSharePermission;
import com.atlassian.jira.migration.export.core.SharePermissionExportHandler;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.ExportExceptionHolder;
import com.atlassian.jira.migration.export.framework.FallibleExportHandler;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.ExportFiltersKt;
import com.atlassian.jira.migration.jiraservice.JiraExtensionsKt;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.jira.migration.log.MessageEntityIdentifier;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.Project;
import com.atlassian.migration.jira.core.AdhocShareType;
import com.atlassian.migration.jira.core.SharePermission;
import com.atlassian.migration.jira.core.projectrole.ProjectRole;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010 \u001a\u00020!*\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/export/core/SharePermissionExportHandler;", "", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "identifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "handleProjectRoleExportFailed", "Lcom/atlassian/jira/migration/export/framework/ExportException;", "projectRoleMri", "Lcom/atlassian/migration/base/mri/MRI;", "entity", "Lcom/atlassian/jira/migration/common/IdentifiableSharePermission;", "mapSharePermissionData", "Lcom/atlassian/migration/jira/core/SharePermission$SharePermissionData;", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "mriForKey", "entityKey", "", "toGroup", "Lcom/atlassian/migration/jira/core/SharePermission$SharePermissionData$ByGroup;", "toProject", "Lcom/atlassian/migration/jira/core/SharePermission$SharePermissionData$ByProject;", "exceptionHolder", "Lcom/atlassian/jira/migration/export/framework/ExportExceptionHolder;", "toUserOrThrowIfFFisOff", "Lcom/atlassian/migration/jira/core/SharePermission$SharePermissionData$ByUser;", "unsupportedExportException", "identifier", "Lcom/atlassian/jira/migration/log/MessageEntityIdentifier;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nSharePermissionExportHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharePermissionExportHandler.kt\ncom/atlassian/jira/migration/export/core/SharePermissionExportHandler\n+ 2 ExportException.kt\ncom/atlassian/jira/migration/export/framework/FallibleExportHandler\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n155#2,18:146\n173#2,6:165\n180#2,11:172\n1855#3:164\n1856#3:171\n1#4:183\n*S KotlinDebug\n*F\n+ 1 SharePermissionExportHandler.kt\ncom/atlassian/jira/migration/export/core/SharePermissionExportHandler\n*L\n49#1:146,18\n49#1:165,6\n49#1:172,11\n49#1:164\n49#1:171\n*E\n"})
public final class SharePermissionExportHandler {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final EntityIdentifierGenerator identifierGenerator;
    private final Logger log;

    @Inject
    public SharePermissionExportHandler(@NotNull ExportService exportService, @NotNull EntityIdentifierGenerator identifierGenerator) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)identifierGenerator, (String)"identifierGenerator");
        this.exportService = exportService;
        this.identifierGenerator = identifierGenerator;
        this.log = LoggerFactory.getLogger(SharePermissionExportHandler.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final SharePermission.SharePermissionData mapSharePermissionData(@NotNull ExportContext ctx, @NotNull IdentifiableSharePermission entity) {
        List<ExportException> exportErrors$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Function1 entityIdentifierProvider2 = (Function1)new Function1<ExportException, MessageEntityIdentifier>(this, entity){
            final /* synthetic */ SharePermissionExportHandler this$0;
            final /* synthetic */ IdentifiableSharePermission $entity;
            {
                this.this$0 = $receiver;
                this.$entity = $entity;
                super(1);
            }

            @NotNull
            public final MessageEntityIdentifier invoke(@NotNull ExportException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return EntityIdentifierGenerator.generate$default(SharePermissionExportHandler.access$getIdentifierGenerator$p(this.this$0), exception.getEntity(), this.$entity, null, 4, null);
            }
        };
        FallibleExportHandler fallibleExportHandler = FallibleExportHandler.INSTANCE;
        Logger logger2 = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        Logger log$iv = logger2;
        boolean $i$f$runOrThrow = false;
        Throwable unhandledException$iv = null;
        ExportExceptionHolder holder$iv = new ExportExceptionHolder();
        try {
            SharePermission.SharePermissionData sharePermissionData;
            ExportExceptionHolder $this$mapSharePermissionData_u24lambda_u240 = holder$iv;
            boolean bl = false;
            ShareType.Name name = entity.getSharePermission().getType();
            if (Intrinsics.areEqual((Object)name, (Object)ShareType.Name.AUTHENTICATED)) {
                sharePermissionData = (SharePermission.SharePermissionData)new SharePermission.SharePermissionData.Adhoc(AdhocShareType.AUTHENTICATED);
            } else if (Intrinsics.areEqual((Object)name, (Object)ShareType.Name.GLOBAL)) {
                sharePermissionData = (SharePermission.SharePermissionData)new SharePermission.SharePermissionData.Adhoc(AdhocShareType.GLOBAL);
            } else if (Intrinsics.areEqual((Object)name, (Object)ShareType.Name.PROJECT_UNKNOWN)) {
                sharePermissionData = (SharePermission.SharePermissionData)new SharePermission.SharePermissionData.Adhoc(AdhocShareType.PROJECT_UNKNOWN);
            } else if (Intrinsics.areEqual((Object)name, (Object)ShareType.Name.GROUP)) {
                sharePermissionData = (SharePermission.SharePermissionData)this.toGroup(ctx, entity);
            } else if (Intrinsics.areEqual((Object)name, (Object)ShareType.Name.PROJECT)) {
                sharePermissionData = (SharePermission.SharePermissionData)this.toProject(ctx, entity, $this$mapSharePermissionData_u24lambda_u240);
            } else {
                if (!Intrinsics.areEqual((Object)name, (Object)ExportFiltersKt.getUSER())) throw this.unsupportedExportException(entity);
                sharePermissionData = (SharePermission.SharePermissionData)this.toUserOrThrowIfFFisOff(ctx, entity);
            }
            SharePermission.SharePermissionData sharePermissionData2 = sharePermissionData;
            exportErrors$iv = holder$iv.get();
            if (!(!((Collection)exportErrors$iv).isEmpty())) return sharePermissionData2;
        }
        catch (Throwable t$iv) {
            try {
                unhandledException$iv = t$iv;
                throw unhandledException$iv;
            }
            catch (Throwable throwable) {
                List<ExportException> exportErrors$iv2 = holder$iv.get();
                if (!(!((Collection)exportErrors$iv2).isEmpty())) throw throwable;
                if (unhandledException$iv == null) {
                    Iterable $this$forEach$iv$iv = exportErrors$iv2.subList(0, exportErrors$iv2.size() - 1);
                    boolean $i$f$forEach = false;
                    for (Object element$iv$iv : $this$forEach$iv$iv) {
                        ExportException it$iv = (ExportException)element$iv$iv;
                        boolean bl = false;
                        ctx.handleExportFailure(it$iv.getEntity(), it$iv, ctx.getMigrationId() + ": Exporting entity " + entityIdentifierProvider2.invoke((Object)it$iv) + " failed with unhandled exception");
                    }
                    throw (Throwable)CollectionsKt.last(exportErrors$iv2);
                }
                Iterable $this$forEach$iv$iv = exportErrors$iv2;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    ExportException it$iv = (ExportException)element$iv$iv;
                    boolean bl = false;
                    ctx.handleExportFailure(it$iv.getEntity(), it$iv, ctx.getMigrationId() + ": Exporting entity " + entityIdentifierProvider2.invoke((Object)it$iv) + " failed");
                }
                throw throwable;
            }
        }
        Iterable $this$forEach$iv$iv = exportErrors$iv.subList(0, exportErrors$iv.size() - 1);
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            ExportException it$iv = (ExportException)element$iv$iv;
            boolean bl = false;
            ctx.handleExportFailure(it$iv.getEntity(), it$iv, ctx.getMigrationId() + ": Exporting entity " + entityIdentifierProvider2.invoke((Object)it$iv) + " failed with unhandled exception");
        }
        throw (Throwable)CollectionsKt.last(exportErrors$iv);
    }

    private final SharePermission.SharePermissionData.ByGroup toGroup(ExportContext ctx, IdentifiableSharePermission entity) {
        String string;
        block3: {
            block2: {
                string = entity.getSharePermission().getParam1();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                GroupRefModel groupRef = new GroupRefModel(it, entity.getIdentifier(), String.valueOf(entity.getSharePermission().getId()));
                MRI mRI = this.exportService.groupRef(ctx, groupRef);
                string = mRI;
                if (mRI != null) break block3;
            }
            Long l = entity.getSharePermission().getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            MRI mRI = this.mriForKey(((Number)l).longValue());
            String string2 = this.identifier(entity) + " does not contain a valid group";
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_SHARED_PERMISSION_CONTAINS_NO_VALID_GROUP;
            throw new ExportException(mRI, exportErrorCode, string2, null, null, null, null, 120, null);
        }
        String group = string;
        return new SharePermission.SharePermissionData.ByGroup((MRI)group, JiraExtensionsKt.getSharePermissionRights(entity.getSharePermission()));
    }

    private final SharePermission.SharePermissionData.ByUser toUserOrThrowIfFFisOff(ExportContext ctx, IdentifiableSharePermission entity) {
        MRI mRI;
        block3: {
            block2: {
                UserRef userRef = UserRef.Companion.fromString(entity.getSharePermission().getParam1());
                if (userRef == null) break block2;
                UserRef it = userRef;
                boolean bl = false;
                mRI = this.exportService.userRef(ctx, it);
                if (mRI != null) break block3;
            }
            Long l = entity.getSharePermission().getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            MRI mRI2 = this.mriForKey(((Number)l).longValue());
            String string = this.identifier(entity) + " does not contain a valid user";
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_SHARED_PERMISSION_CONTAINS_NO_VALID_USER;
            throw new ExportException(mRI2, exportErrorCode, string, null, null, null, null, 120, null);
        }
        int n = JiraExtensionsKt.getSharePermissionRights(entity.getSharePermission());
        MRI mRI3 = mRI;
        return new SharePermission.SharePermissionData.ByUser(mRI3, n);
    }

    private final SharePermission.SharePermissionData.ByProject toProject(ExportContext ctx, IdentifiableSharePermission entity, ExportExceptionHolder exceptionHolder) {
        MRI projectMri2 = (MRI)exceptionHolder.tryRun(toProject.projectMri.1.INSTANCE, (Function0)new Function0<MRI>(entity, this){
            final /* synthetic */ IdentifiableSharePermission $entity;
            final /* synthetic */ SharePermissionExportHandler this$0;
            {
                this.$entity = $entity;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MRI invoke() {
                String string;
                block3: {
                    block2: {
                        string = this.$entity.getSharePermission().getParam1();
                        if (string == null) break block2;
                        String it = string;
                        boolean bl = false;
                        MRI mRI = MriExtensionsKt.mri$default(Project.Companion.getEntityType(), Long.parseLong(it), null, 2, null);
                        string = mRI;
                        if (mRI != null) break block3;
                    }
                    Long l = this.$entity.getSharePermission().getId();
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                    MRI mRI = this.this$0.mriForKey(((Number)l).longValue());
                    String string2 = SharePermissionExportHandler.access$identifier(this.this$0, this.$entity) + " does not contain a valid project";
                    ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_SHARED_PERMISSION_CONTAINS_NO_VALID_PROJECT;
                    throw new ExportException(mRI, exportErrorCode, string2, null, null, null, null, 120, null);
                }
                return string;
            }
        });
        MRI projectRoleMri2 = (MRI)exceptionHolder.tryRun(toProject.projectRoleMri.1.INSTANCE, (Function0)new Function0<MRI>(entity, this, ctx){
            final /* synthetic */ IdentifiableSharePermission $entity;
            final /* synthetic */ SharePermissionExportHandler this$0;
            final /* synthetic */ ExportContext $ctx;
            {
                this.$entity = $entity;
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(0);
            }

            @Nullable
            public final MRI invoke() {
                MRI mRI;
                String string = this.$entity.getSharePermission().getParam2();
                if (string != null) {
                    String string2 = string;
                    SharePermissionExportHandler sharePermissionExportHandler = this.this$0;
                    ExportContext exportContext = this.$ctx;
                    IdentifiableSharePermission identifiableSharePermission = this.$entity;
                    String it = string2;
                    boolean bl = false;
                    mRI = SharePermissionExportHandler.access$getExportService$p(sharePermissionExportHandler).exportByIdOrThrow(exportContext, ProjectRole.Companion.getEntityType(), Long.parseLong(it), (Function1<? super MRI, ? extends Exception>)((Function1)new Function1<MRI, Exception>(sharePermissionExportHandler, identifiableSharePermission){
                        final /* synthetic */ SharePermissionExportHandler this$0;
                        final /* synthetic */ IdentifiableSharePermission $entity;
                        {
                            this.this$0 = $receiver;
                            this.$entity = $entity;
                            super(1);
                        }

                        @NotNull
                        public final Exception invoke(@NotNull MRI projectRoleMri2) {
                            Intrinsics.checkNotNullParameter((Object)projectRoleMri2, (String)"projectRoleMri");
                            return SharePermissionExportHandler.access$handleProjectRoleExportFailed(this.this$0, projectRoleMri2, this.$entity);
                        }
                    }));
                } else {
                    mRI = null;
                }
                return mRI;
            }
        });
        return new SharePermission.SharePermissionData.ByProject(projectMri2, projectRoleMri2, JiraExtensionsKt.getSharePermissionRights(entity.getSharePermission()));
    }

    private final ExportException handleProjectRoleExportFailed(MRI projectRoleMri2, IdentifiableSharePermission entity) {
        Long l = entity.getSharePermission().getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        MRI mRI = this.mriForKey(((Number)l).longValue());
        String string = this.identifier(entity) + " has reference to " + EntityIdentifierGenerator.generate$default(this.identifierGenerator, projectRoleMri2, null, null, 6, null) + " that failed to be exported";
        ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_SHARED_PERMISSION_REFERRED_PROJECT_ROLE_NOT_EXPORTED;
        return new ExportException(mRI, exportErrorCode, string, null, null, null, null, 120, null);
    }

    private final ExportException unsupportedExportException(IdentifiableSharePermission entity) {
        Long l = entity.getSharePermission().getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        MRI mRI = this.mriForKey(((Number)l).longValue());
        String string = entity.getIdentifier() + " is not supported";
        ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_SHARED_PERMISSION_TYPE_UNSUPPORTED;
        return new ExportException(mRI, exportErrorCode, string, null, null, null, null, 120, null);
    }

    @NotNull
    public final MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(SharePermission.Companion.getEntityType(), entityKey, null, 2, null);
    }

    private final MessageEntityIdentifier identifier(IdentifiableSharePermission $this$identifier) {
        Long l = $this$identifier.getSharePermission().getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return EntityIdentifierGenerator.generate$default(this.identifierGenerator, this.mriForKey(((Number)l).longValue()), $this$identifier, null, 4, null);
    }

    public static final /* synthetic */ EntityIdentifierGenerator access$getIdentifierGenerator$p(SharePermissionExportHandler $this) {
        return $this.identifierGenerator;
    }

    public static final /* synthetic */ MessageEntityIdentifier access$identifier(SharePermissionExportHandler $this, IdentifiableSharePermission $receiver) {
        return $this.identifier($receiver);
    }

    public static final /* synthetic */ ExportService access$getExportService$p(SharePermissionExportHandler $this) {
        return $this.exportService;
    }

    public static final /* synthetic */ ExportException access$handleProjectRoleExportFailed(SharePermissionExportHandler $this, MRI projectRoleMri2, IdentifiableSharePermission entity) {
        return $this.handleProjectRoleExportFailed(projectRoleMri2, entity);
    }
}

