/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.attachment;

import com.atlassian.jira.migration.export.core.attachment.AttachmentMetadata;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.core.Issue;
import com.atlassian.migration.jira.core.attachment.FileAttachment;
import com.google.common.net.MediaType;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0007J\u0015\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/export/core/attachment/FileAttachmentExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/core/attachment/AttachmentMetadata;", "Lcom/atlassian/migration/jira/core/attachment/FileAttachment;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapAuthor", "Lcom/atlassian/migration/base/mri/MRI;", "attachment", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "toInt", "", "", "(Ljava/lang/Boolean;)Ljava/lang/Integer;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nFileAttachmentExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileAttachmentExporter.kt\ncom/atlassian/jira/migration/export/core/attachment/FileAttachmentExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class FileAttachmentExporter
implements Exporter<Long, AttachmentMetadata, FileAttachment> {
    @NotNull
    private final ExportService exportService;
    private final Logger log;

    @Inject
    public FileAttachmentExporter(@NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.exportService = exportService;
        this.log = LoggerFactory.getLogger(FileAttachmentExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, AttachmentMetadata.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(FileAttachment.Companion.getEntityType());
    }

    @Override
    @NotNull
    public FileAttachment exportData(@NotNull ExportContext ctx, @NotNull AttachmentMetadata entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{ctx.getMigrationId(), entity.getId(), entity.getIssueId(), ctx.getExportMode()};
        this.log.info("[MigrationId:{}] Exporting Attachment with id:{} associated with issueId:{} under exportMode:{}", objectArray);
        objectArray = this.mriForEntity(entity);
        MRI mRI = MriExtensionsKt.mri$default(Issue.Companion.getEntityType(), entity.getIssueId(), null, 2, null);
        MRI mRI2 = this.mapAuthor(ctx, entity);
        String string = entity.getMimeType();
        if (string == null) {
            String string2 = MediaType.OCTET_STREAM.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        String string3 = string;
        String string4 = entity.getFilename();
        Comparable<Date> comparable = entity.getCreated();
        if (comparable == null || (comparable = comparable.toInstant()) == null) {
            comparable = Instant.now();
        }
        Comparable<Date> comparable2 = comparable;
        long l = entity.getFilesize();
        Comparable<Boolean> comparable3 = entity.getThumbnailable();
        int n = comparable3 != null && (comparable3 = this.toInt((Boolean)comparable3)) != null ? (Integer)comparable3 : 0;
        Comparable<Boolean> comparable4 = entity.getZip();
        int n2 = comparable4 != null && (comparable4 = this.toInt((Boolean)comparable4)) != null ? (Integer)comparable4 : 0;
        Intrinsics.checkNotNull((Object)comparable2);
        return new FileAttachment((MRI)objectArray, mRI, string3, string4, (Instant)comparable2, l, mRI2, Integer.valueOf(n2), Integer.valueOf(n));
    }

    private final Integer toInt(Boolean $this$toInt) {
        Integer n;
        Boolean bl = $this$toInt;
        if (bl != null) {
            boolean it = bl;
            boolean bl2 = false;
            n = it ? 1 : 0;
        } else {
            n = null;
        }
        return n;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull AttachmentMetadata entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), entity.getIssueId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting users and groups for attachment with id {} having issue {} for migration {} under exportMode {}", objectArray);
        this.mapAuthor(ctx, entity);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull AttachmentMetadata entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(FileAttachment.Companion.getEntityType(), entityKey, null, 2, null);
    }

    private final MRI mapAuthor(ExportContext ctx, AttachmentMetadata attachment) {
        MRI mRI;
        UserRef userRef = UserRef.Companion.fromString(attachment.getAuthorKey());
        if (userRef != null) {
            UserRef it = userRef;
            boolean bl = false;
            mRI = this.exportService.userRef(ctx, it);
        } else {
            mRI = null;
        }
        return mRI;
    }

    @Override
    @Nullable
    public AttachmentMetadata extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull AttachmentMetadata entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

