/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.comment;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.TextSanitizer;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.workers.attachments.TextFieldConverterService;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.core.text.TextDocument;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 #2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001#B\u001f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J$\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0002H\u0016J\b\u0010\"\u001a\u00020\u0015H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/atlassian/jira/migration/export/core/comment/CommentExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/issue/comments/Comment;", "Lcom/atlassian/migration/jira/core/Comment;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "textFieldConverterService", "Lcom/atlassian/jira/migration/workers/attachments/TextFieldConverterService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/workers/attachments/TextFieldConverterService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapBody", "Lcom/atlassian/migration/core/text/TextDocument;", "truncateMessage", "", "mapCreatedBy", "Lcom/atlassian/migration/base/mri/MRI;", "comment", "mapUpdatedBy", "mapVisibility", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCommentExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentExporter.kt\ncom/atlassian/jira/migration/export/core/comment/CommentExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class CommentExporter
implements Exporter<Long, Comment, com.atlassian.migration.jira.core.Comment> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final TextFieldConverterService textFieldConverterService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private static final Logger log = LoggerFactory.getLogger(CommentExporter.class);

    @Inject
    public CommentExporter(@NotNull ExportService exportService, @NotNull TextFieldConverterService textFieldConverterService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)textFieldConverterService, (String)"textFieldConverterService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.exportService = exportService;
        this.textFieldConverterService = textFieldConverterService;
        this.migrationFeatures = migrationFeatures;
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, Comment.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(com.atlassian.migration.jira.core.Comment.Companion.getEntityType());
    }

    @Override
    @NotNull
    public com.atlassian.migration.jira.core.Comment exportData(@NotNull ExportContext ctx, @NotNull Comment entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[4];
        objectArray[0] = ctx.getMigrationId();
        objectArray[1] = entity.getId();
        Issue issue2 = entity.getIssue();
        objectArray[2] = issue2 != null ? issue2.getId() : null;
        objectArray[3] = ctx.getExportMode();
        log.debug("[MigrationId:{}] Exporting jiraComment with id {} associated with issueId:{} under exportMode:{}", objectArray);
        MRI mRI = this.mriForEntity(entity);
        MRI mRI2 = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, entity.getIssue(), false, 4, null);
        TextDocument textDocument = this.mapBody(ctx, entity, "issue " + entity.getIssue().getKey() + " comment " + entity.getId());
        MRI mRI3 = this.mapCreatedBy(ctx, entity);
        MRI mRI4 = this.mapUpdatedBy(ctx, entity);
        Instant instant = entity.getCreated().toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        Date date = entity.getUpdated();
        return new com.atlassian.migration.jira.core.Comment(mRI, mRI2, textDocument, mRI3, mRI4, instant, date != null ? date.toInstant() : null, this.mapVisibility(ctx, entity), null, null, 768, null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull Comment entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[4];
        objectArray[0] = entity.getId();
        Issue issue2 = entity.getIssue();
        objectArray[1] = issue2 != null ? issue2.getId() : null;
        objectArray[2] = ctx.getMigrationId();
        objectArray[3] = ctx.getExportMode();
        log.debug("Exporting users and groups for jiraComment {} with issue {} for migration {} under exportMode {}", objectArray);
        this.mapCreatedBy(ctx, entity);
        this.mapUpdatedBy(ctx, entity);
        this.mapVisibility(ctx, entity);
        CommentExporter.mapBody$default(this, ctx, entity, null, 4, null);
    }

    private final TextDocument mapBody(ExportContext ctx, Comment entity, String truncateMessage) {
        String content;
        String string;
        if (this.migrationFeatures.getEnableConvertBigTextFields()) {
            String string2 = entity.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getBody(...)");
            Long l = entity.getIssue().getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            string = this.textFieldConverterService.convertToAttachment(ctx, string2, ((Number)l).longValue(), "Comment");
        } else {
            String string3 = entity.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getBody(...)");
            Logger logger2 = log;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
            string = TextSanitizer.sanitizedText$default(TextSanitizer.INSTANCE, string3, logger2, truncateMessage, 0, 8, null);
        }
        String it = content = string;
        boolean bl = false;
        this.exportService.extractUserRefs(ctx, it);
        return (TextDocument)new TextDocument.Wiki(it);
    }

    static /* synthetic */ TextDocument mapBody$default(CommentExporter commentExporter, ExportContext exportContext, Comment comment, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return commentExporter.mapBody(exportContext, comment, string);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull Comment entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(com.atlassian.migration.jira.core.Comment.Companion.getEntityType(), entityKey, null, 2, null);
    }

    private final MRI mapCreatedBy(ExportContext ctx, Comment comment) {
        MRI mRI;
        ApplicationUser applicationUser = comment.getAuthorApplicationUser();
        UserRef userRef = UserRef.Companion.fromString(applicationUser != null ? applicationUser.getKey() : null);
        if (userRef != null) {
            UserRef it = userRef;
            boolean bl = false;
            mRI = this.exportService.userRef(ctx, it);
        } else {
            mRI = null;
        }
        return mRI;
    }

    private final MRI mapUpdatedBy(ExportContext ctx, Comment comment) {
        MRI mRI;
        ApplicationUser applicationUser = comment.getUpdateAuthorApplicationUser();
        UserRef userRef = UserRef.Companion.fromString(applicationUser != null ? applicationUser.getKey() : null);
        if (userRef != null) {
            UserRef it = userRef;
            boolean bl = false;
            mRI = this.exportService.userRef(ctx, it);
        } else {
            mRI = null;
        }
        return mRI;
    }

    private final MRI mapVisibility(ExportContext ctx, Comment comment) {
        String string;
        block6: {
            block5: {
                string = comment.getGroupLevel();
                if (string == null) break block5;
                String it = string;
                boolean bl = false;
                MRI mRI = this.exportService.groupRef(ctx, new GroupRefModel(it, "Comment ", String.valueOf(comment.getId())));
                string = mRI;
                if (mRI != null) break block6;
            }
            ProjectRole projectRole = comment.getRoleLevel();
            if (projectRole != null) {
                ProjectRole it = projectRole;
                boolean bl = false;
                string = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
            } else {
                string = null;
            }
        }
        return string;
    }

    @Override
    @Nullable
    public Comment extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull Comment entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/core/comment/CommentExporter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

