/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.comment;

import com.atlassian.jira.migration.config.JiraServiceDeskNotInstalled;
import com.atlassian.jira.migration.export.core.comment.CommentExporterService;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.jira.servicedesk.Comment;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskNotInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/export/core/comment/JiraCommentExporterService;", "Lcom/atlassian/jira/migration/export/core/comment/CommentExporterService;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;)V", "exportComment", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "comment", "Lcom/atlassian/jira/issue/comments/Comment;", "jira-migration-plugin"})
public final class JiraCommentExporterService
implements CommentExporterService {
    @NotNull
    private final ExportService exportService;

    @Inject
    public JiraCommentExporterService(@NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.exportService = exportService;
    }

    @Override
    public void exportComment(@NotNull ExportContext ctx, @NotNull com.atlassian.jira.issue.comments.Comment comment) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        if (Intrinsics.areEqual((Object)ctx.getProject().getProjectTypeKey().getKey(), (Object)"service_desk")) {
            throw new ExportException(MriExtensionsKt.mri$default(Comment.Companion.getEntityType(), comment, null, 2, null), ExportErrorCode.PRJ_PROJECT_TYPE_UNSUPPORTED, "ServiceDeskComment not expected for a Non-JSD project", null, null, null, null, 120, null);
        }
        ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, comment, false, 4, null);
    }
}

