/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.comment;

import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.migration.config.JiraServiceDeskInstalled;
import com.atlassian.jira.migration.db.servicedesk.comment.ServiceDeskCommentData;
import com.atlassian.jira.migration.export.core.comment.CommentExporterService;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.JsdExportUtil;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraServiceDeskInstalled.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/export/core/comment/JsdCommentExporterService;", "Lcom/atlassian/jira/migration/export/core/comment/CommentExporterService;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "jsdExportUtil", "Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;)V", "exportComment", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "comment", "Lcom/atlassian/jira/issue/comments/Comment;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJsdCommentExporterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsdCommentExporterService.kt\ncom/atlassian/jira/migration/export/core/comment/JsdCommentExporterService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,29:1\n1#2:30\n*E\n"})
public final class JsdCommentExporterService
implements CommentExporterService {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final JsdExportUtil jsdExportUtil;

    @Inject
    public JsdCommentExporterService(@NotNull ExportService exportService, @NotNull JsdExportUtil jsdExportUtil) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)jsdExportUtil, (String)"jsdExportUtil");
        this.exportService = exportService;
        this.jsdExportUtil = jsdExportUtil;
    }

    @Override
    public void exportComment(@NotNull ExportContext ctx, @NotNull Comment comment) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        if (this.jsdExportUtil.isJsdProjectEligibleForMigration(ctx)) {
            ServiceDeskCommentData sdCommentData;
            Long l = comment.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            ServiceDeskCommentData it = sdCommentData = new ServiceDeskCommentData(comment, ctx.isPublicComment(((Number)l).longValue()));
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        } else {
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, comment, false, 4, null);
        }
    }
}

