/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.customfield;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.migration.export.core.customfield.CustomFieldConfigSchemeWrapper;
import com.atlassian.jira.migration.export.core.customfield.CustomFieldDefaultValueWrapper;
import com.atlassian.jira.migration.export.core.customfield.CustomFieldValueParser;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.classic.customfield.CustomFieldDefaultValue;
import com.atlassian.migration.jira.core.customfield.CustomFieldValue;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.GregorianCalendar;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 $2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001$B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J0\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u0016H\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/atlassian/jira/migration/export/core/customfield/CustomFieldDefaultValueExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/core/customfield/CustomFieldDefaultValueWrapper;", "Lcom/atlassian/migration/jira/classic/customfield/CustomFieldDefaultValue;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "customFieldValueParser", "Lcom/atlassian/jira/migration/export/core/customfield/CustomFieldValueParser;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/core/customfield/CustomFieldValueParser;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapDefaultValue", "Lcom/atlassian/migration/jira/core/customfield/CustomFieldValue;", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "parseDefaultValue", "fieldType", "fieldMri", "Lcom/atlassian/jira/issue/fields/CustomField;", "value", "", "postConstruct", "Companion", "jira-migration-plugin"})
public final class CustomFieldDefaultValueExporter
implements Exporter<String, CustomFieldDefaultValueWrapper, CustomFieldDefaultValue> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final CustomFieldValueParser customFieldValueParser;
    private final Logger log;
    @NotNull
    private static final Timestamp USE_NOW_TIMESTAMP = new Timestamp(new GregorianCalendar(1, 0, 1).getTime().getTime());
    @NotNull
    private static final Instant USE_NOW_INSTANT;

    @Inject
    public CustomFieldDefaultValueExporter(@NotNull ExportService exportService, @NotNull CustomFieldValueParser customFieldValueParser) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)customFieldValueParser, (String)"customFieldValueParser");
        this.exportService = exportService;
        this.customFieldValueParser = customFieldValueParser;
        this.log = LoggerFactory.getLogger(CustomFieldDefaultValueExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, CustomFieldDefaultValueWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(CustomFieldDefaultValue.Companion.getEntityType());
    }

    @Override
    @NotNull
    public CustomFieldDefaultValue exportData(@NotNull ExportContext ctx, @NotNull CustomFieldDefaultValueWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        CustomFieldConfigSchemeWrapper customFieldConfigScheme = entity.getCustomFieldConfigScheme();
        Object[] objectArray = new Object[3];
        objectArray[0] = ctx.getMigrationId();
        CustomField customField = entity.getCustomField();
        objectArray[1] = customField != null ? customField.getId() : null;
        objectArray[2] = ctx.getExportMode();
        this.log.debug("[MigrationId:{}] Exporting customFieldDefaultValue associated with customFieldId {} under exportMode:{}", objectArray);
        return new CustomFieldDefaultValue(this.mriForEntity(entity), ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, customFieldConfigScheme, false, 4, null), this.mapDefaultValue(ctx, entity), null, 8, null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull CustomFieldDefaultValueWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[3];
        CustomField customField = entity.getCustomField();
        objectArray[0] = customField != null ? customField.getId() : null;
        objectArray[1] = ctx.getMigrationId();
        objectArray[2] = ctx.getExportMode();
        this.log.debug("Exporting users and groups for customField {} for migration {} under exportMode {}", objectArray);
        this.mapDefaultValue(ctx, entity);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull CustomFieldDefaultValueWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        EntityType entityType = CustomFieldDefaultValue.Companion.getEntityType();
        Long l = entity.getCustomFieldConfigScheme().getFieldConfigScheme().getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return MriExtensionsKt.mri$default(entityType, l, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForKey(@NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return MriExtensionsKt.mri$default(CustomFieldDefaultValue.Companion.getEntityType(), entityKey, null, 2, null);
    }

    private final CustomFieldValue mapDefaultValue(ExportContext ctx, CustomFieldDefaultValueWrapper entity) {
        String string = entity.getCustomField().getCustomFieldType().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        EntityType entityType = com.atlassian.migration.jira.classic.customfield.CustomField.Companion.getEntityType();
        Long l = entity.getCustomField().getIdAsLong();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getIdAsLong(...)");
        return this.parseDefaultValue(ctx, string, MriExtensionsKt.mri$default(entityType, l, null, 2, null), entity.getCustomField(), entity.getDefaultValue());
    }

    private final CustomFieldValue parseDefaultValue(ExportContext ctx, String fieldType, MRI fieldMri, CustomField entity, Object value) {
        CustomFieldValue customFieldValue;
        if (Intrinsics.areEqual((Object)fieldType, (Object)"com.atlassian.jira.plugin.system.customfieldtypes:datetime")) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type java.sql.Timestamp");
            Instant valueAsInstant = Intrinsics.areEqual((Object)((Timestamp)value), (Object)USE_NOW_TIMESTAMP) ? USE_NOW_INSTANT : ((Timestamp)value).toInstant();
            Intrinsics.checkNotNull((Object)valueAsInstant);
            customFieldValue = (CustomFieldValue)new CustomFieldValue.DateTimeFieldValue(fieldMri, valueAsInstant);
        } else {
            customFieldValue = CustomFieldValueParser.parseValue$default(this.customFieldValueParser, ctx, fieldType, fieldMri, entity, value, null, 32, null);
        }
        return customFieldValue;
    }

    @Override
    @Nullable
    public CustomFieldDefaultValueWrapper extractServerEntity(@NotNull ExportContext ctx, @NotNull String entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull CustomFieldDefaultValueWrapper entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    static {
        Instant instant = Instant.parse("0001-01-01T00:00:00Z");
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"parse(...)");
        USE_NOW_INSTANT = instant;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/export/core/customfield/CustomFieldDefaultValueExporter$Companion;", "", "()V", "USE_NOW_INSTANT", "Ljava/time/Instant;", "getUSE_NOW_INSTANT", "()Ljava/time/Instant;", "USE_NOW_TIMESTAMP", "Ljava/sql/Timestamp;", "getUSE_NOW_TIMESTAMP", "()Ljava/sql/Timestamp;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Timestamp getUSE_NOW_TIMESTAMP() {
            return USE_NOW_TIMESTAMP;
        }

        @NotNull
        public final Instant getUSE_NOW_INSTANT() {
            return USE_NOW_INSTANT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

