/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.customfield;

import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.export.core.customfield.CustomFieldConfigSchemeWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.CustomFieldUtils;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.customfield.ManagedCustomFieldKey;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0002./B\u001f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ$\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0016J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u0003H\u0007J\u0018\u0010(\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u0003H\u0007J\u0010\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020\u0003H\u0016J\u0010\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\u0002H\u0016J\b\u0010-\u001a\u00020 H\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00060"}, d2={"Lcom/atlassian/jira/migration/export/core/customfield/CustomFieldExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/issue/fields/CustomField;", "Lcom/atlassian/migration/jira/classic/customfield/CustomField;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "customFieldUtils", "Lcom/atlassian/jira/migration/export/utils/CustomFieldUtils;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/export/utils/CustomFieldUtils;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "supportedCustomFieldKeyToSearchers", "", "", "Lcom/atlassian/jira/migration/export/core/customfield/CustomFieldExporter$ValidTypeKey;", "getSupportedCustomFieldKeyToSearchers", "()Ljava/util/Map;", "supportedCustomFieldKeyToSearchers$delegate", "Lkotlin/Lazy;", "childrenActions", "", "Lkotlin/Function0;", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportData", "getCloudCFTypeKey", "getValidCfSearcherKey", "customField", "mapCustomFieldConfigScheme", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "SupportedCustomFieldTypeKeys", "ValidTypeKey", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCustomFieldExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomFieldExporter.kt\ncom/atlassian/jira/migration/export/core/customfield/CustomFieldExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1855#2,2:131\n1#3:133\n*S KotlinDebug\n*F\n+ 1 CustomFieldExporter.kt\ncom/atlassian/jira/migration/export/core/customfield/CustomFieldExporter\n*L\n80#1:131,2\n*E\n"})
public final class CustomFieldExporter
implements Exporter<Long, CustomField, com.atlassian.migration.jira.classic.customfield.CustomField> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final CustomFieldUtils customFieldUtils;
    private final Logger log;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final Lazy supportedCustomFieldKeyToSearchers$delegate;

    @Inject
    public CustomFieldExporter(@NotNull ExportService exportService, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull CustomFieldUtils customFieldUtils) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)customFieldUtils, (String)"customFieldUtils");
        this.exportService = exportService;
        this.customFieldUtils = customFieldUtils;
        this.log = LoggerFactory.getLogger(CustomFieldExporter.class);
        this.objectMapper = objectMapperFactory.createObjectMapper();
        this.supportedCustomFieldKeyToSearchers$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends ValidTypeKey>>(this){
            final /* synthetic */ CustomFieldExporter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, ValidTypeKey> invoke() {
                Map map;
                Closeable closeable = this.this$0.getClass().getClassLoader().getResourceAsStream("supported-cf-type-keys-and-searcher-keys.json");
                CustomFieldExporter customFieldExporter = this.this$0;
                Throwable throwable = null;
                try {
                    void $this$associateByTo$iv$iv;
                    InputStream inputStream = (InputStream)closeable;
                    boolean bl = false;
                    SupportedCustomFieldTypeKeys supportedCustomFieldKeys = (SupportedCustomFieldTypeKeys)CustomFieldExporter.access$getObjectMapper$p(customFieldExporter).readValue(inputStream, SupportedCustomFieldTypeKeys.class);
                    Iterable $this$associateBy$iv = supportedCustomFieldKeys.getValidTypeKeys();
                    boolean $i$f$associateBy = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                    Iterable iterable = $this$associateBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                    boolean $i$f$associateByTo = false;
                    for (T element$iv$iv : $this$associateByTo$iv$iv) {
                        void it;
                        ValidTypeKey validTypeKey = (ValidTypeKey)element$iv$iv;
                        Map map2 = destination$iv$iv;
                        boolean bl2 = false;
                        map2.put(it.getKey(), element$iv$iv);
                    }
                    map = destination$iv$iv;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return map;
            }
        }));
    }

    private final Map<String, ValidTypeKey> getSupportedCustomFieldKeyToSearchers() {
        Lazy lazy = this.supportedCustomFieldKeyToSearchers$delegate;
        return (Map)lazy.getValue();
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, CustomField.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(com.atlassian.migration.jira.classic.customfield.CustomField.Companion.getEntityType());
    }

    @Override
    @NotNull
    public com.atlassian.migration.jira.classic.customfield.CustomField exportData(@NotNull ExportContext ctx, @NotNull CustomField entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{ctx.getMigrationId(), entity.getId(), ctx.getExportMode()};
        this.log.debug("[MigrationId:{}] Exporting jiraCustomField with id {} under exportMode:{}", objectArray);
        MRI mri = this.mriForEntity(entity);
        String string = entity.getUntranslatedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUntranslatedName(...)");
        String string2 = entity.getUntranslatedDescription();
        String string3 = this.getCloudCFTypeKey(ctx, entity);
        String string4 = this.getValidCfSearcherKey(ctx, entity);
        Boolean bl = this.customFieldUtils.isFieldLocked(ctx, entity);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"isFieldLocked(...)");
        boolean bl2 = bl;
        ManagedCustomFieldKey managedCustomFieldKey = this.customFieldUtils.getManagedCustomFieldKey(entity);
        String string5 = entity.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
        String string6 = entity.getCustomFieldType().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getKey(...)");
        return new com.atlassian.migration.jira.classic.customfield.CustomField(mri, string, string2, string3, string4, bl2, managedCustomFieldKey, this.customFieldUtils.getCloudKeyMapping(ctx, string5, string6), null, null, null, null, 3840, null);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull CustomField entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return CollectionsKt.listOf((Object)new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ CustomFieldExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ CustomField $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                this.this$0.mapCustomFieldConfigScheme(this.$ctx, this.$entity);
            }
        });
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull CustomField entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getIdAsLong();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getIdAsLong(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(com.atlassian.migration.jira.classic.customfield.CustomField.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @VisibleForTesting
    public final void mapCustomFieldConfigScheme(@NotNull ExportContext ctx, @NotNull CustomField customField) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)customField, (String)"customField");
        List list = customField.getConfigurationSchemes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurationSchemes(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FieldConfigScheme configScheme = (FieldConfigScheme)element$iv;
            boolean bl = false;
            ExportOrThrow exportOrThrow = this.exportService;
            Intrinsics.checkNotNull((Object)configScheme);
            ExportOrThrow.DefaultImpls.exportOrThrow$default(exportOrThrow, ctx, new CustomFieldConfigSchemeWrapper(configScheme, customField), false, 4, null);
        }
    }

    @VisibleForTesting
    @Nullable
    public final String getValidCfSearcherKey(@NotNull ExportContext ctx, @NotNull CustomField customField) {
        String string;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)customField, (String)"customField");
        CustomFieldSearcher customFieldSearcher = customField.getCustomFieldSearcher();
        String searcherKey = customFieldSearcher != null && (customFieldSearcher = customFieldSearcher.getDescriptor()) != null ? customFieldSearcher.getCompleteKey() : null;
        String string2 = customField.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = customField.getCustomFieldType().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getKey(...)");
        if (this.customFieldUtils.getCloudKeyMapping(ctx, string2, string3) != null) {
            string = searcherKey;
        } else {
            String string4 = customField.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            String string5 = customField.getCustomFieldType().getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getKey(...)");
            if (this.customFieldUtils.isForgeCF(ctx, string4, string5)) {
                string = "com.atlassian.jira.plugin.system.customfieldtypes:forgeCustomFieldSearcher";
            } else {
                String string6 = searcherKey;
                if (string6 != null) {
                    String it = string6;
                    boolean bl = false;
                    ValidTypeKey validTypeKey = this.getSupportedCustomFieldKeyToSearchers().get(customField.getCustomFieldType().getKey());
                    if (validTypeKey != null) {
                        String string7;
                        ValidTypeKey $this$getValidCfSearcherKey_u24lambda_u243_u24lambda_u242 = validTypeKey;
                        boolean bl2 = false;
                        String it2 = string7 = it;
                        boolean bl3 = false;
                        string = $this$getValidCfSearcherKey_u24lambda_u243_u24lambda_u242.getAllSearcherKeys().contains(it2) ? string7 : null;
                        if (string == null) {
                            string = $this$getValidCfSearcherKey_u24lambda_u243_u24lambda_u242.getDefaultSearcherKey();
                        }
                    } else {
                        string = null;
                    }
                } else {
                    string = null;
                }
            }
        }
        return string;
    }

    private final String getCloudCFTypeKey(ExportContext ctx, CustomField entity) {
        String string = entity.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = entity.getCustomFieldType().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
        String forgeTypeKey = this.customFieldUtils.getForgeTypeKey(ctx, string, string2);
        if (forgeTypeKey != null) {
            return forgeTypeKey;
        }
        String string3 = entity.getCustomFieldType().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getKey(...)");
        return string3;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull CustomField entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public CustomField extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(CustomFieldExporter $this) {
        return $this.objectMapper;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/export/core/customfield/CustomFieldExporter$SupportedCustomFieldTypeKeys;", "", "validTypeKeys", "", "Lcom/atlassian/jira/migration/export/core/customfield/CustomFieldExporter$ValidTypeKey;", "(Ljava/util/List;)V", "getValidTypeKeys", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jira-migration-plugin"})
    private static final class SupportedCustomFieldTypeKeys {
        @NotNull
        private final List<ValidTypeKey> validTypeKeys;

        public SupportedCustomFieldTypeKeys(@NotNull List<ValidTypeKey> validTypeKeys) {
            Intrinsics.checkNotNullParameter(validTypeKeys, (String)"validTypeKeys");
            this.validTypeKeys = validTypeKeys;
        }

        @NotNull
        public final List<ValidTypeKey> getValidTypeKeys() {
            return this.validTypeKeys;
        }

        @NotNull
        public final List<ValidTypeKey> component1() {
            return this.validTypeKeys;
        }

        @NotNull
        public final SupportedCustomFieldTypeKeys copy(@NotNull List<ValidTypeKey> validTypeKeys) {
            Intrinsics.checkNotNullParameter(validTypeKeys, (String)"validTypeKeys");
            return new SupportedCustomFieldTypeKeys(validTypeKeys);
        }

        public static /* synthetic */ SupportedCustomFieldTypeKeys copy$default(SupportedCustomFieldTypeKeys supportedCustomFieldTypeKeys, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = supportedCustomFieldTypeKeys.validTypeKeys;
            }
            return supportedCustomFieldTypeKeys.copy(list);
        }

        @NotNull
        public String toString() {
            return "SupportedCustomFieldTypeKeys(validTypeKeys=" + this.validTypeKeys + ')';
        }

        public int hashCode() {
            return ((Object)this.validTypeKeys).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SupportedCustomFieldTypeKeys)) {
                return false;
            }
            SupportedCustomFieldTypeKeys supportedCustomFieldTypeKeys = (SupportedCustomFieldTypeKeys)other;
            return Intrinsics.areEqual(this.validTypeKeys, supportedCustomFieldTypeKeys.validTypeKeys);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J/\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/export/core/customfield/CustomFieldExporter$ValidTypeKey;", "", "key", "", "defaultSearcherKey", "allSearcherKeys", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "getAllSearcherKeys", "()Ljava/util/Set;", "getDefaultSearcherKey", "()Ljava/lang/String;", "getKey", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    private static final class ValidTypeKey {
        @NotNull
        private final String key;
        @Nullable
        private final String defaultSearcherKey;
        @NotNull
        private final Set<String> allSearcherKeys;

        public ValidTypeKey(@NotNull String key, @Nullable String defaultSearcherKey, @NotNull Set<String> allSearcherKeys) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(allSearcherKeys, (String)"allSearcherKeys");
            this.key = key;
            this.defaultSearcherKey = defaultSearcherKey;
            this.allSearcherKeys = allSearcherKeys;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @Nullable
        public final String getDefaultSearcherKey() {
            return this.defaultSearcherKey;
        }

        @NotNull
        public final Set<String> getAllSearcherKeys() {
            return this.allSearcherKeys;
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        @Nullable
        public final String component2() {
            return this.defaultSearcherKey;
        }

        @NotNull
        public final Set<String> component3() {
            return this.allSearcherKeys;
        }

        @NotNull
        public final ValidTypeKey copy(@NotNull String key, @Nullable String defaultSearcherKey, @NotNull Set<String> allSearcherKeys) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(allSearcherKeys, (String)"allSearcherKeys");
            return new ValidTypeKey(key, defaultSearcherKey, allSearcherKeys);
        }

        public static /* synthetic */ ValidTypeKey copy$default(ValidTypeKey validTypeKey, String string, String string2, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                string = validTypeKey.key;
            }
            if ((n & 2) != 0) {
                string2 = validTypeKey.defaultSearcherKey;
            }
            if ((n & 4) != 0) {
                set = validTypeKey.allSearcherKeys;
            }
            return validTypeKey.copy(string, string2, set);
        }

        @NotNull
        public String toString() {
            return "ValidTypeKey(key=" + this.key + ", defaultSearcherKey=" + this.defaultSearcherKey + ", allSearcherKeys=" + this.allSearcherKeys + ')';
        }

        public int hashCode() {
            int result2 = this.key.hashCode();
            result2 = result2 * 31 + (this.defaultSearcherKey == null ? 0 : this.defaultSearcherKey.hashCode());
            result2 = result2 * 31 + ((Object)this.allSearcherKeys).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValidTypeKey)) {
                return false;
            }
            ValidTypeKey validTypeKey = (ValidTypeKey)other;
            if (!Intrinsics.areEqual((Object)this.key, (Object)validTypeKey.key)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.defaultSearcherKey, (Object)validTypeKey.defaultSearcherKey)) {
                return false;
            }
            return Intrinsics.areEqual(this.allSearcherKeys, validTypeKey.allSearcherKeys);
        }
    }
}

