/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.customfield;

import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.migration.export.core.customfield.CustomFieldOptionsWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.classic.customfield.CustomFieldOption;
import com.atlassian.migration.jira.classic.customfield.CustomFieldOptionList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/export/core/customfield/CustomFieldOptionListExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/core/customfield/CustomFieldOptionsWrapper;", "Lcom/atlassian/migration/jira/classic/customfield/CustomFieldOptionList;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "", "toCustomFieldOption", "Lcom/atlassian/migration/jira/classic/customfield/CustomFieldOption;", "option", "Lcom/atlassian/jira/issue/customfields/option/Option;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCustomFieldOptionListExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomFieldOptionListExporter.kt\ncom/atlassian/jira/migration/export/core/customfield/CustomFieldOptionListExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1360#2:67\n1446#2,5:68\n1549#2:73\n1620#2,3:74\n*S KotlinDebug\n*F\n+ 1 CustomFieldOptionListExporter.kt\ncom/atlassian/jira/migration/export/core/customfield/CustomFieldOptionListExporter\n*L\n45#1:67\n45#1:68,5\n46#1:73\n46#1:74,3\n*E\n"})
public final class CustomFieldOptionListExporter
implements Exporter<String, CustomFieldOptionsWrapper, CustomFieldOptionList> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private final Logger log;

    @Inject
    public CustomFieldOptionListExporter(@NotNull ExportService exportService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.exportService = exportService;
        this.migrationFeatures = migrationFeatures;
        this.log = LoggerFactory.getLogger(CustomFieldOptionListExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, CustomFieldOptionsWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(CustomFieldOptionList.Companion.getEntityType());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CustomFieldOptionList exportData(@NotNull ExportContext ctx, @NotNull CustomFieldOptionsWrapper entity) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.log.debug("[MigrationId:{}] Exporting customFieldOptionList under exportMode:{}", (Object)ctx.getMigrationId(), (Object)ctx.getExportMode());
        MRI mRI = this.mriForEntity(entity);
        MRI mRI2 = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, entity.getCustomFieldConfigScheme(), false, 4, null);
        List list = entity.getOptions().getRootOptions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRootOptions(...)");
        Iterable iterable = CollectionsKt.filterNotNull((Iterable)list);
        MRI mRI3 = mRI2;
        MRI mRI4 = mRI;
        boolean $i$f$flatMap = false;
        void var5_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Option it = (Option)element$iv$iv;
            boolean bl = false;
            Collection collection = CollectionsKt.listOf((Object)it);
            List list2 = it.getChildOptions();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildOptions(...)");
            list$iv$iv = CollectionsKt.plus((Collection)collection, (Iterable)list2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection<CustomFieldOption> collection = (List)destination$iv$iv;
        $this$flatMap$iv = collection;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CustomFieldOption customFieldOption;
            void option;
            list$iv$iv = (Option)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (this.migrationFeatures.getDisableMissingCustomFieldOptionFix()) {
                Intrinsics.checkNotNull((Object)option);
                customFieldOption = this.toCustomFieldOption((Option)option);
            } else {
                customFieldOption = this.exportService.exportObjectOrThrow(ctx, option, CustomFieldOption.class);
            }
            collection.add(customFieldOption);
        }
        collection = (List)destination$iv$iv;
        List list3 = collection;
        MRI mRI5 = mRI3;
        MRI mRI6 = mRI4;
        return new CustomFieldOptionList(mRI6, mRI5, list3);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull CustomFieldOptionsWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        EntityType entityType = CustomFieldOptionList.Companion.getEntityType();
        Long l = entity.getCustomFieldConfigScheme().getFieldConfigScheme().getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return MriExtensionsKt.mri$default(entityType, l, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForKey(@NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return MriExtensionsKt.mri$default(CustomFieldOptionList.Companion.getEntityType(), entityKey, null, 2, null);
    }

    private final CustomFieldOption toCustomFieldOption(Option option) {
        long l;
        Long l2;
        Option $this$toCustomFieldOption_u24lambda_u242 = option;
        boolean bl = false;
        EntityType entityType = CustomFieldOption.Companion.getEntityType();
        Long l3 = $this$toCustomFieldOption_u24lambda_u242.getOptionId();
        Intrinsics.checkNotNull((Object)l3);
        MRI mRI = MriExtensionsKt.mri$default(entityType, l3, null, 2, null);
        String string = $this$toCustomFieldOption_u24lambda_u242.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        Boolean bl2 = $this$toCustomFieldOption_u24lambda_u242.getDisabled();
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"getDisabled(...)");
        boolean bl3 = bl2;
        Long l4 = l2 = $this$toCustomFieldOption_u24lambda_u242.getSequence();
        if (l4 == null) {
            l = 0L;
        } else {
            Intrinsics.checkNotNull((Object)l4);
            l = l2;
        }
        Option option2 = $this$toCustomFieldOption_u24lambda_u242.getParentOption();
        return new CustomFieldOption(mRI, string, bl3, l, option2 != null ? option2.getValue() : null, null, 32, null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull CustomFieldOptionsWrapper entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public CustomFieldOptionsWrapper extractServerEntity(@NotNull ExportContext ctx, @NotNull String entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull CustomFieldOptionsWrapper entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

