/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.customfield;

import com.atlassian.jira.migration.export.core.customfield.CustomFieldProjectAssociationWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.MRIType;
import com.atlassian.migration.jira.classic.customfield.CustomFieldProjectAssociation;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/export/core/customfield/CustomFieldProjectAssociationExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/core/customfield/CustomFieldProjectAssociationWrapper;", "Lcom/atlassian/migration/jira/classic/customfield/CustomFieldProjectAssociation;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/project/ProjectManager;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "", "jira-migration-plugin"})
public final class CustomFieldProjectAssociationExporter
implements Exporter<String, CustomFieldProjectAssociationWrapper, CustomFieldProjectAssociation> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ProjectManager projectManager;
    private final Logger log;

    @Inject
    public CustomFieldProjectAssociationExporter(@NotNull ExportService exportService, @NotNull ProjectManager projectManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        this.exportService = exportService;
        this.projectManager = projectManager;
        this.log = LoggerFactory.getLogger(CustomFieldProjectAssociationExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, CustomFieldProjectAssociationWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(CustomFieldProjectAssociation.Companion.getEntityType());
    }

    @Override
    @NotNull
    public CustomFieldProjectAssociation exportData(@NotNull ExportContext ctx, @NotNull CustomFieldProjectAssociationWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{ctx.getMigrationId(), entity.getProjectId(), ctx.getExportMode()};
        this.log.debug("[MigrationId:{}] Exporting customFieldProjectAssociation associated with projectId {} under exportMode:{}", objectArray);
        MRI mRI = this.mriForEntity(entity);
        MRI mRI2 = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, entity.getCustomFieldConfigScheme(), false, 4, null);
        Project project = this.projectManager.getProjectObj(Long.valueOf(Long.parseLong(entity.getProjectId())));
        Intrinsics.checkNotNull((Object)project);
        return new CustomFieldProjectAssociation(mRI, mRI2, ExportService.checkExportedOrThrow$default(this.exportService, ctx, project, null, 4, null), null, 8, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull CustomFieldProjectAssociationWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return MriExtensionsKt.mri(CustomFieldProjectAssociation.Companion.getEntityType(), "" + entity.getCustomFieldConfigScheme().getFieldConfigScheme().getId() + '-' + entity.getProjectId(), MRIType.RESULTING);
    }

    @Override
    @NotNull
    public MRI mriForKey(@NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return MriExtensionsKt.mri$default(CustomFieldProjectAssociation.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull CustomFieldProjectAssociationWrapper entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public CustomFieldProjectAssociationWrapper extractServerEntity(@NotNull ExportContext ctx, @NotNull String entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull CustomFieldProjectAssociationWrapper entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

