/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.customfield;

import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.migration.export.core.customfield.CustomFieldConfigSchemeWrapper;
import com.atlassian.jira.migration.export.core.customfield.CustomFieldUserFilterWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.classic.customfield.CustomFieldUserFilter;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/export/core/customfield/CustomFieldUserFilterExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/core/customfield/CustomFieldUserFilterWrapper;", "Lcom/atlassian/migration/jira/classic/customfield/CustomFieldUserFilter;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "", "jira-migration-plugin"})
public final class CustomFieldUserFilterExporter
implements Exporter<String, CustomFieldUserFilterWrapper, CustomFieldUserFilter> {
    @NotNull
    private final ExportService exportService;
    private final Logger log;

    @Inject
    public CustomFieldUserFilterExporter(@NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.exportService = exportService;
        this.log = LoggerFactory.getLogger(CustomFieldUserFilterExporter.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, CustomFieldUserFilterWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(CustomFieldUserFilter.Companion.getEntityType());
    }

    @Override
    @NotNull
    public CustomFieldUserFilter exportData(@NotNull ExportContext ctx, @NotNull CustomFieldUserFilterWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        CustomFieldConfigSchemeWrapper customFieldConfigScheme = entity.getCustomFieldConfigScheme();
        Object[] objectArray = new Object[3];
        objectArray[0] = ctx.getMigrationId();
        FieldConfigScheme fieldConfigScheme = customFieldConfigScheme.getFieldConfigScheme();
        objectArray[1] = fieldConfigScheme != null ? fieldConfigScheme.getId() : null;
        objectArray[2] = ctx.getExportMode();
        this.log.debug("[MigrationId:{}] Exporting customFieldUserFilter associated with customFieldConfigSchemeId {} under exportMode:{}", objectArray);
        List<MRI> groups2 = entity.getGroups();
        List<MRI> roles = entity.getRoles();
        return new CustomFieldUserFilter(this.mriForEntity(entity), ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, customFieldConfigScheme, false, 4, null), entity.getEnabled(), groups2, roles);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull CustomFieldUserFilterWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        EntityType entityType = CustomFieldUserFilter.Companion.getEntityType();
        Long l = entity.getCustomFieldConfigScheme().getFieldConfigScheme().getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return MriExtensionsKt.mri$default(entityType, l, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForKey(@NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return MriExtensionsKt.mri$default(CustomFieldUserFilter.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull CustomFieldUserFilterWrapper entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public CustomFieldUserFilterWrapper extractServerEntity(@NotNull ExportContext ctx, @NotNull String entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull CustomFieldUserFilterWrapper entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

