/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.customfield.jsd;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.db.servicedesk.customfield.CustomFieldReader;
import com.atlassian.jira.migration.db.servicedesk.requesttype.RequestTypeIdReader;
import com.atlassian.jira.migration.export.core.customfield.jsd.CompletedSla;
import com.atlassian.jira.migration.export.core.customfield.jsd.JsdCustomFieldValueParser;
import com.atlassian.jira.migration.export.core.customfield.jsd.OnGoingSla;
import com.atlassian.jira.migration.export.core.customfield.jsd.RemainingTimeUnits;
import com.atlassian.jira.migration.export.core.customfield.jsd.SlaEvent;
import com.atlassian.jira.migration.export.core.customfield.jsd.SlaEventType;
import com.atlassian.jira.migration.export.core.customfield.jsd.SlaValue;
import com.atlassian.jira.migration.export.core.customfield.jsd.ThresholdData;
import com.atlassian.jira.migration.export.db.servicedesk.csat.CsatComment;
import com.atlassian.jira.migration.export.db.servicedesk.csat.CsatFeedbackReader;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.JSDConstants;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.JsdExportUtil;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.customfield.CustomFieldOption;
import com.atlassian.migration.jira.core.customfield.CustomFieldValue;
import com.atlassian.migration.jira.core.customfield.IdReference;
import com.atlassian.migration.jira.servicedesk.TimeMetric;
import com.atlassian.migration.jira.servicedesk.customerorg.CustomerOrganization;
import com.atlassian.migration.jira.servicedesk.requestype.RequestType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 J2\u00020\u0001:\u0001JBG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J,\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u001dH\u0002J(\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J2\u0010#\u001a\u0004\u0018\u00010\u00162\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J0\u0010)\u001a\u0004\u0018\u00010\u00162\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&J(\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0,2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002010,H\u0002J\"\u00102\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00103\u001a\u0002042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J*\u00105\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u00106\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(H\u0002J \u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u000109082\u0006\u0010'\u001a\u00020(2\u0006\u0010%\u001a\u00020&H\u0002J0\u0010:\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020<0,2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020?0,H\u0002J\u0014\u0010@\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002010,H\u0002J\u0014\u0010A\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020?0,H\u0002J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0002J(\u0010F\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010G\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010H\u001a\u00020I2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001dR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/atlassian/jira/migration/export/core/customfield/jsd/JsdCustomFieldValueParser;", "", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "identifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "requestTypeIdReader", "Lcom/atlassian/jira/migration/db/servicedesk/requesttype/RequestTypeIdReader;", "jsdExportUtil", "Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;", "csatFeedbackReader", "Lcom/atlassian/jira/migration/export/db/servicedesk/csat/CsatFeedbackReader;", "customFieldReader", "Lcom/atlassian/jira/migration/db/servicedesk/customfield/CustomFieldReader;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;Lcom/atlassian/jira/migration/db/servicedesk/requesttype/RequestTypeIdReader;Lcom/atlassian/jira/migration/export/utils/JsdExportUtil;Lcom/atlassian/jira/migration/export/db/servicedesk/csat/CsatFeedbackReader;Lcom/atlassian/jira/migration/db/servicedesk/customfield/CustomFieldReader;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "customerOrganisationFieldValue", "Lcom/atlassian/migration/jira/core/customfield/CustomFieldValue;", "value", "fieldMri", "Lcom/atlassian/migration/base/mri/MRI;", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "customerRequestTypeFieldValue", "", "delimiter", "customerSatisfactionCustomFieldValue", "customFieldValue", "issueId", "", "defineSlaCustomFieldValue", "jsonValue", "issue", "Lcom/atlassian/jira/issue/Issue;", "customField", "Lcom/atlassian/jira/issue/fields/CustomField;", "deriveCustomFieldValue", "fieldType", "getCompleteSLAData", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/export/core/customfield/jsd/CompletedSla;", "Lcom/atlassian/migration/jira/core/customfield/CustomFieldValue$CompleteSLAData;", "remainingTimeUnits", "Lcom/atlassian/jira/migration/export/core/customfield/jsd/RemainingTimeUnits;", "Lcom/atlassian/migration/jira/core/customfield/CustomFieldValue$SLAGoalRemainingTimeUnits;", "getCustomerRequestTypeFieldValue", "requestTypeId", "", "getMriOf", "entity", "getRequestParticipantsFromDB", "", "Lcom/atlassian/jira/user/ApplicationUser;", "getSLAData", "Lcom/atlassian/jira/migration/export/core/customfield/jsd/OnGoingSla;", "Lcom/atlassian/migration/jira/core/customfield/CustomFieldValue$SLAData;", "thresholdData", "Lcom/atlassian/jira/migration/export/core/customfield/jsd/ThresholdData;", "Lcom/atlassian/migration/jira/core/customfield/CustomFieldValue$SLAThresholdData;", "getSLAGoalRemainingTimeUnits", "getSLAThresholdData", "getSlaTimeline", "Lcom/atlassian/migration/jira/core/customfield/CustomFieldValue$SLATimeline;", "slaData", "Lcom/atlassian/jira/migration/export/core/customfield/jsd/SlaValue;", "requestParticipantsFieldValue", "satisfactionDateFieldValue", "shouldSkipJsdCustomFieldValue", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJsdCustomFieldValueParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsdCustomFieldValueParser.kt\ncom/atlassian/jira/migration/export/core/customfield/jsd/JsdCustomFieldValueParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,285:1\n1549#2:286\n1620#2,3:287\n1549#2:293\n1620#2,3:294\n1549#2:297\n1620#2,2:298\n1549#2:300\n1620#2,3:301\n1622#2:304\n1603#2,9:305\n1855#2:314\n1856#2:316\n1612#2:317\n1603#2,9:318\n1855#2:327\n1856#2:329\n1612#2:330\n1549#2:331\n1620#2,3:332\n58#3:290\n51#3:291\n1#4:292\n1#4:315\n1#4:328\n*S KotlinDebug\n*F\n+ 1 JsdCustomFieldValueParser.kt\ncom/atlassian/jira/migration/export/core/customfield/jsd/JsdCustomFieldValueParser\n*L\n120#1:286\n120#1:287,3\n149#1:293\n149#1:294,3\n162#1:297\n162#1:298,2\n163#1:300\n163#1:301,3\n162#1:304\n217#1:305,9\n217#1:314\n217#1:316\n217#1:317\n234#1:318,9\n234#1:327\n234#1:329\n234#1:330\n235#1:331\n235#1:332,3\n127#1:290\n127#1:291\n217#1:315\n234#1:328\n*E\n"})
public final class JsdCustomFieldValueParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final EntityIdentifierGenerator identifierGenerator;
    @NotNull
    private final RequestTypeIdReader requestTypeIdReader;
    @NotNull
    private final JsdExportUtil jsdExportUtil;
    @NotNull
    private final CsatFeedbackReader csatFeedbackReader;
    @NotNull
    private final CustomFieldReader customFieldReader;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final ObjectMapper objectMapper;
    private static final Logger log = LoggerFactory.getLogger(JsdCustomFieldValueParser.class);

    @Inject
    public JsdCustomFieldValueParser(@NotNull ExportService exportService, @NotNull EntityIdentifierGenerator identifierGenerator, @NotNull RequestTypeIdReader requestTypeIdReader, @NotNull JsdExportUtil jsdExportUtil, @NotNull CsatFeedbackReader csatFeedbackReader, @NotNull CustomFieldReader customFieldReader, @NotNull UserManager userManager, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)identifierGenerator, (String)"identifierGenerator");
        Intrinsics.checkNotNullParameter((Object)requestTypeIdReader, (String)"requestTypeIdReader");
        Intrinsics.checkNotNullParameter((Object)jsdExportUtil, (String)"jsdExportUtil");
        Intrinsics.checkNotNullParameter((Object)csatFeedbackReader, (String)"csatFeedbackReader");
        Intrinsics.checkNotNullParameter((Object)customFieldReader, (String)"customFieldReader");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.exportService = exportService;
        this.identifierGenerator = identifierGenerator;
        this.requestTypeIdReader = requestTypeIdReader;
        this.jsdExportUtil = jsdExportUtil;
        this.csatFeedbackReader = csatFeedbackReader;
        this.customFieldReader = customFieldReader;
        this.userManager = userManager;
        this.objectMapper = objectMapperFactory.createObjectMapperHandlingUnknownFields();
    }

    public final boolean shouldSkipJsdCustomFieldValue(@NotNull ExportContext ctx, @NotNull String fieldType) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)fieldType, (String)"fieldType");
        boolean isJsdCustomField = JSDConstants.INSTANCE.getJSD_CUSTOM_FIELDS().contains(fieldType);
        boolean invalidFieldType = Intrinsics.areEqual((Object)fieldType, (Object)"com.atlassian.servicedesk.approvals-plugin:sd-approvals");
        boolean isProjectIneligible = !this.jsdExportUtil.isJsdProjectEligibleForMigration(ctx);
        return isJsdCustomField && (isProjectIneligible || invalidFieldType);
    }

    @Nullable
    public final CustomFieldValue deriveCustomFieldValue(@NotNull String fieldType, @NotNull MRI fieldMri, @NotNull CustomField customField, @NotNull ExportContext ctx, @NotNull Issue issue2) {
        CustomFieldValue customFieldValue;
        Intrinsics.checkNotNullParameter((Object)fieldType, (String)"fieldType");
        Intrinsics.checkNotNullParameter((Object)fieldMri, (String)"fieldMri");
        Intrinsics.checkNotNullParameter((Object)customField, (String)"customField");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        switch (fieldType) {
            case "com.atlassian.servicedesk:sd-sla-field": {
                String string;
                Object valueFromCustomField = customField.getValue(issue2);
                if (valueFromCustomField == null) {
                    Long l = issue2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                    Object object = this.customFieldReader.getValue(customField, ((Number)l).longValue());
                    if (object == null) {
                        String string2 = "Value is absent for CustomField with idAsLong:" + customField.getIdAsLong() + ", id:" + customField.getId() + " for issue id " + issue2.getId();
                        ExportErrorCode exportErrorCode = ExportErrorCode.JSD_CUSTOM_FIELD_VALUE_ABSENT;
                        throw new ExportException(fieldMri, exportErrorCode, string2, null, null, null, null, 120, null);
                    }
                    Object valueFromDB = object;
                    string = (String)valueFromDB;
                } else {
                    string = customField.getCustomFieldType().getStringFromSingularObject(valueFromCustomField);
                }
                String jsonValue = string;
                Intrinsics.checkNotNull((Object)jsonValue);
                customFieldValue = this.defineSlaCustomFieldValue(jsonValue, fieldMri, ctx, issue2, customField);
                break;
            }
            case "com.atlassian.servicedesk:sd-customer-organizations": {
                Object object = issue2.getCustomFieldValue(customField);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCustomFieldValue(...)");
                customFieldValue = this.customerOrganisationFieldValue(object, fieldMri, ctx);
                break;
            }
            case "com.atlassian.servicedesk:sd-request-feedback-date": {
                Object object = issue2.getCustomFieldValue(customField);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCustomFieldValue(...)");
                customFieldValue = this.satisfactionDateFieldValue(object, fieldMri);
                break;
            }
            case "com.atlassian.servicedesk:sd-request-participants": {
                List<ApplicationUser> list = issue2.getCustomFieldValue(customField);
                if (list == null) {
                    list = this.getRequestParticipantsFromDB(customField, issue2);
                }
                List<ApplicationUser> requestParticipants = list;
                customFieldValue = this.requestParticipantsFieldValue(requestParticipants, fieldMri, customField, ctx);
                break;
            }
            case "com.atlassian.servicedesk:vp-origin": {
                String customFieldValue2 = customField.getCustomFieldType().getStringFromSingularObject(customField.getValue(issue2));
                Intrinsics.checkNotNull((Object)customFieldValue2);
                customFieldValue = JsdCustomFieldValueParser.customerRequestTypeFieldValue$default(this, customFieldValue2, fieldMri, ctx, null, 8, null);
                break;
            }
            case "com.atlassian.servicedesk:sd-request-feedback": {
                String customFieldValue2 = customField.getCustomFieldType().getStringFromSingularObject(customField.getValue(issue2));
                Intrinsics.checkNotNull((Object)customFieldValue2);
                Long l = issue2.getId();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                customFieldValue = this.customerSatisfactionCustomFieldValue(customFieldValue2, fieldMri, ((Number)l).longValue(), ctx);
                break;
            }
            default: {
                String string = "JSM Custom Field Key: [" + fieldType + "] not supported";
                ExportErrorCode exportErrorCode = ExportErrorCode.JSD_CUSTOM_FIELD_TYPE_UNSUPPORTED;
                throw new ExportException(fieldMri, exportErrorCode, string, null, null, null, null, 120, null);
            }
        }
        CustomFieldValue derivedCustomFieldValue = customFieldValue;
        return derivedCustomFieldValue;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ApplicationUser> getRequestParticipantsFromDB(CustomField customField, Issue issue2) {
        void $this$mapTo$iv$iv;
        Long l = issue2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        List<Object> userKeys = this.customFieldReader.getValues(customField, ((Number)l).longValue());
        Iterable $this$map$iv = userKeys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.userManager.getUserByKey(it.toString()));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final CustomFieldValue defineSlaCustomFieldValue(String jsonValue, MRI fieldMri, ExportContext ctx, Issue issue2, CustomField customField) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Integer n;
        SlaValue slaData;
        block7: {
            block6: {
                Object $this$readValue$iv = this.objectMapper;
                boolean $i$f$readValue2 = false;
                boolean $i$f$jacksonTypeRef2 = false;
                SlaValue slaValue = (SlaValue)$this$readValue$iv.readValue(jsonValue, (TypeReference)new TypeReference<SlaValue>(){});
                if (slaValue == null) {
                    $this$readValue$iv = "Value is null for CustomField with idAsLong:" + customField.getIdAsLong() + ", id:" + customField.getId() + " for issue id " + issue2.getId();
                    ExportErrorCode $i$f$readValue2 = ExportErrorCode.JSD_CUSTOM_FIELD_VALUE_ABSENT;
                    String $i$f$jacksonTypeRef2 = "Please re-calculate the SLAs for " + ctx.getProject() + '-' + issue2.getNumber();
                    throw new ExportException(fieldMri, $i$f$readValue2, (String)$this$readValue$iv, $i$f$jacksonTypeRef2, null, null, null, 112, null);
                }
                slaData = slaValue;
                n = slaData.getMetricId();
                if (n == null) break block6;
                int it = ((Number)n).intValue();
                boolean bl = false;
                MRI mRI = this.exportService.getExportedOrNull(ctx, TimeMetric.Companion.getEntityType(), slaData.getMetricId());
                n = mRI;
                if (mRI != null) break block7;
            }
            return null;
        }
        Integer timeMetricId2 = n;
        if (slaData.getOngoingSLAData() != null && this.exportService.getExportedOrNull(ctx, TimeMetric.Goal.Companion.getEntityType(), slaData.getOngoingSLAData().getGoalId()) == null) {
            return null;
        }
        CustomFieldValue.SLATimeline slaTimeline = this.getSlaTimeline(slaData);
        Function1<ThresholdData, CustomFieldValue.SLAThresholdData> thresholdData = this.getSLAThresholdData();
        Function1<OnGoingSla, CustomFieldValue.SLAData> onGoingSla = this.getSLAData(ctx, thresholdData);
        Function1<RemainingTimeUnits, CustomFieldValue.SLAGoalRemainingTimeUnits> remainingTimeUnits = this.getSLAGoalRemainingTimeUnits();
        Function1<CompletedSla, CustomFieldValue.CompleteSLAData> completedSla = this.getCompleteSLAData(remainingTimeUnits);
        OnGoingSla onGoingSla2 = slaData.getOngoingSLAData();
        Iterable iterable = slaData.getCompleteSLAData();
        CustomFieldValue.SLAData sLAData = onGoingSla2 != null ? (CustomFieldValue.SLAData)onGoingSla.invoke((Object)onGoingSla2) : null;
        CustomFieldValue.SLATimeline sLATimeline = slaTimeline;
        MRI mRI = fieldMri;
        boolean $i$f$map = false;
        void var15_24 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv.add(completedSla.invoke(item$iv$iv));
        }
        List list = (List)destination$iv$iv;
        long l = slaData.getMetricCreatedDate();
        Long l2 = slaData.getGoalTimeUpdatedMsEpoch();
        Long l3 = slaData.getGoalTimeUpdatedDate();
        Long l4 = slaData.getGoalsChangeMsEpoch();
        Long l5 = slaData.getGoalsChangeDate();
        long l6 = slaData.getDefinitionChangeMsEpoch();
        long l7 = slaData.getDefinitionChangeDate();
        Integer n2 = timeMetricId2;
        List list2 = list;
        CustomFieldValue.SLAData sLAData2 = sLAData;
        CustomFieldValue.SLATimeline sLATimeline2 = sLATimeline;
        MRI mRI2 = mRI;
        return (CustomFieldValue)new CustomFieldValue.SLACustomFieldValue(mRI2, sLATimeline2, sLAData2, list2, (MRI)n2, l7, l6, l5, l4, l3, l2, l);
    }

    /*
     * WARNING - void declaration
     */
    private final CustomFieldValue.SLATimeline getSlaTimeline(SlaValue slaData) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = slaData.getTimeline().getEvents();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<String> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void event;
            SlaEvent slaEvent = (SlaEvent)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = event.getTypes();
            long l = event.getDate();
            boolean $i$f$map2 = false;
            void var16_14 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                SlaEventType slaEventType = (SlaEventType)((Object)item$iv$iv2);
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.toString());
            }
            collection = (List)destination$iv$iv2;
            List list = collection;
            long l2 = l;
            collection2.add(new CustomFieldValue.SLAEvent(l2, list));
        }
        List slaEvents = (List)destination$iv$iv;
        return new CustomFieldValue.SLATimeline(slaEvents);
    }

    private final Function1<ThresholdData, CustomFieldValue.SLAThresholdData> getSLAThresholdData() {
        return getSLAThresholdData.1.INSTANCE;
    }

    private final Function1<OnGoingSla, CustomFieldValue.SLAData> getSLAData(ExportContext ctx, Function1<? super ThresholdData, CustomFieldValue.SLAThresholdData> thresholdData) {
        return (Function1)new Function1<OnGoingSla, CustomFieldValue.SLAData>(this, ctx, thresholdData){
            final /* synthetic */ JsdCustomFieldValueParser this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ Function1<ThresholdData, CustomFieldValue.SLAThresholdData> $thresholdData;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$thresholdData = $thresholdData;
                super(1);
            }

            @NotNull
            public final CustomFieldValue.SLAData invoke(@NotNull OnGoingSla onGoingSla) {
                CustomFieldValue.SLAThresholdData sLAThresholdData;
                Intrinsics.checkNotNullParameter((Object)onGoingSla, (String)"onGoingSla");
                MRI mRI = JsdCustomFieldValueParser.access$getExportService$p(this.this$0).checkExportedOrThrow(this.$ctx, TimeMetric.Goal.Companion.getEntityType(), onGoingSla.getGoalId(), (Function1<? super MRI, ? extends Exception>)((Function1)new Function1<MRI, Exception>(onGoingSla){
                    final /* synthetic */ OnGoingSla $onGoingSla;
                    {
                        this.$onGoingSla = $onGoingSla;
                        super(1);
                    }

                    @NotNull
                    public final Exception invoke(@NotNull MRI mri) {
                        Intrinsics.checkNotNullParameter((Object)mri, (String)"mri");
                        MRI mRI = MriExtensionsKt.dummyMri$default(TimeMetric.Companion.getEntityType(), null, 1, null);
                        String string = "Time Metric Goal with MRI - " + mri + " supposed to be exported but was not.";
                        String string2 = "Verify if Time Metric Goal with id " + this.$onGoingSla.getGoalId() + " is valid";
                        ExportErrorCode exportErrorCode = ExportErrorCode.JSD_REQUIRED_REFERRED_ENTITY_NOT_EXPORTED;
                        return new ExportException(mRI, exportErrorCode, string, string2, null, null, null, 112, null);
                    }
                }));
                long l = onGoingSla.getStartTime();
                boolean bl = onGoingSla.getPaused();
                ThresholdData thresholdData = onGoingSla.getThresholdData();
                if (thresholdData != null) {
                    ThresholdData thresholdData2 = thresholdData;
                    sLAThresholdData = (CustomFieldValue.SLAThresholdData)this.$thresholdData.invoke((Object)thresholdData2);
                } else {
                    sLAThresholdData = null;
                }
                return new CustomFieldValue.SLAData(mRI, l, bl, sLAThresholdData);
            }
        };
    }

    private final Function1<RemainingTimeUnits, CustomFieldValue.SLAGoalRemainingTimeUnits> getSLAGoalRemainingTimeUnits() {
        return getSLAGoalRemainingTimeUnits.1.INSTANCE;
    }

    private final Function1<CompletedSla, CustomFieldValue.CompleteSLAData> getCompleteSLAData(Function1<? super RemainingTimeUnits, CustomFieldValue.SLAGoalRemainingTimeUnits> remainingTimeUnits) {
        return (Function1)new Function1<CompletedSla, CustomFieldValue.CompleteSLAData>(remainingTimeUnits){
            final /* synthetic */ Function1<RemainingTimeUnits, CustomFieldValue.SLAGoalRemainingTimeUnits> $remainingTimeUnits;
            {
                this.$remainingTimeUnits = $remainingTimeUnits;
                super(1);
            }

            @NotNull
            public final CustomFieldValue.CompleteSLAData invoke(@NotNull CompletedSla completedSla) {
                CustomFieldValue.SLAGoalRemainingTimeUnits sLAGoalRemainingTimeUnits;
                CustomFieldValue.SLAGoalRemainingTimeUnits sLAGoalRemainingTimeUnits2;
                RemainingTimeUnits remainingTimeUnits;
                Intrinsics.checkNotNullParameter((Object)completedSla, (String)"completedSla");
                boolean bl = completedSla.getSucceeded();
                long l = completedSla.getGoalTime();
                long l2 = completedSla.getElapsedTime();
                String string = completedSla.getCalendarName();
                long l3 = completedSla.getStartTime();
                long l4 = completedSla.getStopTime();
                RemainingTimeUnits remainingTimeUnits2 = completedSla.getGoalTimeUnits();
                if (remainingTimeUnits2 != null) {
                    remainingTimeUnits = remainingTimeUnits2;
                    sLAGoalRemainingTimeUnits2 = (CustomFieldValue.SLAGoalRemainingTimeUnits)this.$remainingTimeUnits.invoke((Object)remainingTimeUnits);
                } else {
                    sLAGoalRemainingTimeUnits2 = null;
                }
                RemainingTimeUnits remainingTimeUnits3 = completedSla.getRemainingTimeInDaysAndMillis();
                if (remainingTimeUnits3 != null) {
                    remainingTimeUnits = remainingTimeUnits3;
                    sLAGoalRemainingTimeUnits = (CustomFieldValue.SLAGoalRemainingTimeUnits)this.$remainingTimeUnits.invoke((Object)remainingTimeUnits);
                } else {
                    sLAGoalRemainingTimeUnits = null;
                }
                return new CustomFieldValue.CompleteSLAData(bl, l, l2, string, l3, l4, sLAGoalRemainingTimeUnits2, sLAGoalRemainingTimeUnits, completedSla.getRemainingTime());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final CustomFieldValue customerOrganisationFieldValue(Object value, MRI fieldMri, ExportContext ctx) {
        CustomFieldValue.ReferenceIntegerListFieldValue referenceIntegerListFieldValue;
        List list;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
        Iterable $this$mapNotNull$iv = (List)value;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MRI it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Object organization = element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull(organization, (String)"null cannot be cast to non-null type com.atlassian.servicedesk.api.organization.CustomerOrganization");
            int orgId = ((com.atlassian.servicedesk.api.organization.CustomerOrganization)organization).getId();
            if (this.exportService.exportOrNull(ctx, CustomerOrganization.Companion.getEntityType(), orgId) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        List list2 = !((Collection)it).isEmpty() ? list : null;
        if (list2 != null) {
            List organizations = list2;
            boolean bl4 = false;
            referenceIntegerListFieldValue = new CustomFieldValue.ReferenceIntegerListFieldValue(fieldMri, organizations);
        } else {
            referenceIntegerListFieldValue = null;
        }
        return (CustomFieldValue)referenceIntegerListFieldValue;
    }

    private final CustomFieldValue satisfactionDateFieldValue(Object value, MRI fieldMri) {
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type java.sql.Timestamp");
        Instant instant = ((Timestamp)value).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        return (CustomFieldValue)new CustomFieldValue.DateTimeFieldValue(fieldMri, instant);
    }

    /*
     * WARNING - void declaration
     */
    private final CustomFieldValue requestParticipantsFieldValue(Object value, MRI fieldMri, CustomField customField, ExportContext ctx) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
        Iterable iterable = (List)value;
        MRI mRI = fieldMri;
        boolean $i$f$mapNotNull = false;
        void var7_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            UserRef it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            Object it = element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type com.atlassian.jira.user.ApplicationUser");
            if (UserRef.Companion.fromString(((ApplicationUser)it).getKey()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (UserRef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new IdReference(this.getMriOf(ctx, it, fieldMri, customField)));
        }
        List list = (List)destination$iv$iv;
        MRI mRI2 = mRI;
        return (CustomFieldValue)new CustomFieldValue.IdReferenceListFieldValue(mRI2, list);
    }

    private final CustomFieldValue customerRequestTypeFieldValue(String value, MRI fieldMri, ExportContext ctx, String delimiter) {
        Integer n;
        block3: {
            String requestTypeKey;
            block2: {
                String[] stringArray = new String[]{delimiter};
                List customFieldValues = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String portalKey = (String)customFieldValues.get(0);
                requestTypeKey = (String)customFieldValues.get(1);
                Integer requestTypeId2 = this.requestTypeIdReader.getRequestTypeId(requestTypeKey, portalKey);
                n = requestTypeId2;
                if (n == null) break block2;
                int it = ((Number)n).intValue();
                boolean bl = false;
                CustomFieldValue customFieldValue = this.getCustomerRequestTypeFieldValue(ctx, requestTypeId2, fieldMri);
                n = customFieldValue;
                if (customFieldValue != null) break block3;
            }
            JsdCustomFieldValueParser it = this;
            boolean bl = false;
            log.warn("No RequestTypeId found for the corresponding requestTypeKey " + requestTypeKey + " for fieldMri " + fieldMri);
            n = null;
        }
        return n;
    }

    static /* synthetic */ CustomFieldValue customerRequestTypeFieldValue$default(JsdCustomFieldValueParser jsdCustomFieldValueParser, String string, MRI mRI, ExportContext exportContext, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "/";
        }
        return jsdCustomFieldValueParser.customerRequestTypeFieldValue(string, mRI, exportContext, string2);
    }

    private final CustomFieldValue getCustomerRequestTypeFieldValue(ExportContext ctx, int requestTypeId2, MRI fieldMri) {
        CustomFieldValue customFieldValue;
        MRI fieldValue;
        ExportService.CheckExportedResult checkExportedResult = this.exportService.checkExported(ctx, RequestType.Companion.getEntityType(), requestTypeId2);
        Object it = checkExportedResult;
        boolean bl = false;
        ExportService.CheckExportedResult checkExportedResult2 = ((ExportService.CheckExportedResult)it).isExported() ? checkExportedResult : null;
        MRI mRI = fieldValue = checkExportedResult2 != null ? checkExportedResult2.getMri() : null;
        if (mRI != null) {
            it = mRI;
            boolean bl2 = false;
            customFieldValue = (CustomFieldValue)new CustomFieldValue.ReferenceFieldValue(fieldMri, fieldValue);
        } else {
            it = this;
            boolean bl3 = false;
            log.warn("Request Type for the corresponding ID " + requestTypeId2 + " and fieldMri " + fieldMri + " not exported");
            customFieldValue = null;
        }
        return customFieldValue;
    }

    private final CustomFieldValue customerSatisfactionCustomFieldValue(String customFieldValue, MRI fieldMri, long issueId, ExportContext ctx) {
        block0: {
            CsatComment csatComment = this.csatFeedbackReader.getCsatComment(issueId);
            if (csatComment == null) break block0;
            CsatComment it = csatComment;
            boolean bl = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null);
        }
        return (CustomFieldValue)new CustomFieldValue.StringFieldValue(fieldMri, customFieldValue);
    }

    private final MRI getMriOf(ExportContext ctx, Object entity, MRI fieldMri, CustomField customField) {
        MRI mRI;
        Object object = entity;
        if (object instanceof Option) {
            mRI = MriExtensionsKt.mri$default(CustomFieldOption.Companion.getEntityType(), String.valueOf(((Option)entity).getOptionId()), null, 2, null);
        } else if (object instanceof Group) {
            mRI = this.exportService.groupRef(ctx, (Group)entity);
        } else if (object instanceof UserRef) {
            mRI = this.exportService.userRef(ctx, (UserRef)entity);
        } else {
            Object object2 = entity;
            String string = "Entity type: " + (object2 != null ? object2.getClass() : null) + " for " + EntityIdentifierGenerator.generate$default(this.identifierGenerator, fieldMri, customField, null, 4, null) + " is not supported";
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_CUSTOM_FIELD_REF_TYPE_UNSUPPORTED;
            throw new ExportException(fieldMri, exportErrorCode, string, null, null, null, null, 120, null);
        }
        return mRI;
    }

    public static final /* synthetic */ ExportService access$getExportService$p(JsdCustomFieldValueParser $this) {
        return $this.exportService;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/core/customfield/jsd/JsdCustomFieldValueParser$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

