/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.customfieldScope;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\tR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/export/core/customfieldScope/CustomFieldScopeValue;", "", "customField", "Lcom/atlassian/jira/issue/fields/CustomField;", "project", "Lcom/atlassian/jira/project/Project;", "(Lcom/atlassian/jira/issue/fields/CustomField;Lcom/atlassian/jira/project/Project;)V", "associatedIssueTypes", "", "Lcom/atlassian/jira/issue/issuetype/IssueType;", "global", "", "getGlobal", "()Z", "isInScopeOfProject", "isInScopeOfIssueType", "issueType", "jira-migration-plugin"})
public final class CustomFieldScopeValue {
    private final boolean global;
    private final boolean isInScopeOfProject;
    @NotNull
    private final Set<IssueType> associatedIssueTypes;

    public CustomFieldScopeValue(@NotNull CustomField customField, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)customField, (String)"customField");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.global = customField.isGlobal();
        this.isInScopeOfProject = customField.getAssociatedProjectObjects().contains(project);
        List list = customField.getAssociatedIssueTypes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAssociatedIssueTypes(...)");
        this.associatedIssueTypes = CollectionsKt.toSet((Iterable)list);
    }

    public final boolean getGlobal() {
        return this.global;
    }

    public final boolean isInScopeOfProject() {
        return this.isInScopeOfProject;
    }

    public final boolean isInScopeOfIssueType(@Nullable IssueType issueType) {
        return CollectionsKt.contains((Iterable)this.associatedIssueTypes, (Object)issueType);
    }
}

