/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.entityProperty;

import com.atlassian.jira.migration.export.db.core.EntityPropertyV4MigrationEntity;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.ExportExceptionHolder;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.FallibleExportHandler;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.jira.migration.log.MessageEntityIdentifier;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.apps.entityProperties.EntityProperty;
import com.atlassian.migration.jira.apps.entityProperties.EntityPropertyMetadata;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u0018B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/export/core/entityProperty/EntityPropertyExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/db/core/EntityPropertyV4MigrationEntity;", "Lcom/atlassian/migration/jira/apps/entityProperties/EntityProperty;", "entityIdentifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;Lcom/atlassian/jira/migration/export/service/ExportService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nEntityPropertyExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityPropertyExporter.kt\ncom/atlassian/jira/migration/export/core/entityProperty/EntityPropertyExporter\n+ 2 ExportException.kt\ncom/atlassian/jira/migration/export/framework/FallibleExportHandler\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n155#2,18:69\n173#2,6:88\n180#2,11:95\n1855#3:87\n1856#3:94\n*S KotlinDebug\n*F\n+ 1 EntityPropertyExporter.kt\ncom/atlassian/jira/migration/export/core/entityProperty/EntityPropertyExporter\n*L\n48#1:69,18\n48#1:88,6\n48#1:95,11\n48#1:87\n48#1:94\n*E\n"})
public final class EntityPropertyExporter
implements Exporter<Long, EntityPropertyV4MigrationEntity, EntityProperty> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityIdentifierGenerator entityIdentifierGenerator;
    @NotNull
    private final ExportService exportService;
    @NotNull
    private static final Logger log;

    @Inject
    public EntityPropertyExporter(@NotNull EntityIdentifierGenerator entityIdentifierGenerator, @NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)entityIdentifierGenerator, (String)"entityIdentifierGenerator");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.entityIdentifierGenerator = entityIdentifierGenerator;
        this.exportService = exportService;
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, EntityPropertyV4MigrationEntity.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return new ExporterKey(EntityProperty.Companion.getEntityType());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(EntityProperty.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull EntityPropertyV4MigrationEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public EntityProperty exportData(@NotNull ExportContext ctx, @NotNull EntityPropertyV4MigrationEntity entity) {
        EntityProperty entityProperty;
        block9: {
            List<ExportException> list;
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Object[] objectArray = new Object[]{ctx.getMigrationId(), entity.getId(), entity.getEntityId(), ctx.getExportMode()};
            log.debug("[MigrationId:{}] Exporting entityProperty with id {} and entityId {} under exportMode:{}", objectArray);
            MRI mri = this.mriForEntity(entity);
            Function1 entityIdentifierProvider2 = (Function1)new Function1<ExportException, MessageEntityIdentifier>(this, entity){
                final /* synthetic */ EntityPropertyExporter this$0;
                final /* synthetic */ EntityPropertyV4MigrationEntity $entity;
                {
                    this.this$0 = $receiver;
                    this.$entity = $entity;
                    super(1);
                }

                @NotNull
                public final MessageEntityIdentifier invoke(@NotNull ExportException exception) {
                    Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                    return EntityIdentifierGenerator.generate$default(EntityPropertyExporter.access$getEntityIdentifierGenerator$p(this.this$0), exception.getEntity(), this.$entity, null, 4, null);
                }
            };
            FallibleExportHandler fallibleExportHandler = FallibleExportHandler.INSTANCE;
            Logger log$iv = log;
            boolean $i$f$runOrThrow = false;
            Throwable unhandledException$iv = null;
            ExportExceptionHolder holder$iv = new ExportExceptionHolder();
            try {
                ExportExceptionHolder $this$exportData_u24lambda_u240 = holder$iv;
                boolean bl = false;
                EntityPropertyMetadata entityPropertyMetadata = new EntityPropertyMetadata(entity.getCloudAppKey(), Boolean.valueOf(entity.getSkipWebhookNotification()));
                String string = entity.getPropertyName();
                String string2 = entity.getPropertyKey();
                String string3 = entity.getJsonValue();
                MRI mRI = MriExtensionsKt.mri$default(entity.getJiraEntityType(), entity.getEntityId(), null, 2, null);
                EntityType entityType = entity.getJiraEntityType();
                entityProperty = new EntityProperty(entityPropertyMetadata, mri, string2, string3, string, entityType, mRI);
                list = holder$iv.get();
                if (!(!((Collection)list).isEmpty())) break block9;
            }
            catch (Throwable t$iv) {
                try {
                    unhandledException$iv = t$iv;
                    throw unhandledException$iv;
                }
                catch (Throwable throwable) {
                    List<ExportException> exportErrors$iv = holder$iv.get();
                    if (!((Collection)exportErrors$iv).isEmpty()) {
                        if (unhandledException$iv == null) {
                            Iterable $this$forEach$iv$iv = exportErrors$iv.subList(0, exportErrors$iv.size() - 1);
                            boolean $i$f$forEach = false;
                            for (Object element$iv$iv : $this$forEach$iv$iv) {
                                ExportException it$iv = (ExportException)element$iv$iv;
                                boolean bl = false;
                                ctx.handleExportFailure(it$iv.getEntity(), it$iv, ctx.getMigrationId() + ": Exporting entity " + entityIdentifierProvider2.invoke((Object)it$iv) + " failed with unhandled exception");
                            }
                            throw (Throwable)CollectionsKt.last(exportErrors$iv);
                        }
                        Iterable $this$forEach$iv$iv = exportErrors$iv;
                        boolean $i$f$forEach = false;
                        for (Object element$iv$iv : $this$forEach$iv$iv) {
                            ExportException it$iv = (ExportException)element$iv$iv;
                            boolean bl = false;
                            ctx.handleExportFailure(it$iv.getEntity(), it$iv, ctx.getMigrationId() + ": Exporting entity " + entityIdentifierProvider2.invoke((Object)it$iv) + " failed");
                        }
                    }
                    throw throwable;
                }
            }
            Iterable iterable = list.subList(0, list.size() - 1);
            for (ExportException exportException : iterable) {
                ctx.handleExportFailure(exportException.getEntity(), exportException, ctx.getMigrationId() + ": Exporting entity " + entityIdentifierProvider2.invoke((Object)exportException) + " failed with unhandled exception");
            }
            throw (Throwable)CollectionsKt.last(list);
        }
        return entityProperty;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull EntityPropertyV4MigrationEntity entity) {
        Exporter.DefaultImpls.exportUsersAndGroups(this, ctx, entity);
    }

    @Override
    @Nullable
    public EntityPropertyV4MigrationEntity extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull EntityPropertyV4MigrationEntity entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    public static final /* synthetic */ EntityIdentifierGenerator access$getEntityIdentifierGenerator$p(EntityPropertyExporter $this) {
        return $this.entityIdentifierGenerator;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(EntityPropertyExporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/export/core/entityProperty/EntityPropertyExporter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

