/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.entityProperty.service;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.migration.app.generator.EntityPropertiesGeneratorFactory;
import com.atlassian.jira.migration.export.db.core.EntityPropertyV4MigrationEntity;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportMode;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.migration.app.dto.AppContainerDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/export/core/entityProperty/service/EntityPropertyExportService;", "", "entityPropertiesGeneratorFactory", "Lcom/atlassian/jira/migration/app/generator/EntityPropertiesGeneratorFactory;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportOrThrow;", "(Lcom/atlassian/jira/migration/app/generator/EntityPropertiesGeneratorFactory;Lcom/atlassian/jira/migration/export/service/ExportOrThrow;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportForIssue", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "jiraIssue", "Lcom/atlassian/jira/issue/Issue;", "containerDetails", "", "Lcom/atlassian/migration/app/dto/AppContainerDetails;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nEntityPropertyExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityPropertyExportService.kt\ncom/atlassian/jira/migration/export/core/entityProperty/service/EntityPropertyExportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1549#2:37\n1620#2,3:38\n1549#2:41\n1620#2,3:42\n*S KotlinDebug\n*F\n+ 1 EntityPropertyExportService.kt\ncom/atlassian/jira/migration/export/core/entityProperty/service/EntityPropertyExportService\n*L\n26#1:37\n26#1:38,3\n30#1:41\n30#1:42,3\n*E\n"})
public final class EntityPropertyExportService {
    @NotNull
    private final EntityPropertiesGeneratorFactory entityPropertiesGeneratorFactory;
    @NotNull
    private final ExportOrThrow exportService;
    private final Logger log;

    @Inject
    public EntityPropertyExportService(@NotNull EntityPropertiesGeneratorFactory entityPropertiesGeneratorFactory, @NotNull ExportOrThrow exportService) {
        Intrinsics.checkNotNullParameter((Object)entityPropertiesGeneratorFactory, (String)"entityPropertiesGeneratorFactory");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.entityPropertiesGeneratorFactory = entityPropertiesGeneratorFactory;
        this.exportService = exportService;
        this.log = LoggerFactory.getLogger(EntityPropertyExportService.class);
    }

    public final void exportForIssue(@NotNull ExportContext ctx, @NotNull Issue jiraIssue, @NotNull Set<AppContainerDetails> containerDetails) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)jiraIssue, (String)"jiraIssue");
        Intrinsics.checkNotNullParameter(containerDetails, (String)"containerDetails");
        if (ctx.getExportMode() == ExportMode.PROJECT_DATA) {
            EntityPropertyV4MigrationEntity it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object object = new Object[]{ctx.getMigrationId(), jiraIssue.getId(), ctx.getExportMode()};
            this.log.debug("[MigrationId:{}] Exporting jiraIssue with id {} under exportMode:{}", object);
            object = containerDetails;
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                AppContainerDetails appContainerDetails = (AppContainerDetails)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.entityPropertiesGeneratorFactory.generate(it.getCloudAppKey(), jiraIssue));
            }
            $this$map$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (EntityPropertyV4MigrationEntity)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, it, false, 4, null));
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
    }
}

