/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.fieldlayout;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.migration.export.core.fieldlayout.FieldLayoutItemWrapper;
import com.atlassian.jira.migration.export.core.fieldlayout.FieldLayoutSchemeExporter;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.CustomFieldUtilsKt;
import com.atlassian.jira.migration.export.utils.ExportFilters;
import com.atlassian.jira.migration.export.utils.ExportLoggers;
import com.atlassian.migration.base.mri.MRI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001b2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u001bB\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/export/core/fieldlayout/FieldLayoutExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/issue/fields/layout/field/FieldLayout;", "Lcom/atlassian/migration/jira/classic/fieldlayout/FieldLayout;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "exportFilters", "Lcom/atlassian/jira/migration/export/utils/ExportFilters;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/utils/ExportFilters;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportFieldLayoutItems", "", "jiraFieldLayout", "exportUsersAndGroups", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nFieldLayoutSchemeExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldLayoutSchemeExporter.kt\ncom/atlassian/jira/migration/export/core/fieldlayout/FieldLayoutExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n766#2:230\n857#2,2:231\n1855#2,2:233\n*S KotlinDebug\n*F\n+ 1 FieldLayoutSchemeExporter.kt\ncom/atlassian/jira/migration/export/core/fieldlayout/FieldLayoutExporter\n*L\n159#1:230\n159#1:231,2\n161#1:233,2\n*E\n"})
public final class FieldLayoutExporter
implements Exporter<Long, FieldLayout, com.atlassian.migration.jira.classic.fieldlayout.FieldLayout> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ExportFilters exportFilters;
    @NotNull
    private final ExporterKey key;
    private static final Logger log = LoggerFactory.getLogger(FieldLayoutSchemeExporter.class);

    @Inject
    public FieldLayoutExporter(@NotNull ExportService exportService, @NotNull ExportFilters exportFilters) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)exportFilters, (String)"exportFilters");
        this.exportService = exportService;
        this.exportFilters = exportFilters;
        this.key = new ExporterKey(com.atlassian.migration.jira.classic.fieldlayout.FieldLayout.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, FieldLayout.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull FieldLayout entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(com.atlassian.migration.jira.classic.fieldlayout.FieldLayout.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public com.atlassian.migration.jira.classic.fieldlayout.FieldLayout exportData(@NotNull ExportContext ctx, @NotNull FieldLayout entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        MRI mRI = this.mriForEntity(entity);
        String string = entity.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        com.atlassian.migration.jira.classic.fieldlayout.FieldLayout fieldLayout = new com.atlassian.migration.jira.classic.fieldlayout.FieldLayout(mRI, string, entity.getDescription(), false, null, null, 48, null);
        this.exportFieldLayoutItems(ctx, entity);
        return fieldLayout;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull FieldLayout entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        log.debug("Exporting users and groups for fieldConfiguration with id {} for migration {} under exportMode {}", objectArray);
        this.exportFieldLayoutItems(ctx, entity);
    }

    /*
     * Unable to fully structure code
     */
    private final void exportFieldLayoutItems(ExportContext ctx, FieldLayout jiraFieldLayout) {
        v0 = jiraFieldLayout.getFieldLayoutItems();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getFieldLayoutItems(...)");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var5_5 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (FieldLayoutItem)element$iv$iv;
            $i$a$-filter-FieldLayoutExporter$exportFieldLayoutItems$1 = false;
            if (!(it.getOrderableField() instanceof CustomField)) ** GOTO lbl-1000
            v1 = ctx.getLockedCustomFieldCache();
            v2 = it.getOrderableField();
            Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type com.atlassian.jira.issue.fields.CustomField");
            if (v1.containsKey(((CustomField)v2).getIdAsLong())) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            it = (FieldLayoutItem)element$iv;
            $i$a$-forEach-FieldLayoutExporter$exportFieldLayoutItems$2 = false;
            field = it.getOrderableField();
            if (this.exportFilters.isSupportedField(ctx, (Field)field)) {
                v4 = this.exportService;
                v5 = "" + jiraFieldLayout.getId() + '-' + field.getId();
                Intrinsics.checkNotNull((Object)it);
                ExportOrThrow.DefaultImpls.exportOrThrow$default(v4, ctx, new FieldLayoutItemWrapper(v5, jiraFieldLayout, it), false, 4, null);
                continue;
            }
            msg = "is referenced in field layout \"" + jiraFieldLayout.getName() + "\"(" + jiraFieldLayout.getId() + ')';
            if (field instanceof CustomField) {
                CustomFieldUtilsKt.handleUnsupported((CustomField)field, ctx);
                v6 = FieldLayoutExporter.log;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"log");
                ExportLoggers.INSTANCE.logUnsupportedCustomField(v6, (CustomField)field, msg);
                continue;
            }
            v7 = FieldLayoutExporter.log;
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"log");
            Intrinsics.checkNotNull((Object)field);
            ExportLoggers.INSTANCE.logUnsupportedStandardField(v7, (Field)field, msg);
        }
    }

    @Override
    @Nullable
    public FieldLayout extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull FieldLayout entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/core/fieldlayout/FieldLayoutExporter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

