/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.fieldlayout;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.migration.export.core.fieldlayout.FieldLayoutItemWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.MRIType;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.classic.fieldlayout.FieldLayoutItem;
import com.atlassian.migration.jira.core.JiraCoreMriRegistry;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\b\u0010\u001c\u001a\u00020\u0014H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/jira/migration/export/core/fieldlayout/FieldLayoutItemExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/core/fieldlayout/FieldLayoutItemWrapper;", "Lcom/atlassian/migration/jira/classic/fieldlayout/FieldLayoutItem;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapField", "Lcom/atlassian/migration/base/mri/MRI;", "field", "Lcom/atlassian/jira/issue/fields/Field;", "mriForEntity", "mriForKey", "entityKey", "postConstruct", "jira-migration-plugin"})
public final class FieldLayoutItemExporter
implements Exporter<String, FieldLayoutItemWrapper, FieldLayoutItem> {
    @NotNull
    private final ExportService exportService;
    private final Logger log;
    @NotNull
    private final ExporterKey key;

    @Inject
    public FieldLayoutItemExporter(@NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.exportService = exportService;
        this.log = LoggerFactory.getLogger(FieldLayoutItemExporter.class);
        this.key = new ExporterKey(FieldLayoutItem.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, FieldLayoutItemWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull FieldLayoutItemWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.mriForKey(entity.getId());
    }

    @Override
    @NotNull
    public MRI mriForKey(@NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return MriExtensionsKt.mri$default(FieldLayoutItem.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public FieldLayoutItem exportData(@NotNull ExportContext ctx, @NotNull FieldLayoutItemWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        MRI mRI = this.mriForEntity(entity);
        MRI mRI2 = ExportService.checkExportedOrThrow$default(this.exportService, ctx, entity.getFieldLayout(), null, 4, null);
        OrderableField orderableField = entity.getItem().getOrderableField();
        Intrinsics.checkNotNullExpressionValue((Object)orderableField, (String)"getOrderableField(...)");
        MRI mRI3 = this.mapField(ctx, (Field)orderableField);
        String string = entity.getItem().getRawFieldDescription();
        boolean bl = entity.getItem().isHidden();
        boolean bl2 = entity.getItem().isRequired();
        String string2 = entity.getItem().getRendererType();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRendererType(...)");
        return new FieldLayoutItem(mRI, mRI2, mRI3, string, bl, bl2, string2);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull FieldLayoutItemWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting users and groups for fieldLayoutItem {} for migration {} under exportMode {}", objectArray);
        OrderableField orderableField = entity.getItem().getOrderableField();
        Intrinsics.checkNotNullExpressionValue((Object)orderableField, (String)"getOrderableField(...)");
        this.mapField(ctx, (Field)orderableField);
    }

    private final MRI mapField(ExportContext ctx, Field field) {
        MRI mRI;
        if (field instanceof CustomField) {
            mRI = ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, field, false, 4, null);
        } else {
            EntityType entityType = JiraCoreMriRegistry.INSTANCE.getStandardField();
            String string = field.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            mRI = MriExtensionsKt.mri(entityType, string, MRIType.RESULTING);
        }
        return mRI;
    }

    @Override
    @Nullable
    public FieldLayoutItemWrapper extractServerEntity(@NotNull ExportContext ctx, @NotNull String entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull FieldLayoutItemWrapper entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

