/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.fieldlayout;

import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeEntity;
import com.atlassian.jira.migration.export.core.fieldlayout.FieldConfigurationSchemeWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.classic.fieldlayout.IssueTypeFieldLayoutLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\b\u0010 \u001a\u00020\u0016H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/export/core/fieldlayout/FieldLayoutSchemeExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/core/fieldlayout/FieldConfigurationSchemeWrapper;", "Lcom/atlassian/migration/jira/classic/fieldlayout/FieldLayoutScheme;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "fieldLayoutManager", "Lcom/atlassian/jira/issue/fields/layout/field/FieldLayoutManager;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/issue/fields/layout/field/FieldLayoutManager;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapIssueTypeFieldLayoutLinks", "", "Lcom/atlassian/migration/jira/classic/fieldlayout/IssueTypeFieldLayoutLink;", "fieldConfigurationScheme", "Lcom/atlassian/jira/issue/fields/layout/field/FieldConfigurationScheme;", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nFieldLayoutSchemeExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldLayoutSchemeExporter.kt\ncom/atlassian/jira/migration/export/core/fieldlayout/FieldLayoutSchemeExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n766#2:230\n857#2,2:231\n1549#2:233\n1620#2,3:234\n*S KotlinDebug\n*F\n+ 1 FieldLayoutSchemeExporter.kt\ncom/atlassian/jira/migration/export/core/fieldlayout/FieldLayoutSchemeExporter\n*L\n112#1:230\n112#1:231,2\n113#1:233\n113#1:234,3\n*E\n"})
public final class FieldLayoutSchemeExporter
implements Exporter<String, FieldConfigurationSchemeWrapper, com.atlassian.migration.jira.classic.fieldlayout.FieldLayoutScheme> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final FieldLayoutManager fieldLayoutManager;
    private final Logger log;
    @NotNull
    private final ExporterKey key;

    @Inject
    public FieldLayoutSchemeExporter(@NotNull ExportService exportService, @NotNull FieldLayoutManager fieldLayoutManager) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)fieldLayoutManager, (String)"fieldLayoutManager");
        this.exportService = exportService;
        this.fieldLayoutManager = fieldLayoutManager;
        this.log = LoggerFactory.getLogger(FieldLayoutSchemeExporter.class);
        this.key = new ExporterKey(com.atlassian.migration.jira.classic.fieldlayout.FieldLayoutScheme.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, FieldConfigurationSchemeWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull FieldConfigurationSchemeWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object object = entity.getFieldConfigurationScheme();
        if (object == null || (object = object.getId()) == null || (object = String.valueOf(object)) == null) {
            object = "default";
        }
        return this.mriForKey((String)object);
    }

    @Override
    @NotNull
    public MRI mriForKey(@NotNull String entityKey) {
        Intrinsics.checkNotNullParameter((Object)entityKey, (String)"entityKey");
        return MriExtensionsKt.mri$default(com.atlassian.migration.jira.classic.fieldlayout.FieldLayoutScheme.Companion.getEntityType(), entityKey, null, 2, null);
    }

    @Override
    @NotNull
    public com.atlassian.migration.jira.classic.fieldlayout.FieldLayoutScheme exportData(@NotNull ExportContext ctx, @NotNull FieldConfigurationSchemeWrapper entity) {
        com.atlassian.migration.jira.classic.fieldlayout.FieldLayoutScheme fieldLayoutScheme;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        FieldConfigurationScheme fieldConfigurationScheme = new Object[3];
        fieldConfigurationScheme[0] = ctx.getMigrationId();
        FieldConfigurationScheme fieldConfigurationScheme2 = entity.getFieldConfigurationScheme();
        fieldConfigurationScheme[1] = fieldConfigurationScheme2 != null ? fieldConfigurationScheme2.getId() : null;
        fieldConfigurationScheme[2] = ctx.getExportMode();
        this.log.debug("[MigrationId:{}] Exporting fieldConfigurationScheme with id {} under exportMode:{}", (Object[])fieldConfigurationScheme);
        fieldConfigurationScheme = entity.getFieldConfigurationScheme();
        if (fieldConfigurationScheme != null) {
            FieldConfigurationScheme it = fieldConfigurationScheme;
            boolean bl = false;
            Long defaultLayoutForSchemeId = it.getFieldLayoutId(null);
            FieldLayout defaultLayoutForScheme = this.fieldLayoutManager.getFieldLayout(defaultLayoutForSchemeId);
            MRI mRI = this.mriForEntity(entity);
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            fieldLayoutScheme = new com.atlassian.migration.jira.classic.fieldlayout.FieldLayoutScheme(mRI, string, it.getDescription(), ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, defaultLayoutForScheme, false, 4, null), this.mapIssueTypeFieldLayoutLinks(ctx, it), null, null, 96, null);
        } else {
            FieldLayoutSchemeExporter it = this;
            boolean bl = false;
            FieldLayout defaultFieldLayoutForServer = this.fieldLayoutManager.getFieldLayout();
            fieldLayoutScheme = new com.atlassian.migration.jira.classic.fieldlayout.FieldLayoutScheme(this.mriForKey("default"), "Default Field Configuration Scheme", "Default Field Configuration Scheme", ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, defaultFieldLayoutForServer, false, 4, null), CollectionsKt.emptyList(), null, null, 96, null);
        }
        return fieldLayoutScheme;
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull FieldConfigurationSchemeWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[3];
        FieldConfigurationScheme fieldConfigurationScheme = entity.getFieldConfigurationScheme();
        objectArray[0] = fieldConfigurationScheme != null ? fieldConfigurationScheme.getId() : null;
        objectArray[1] = ctx.getMigrationId();
        objectArray[2] = ctx.getExportMode();
        this.log.debug("Exporting users and groups for fieldConfigurationScheme with id {} for migration {} under exportMode {}", objectArray);
        if (entity.getFieldConfigurationScheme() != null) {
            Long defaultLayoutForSchemeId = entity.getFieldConfigurationScheme().getFieldLayoutId(null);
            FieldLayout defaultLayoutForScheme = this.fieldLayoutManager.getFieldLayout(defaultLayoutForSchemeId);
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, defaultLayoutForScheme, false, 4, null);
            this.mapIssueTypeFieldLayoutLinks(ctx, entity.getFieldConfigurationScheme());
        } else {
            FieldLayout defaultFieldLayoutForServer = this.fieldLayoutManager.getFieldLayout();
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, defaultFieldLayoutForServer, false, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<IssueTypeFieldLayoutLink> mapIssueTypeFieldLayoutLinks(ExportContext ctx, FieldConfigurationScheme fieldConfigurationScheme) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FieldLayoutSchemeEntity it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        FieldLayoutScheme fieldLayoutScheme = this.fieldLayoutManager.getMutableFieldLayoutScheme(fieldConfigurationScheme.getId());
        Collection collection = fieldLayoutScheme.getEntities();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEntities(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FieldLayoutSchemeEntity)element$iv$iv;
            boolean bl = false;
            if (!(it.getIssueType() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void schemeEntity;
            it = (FieldLayoutSchemeEntity)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            FieldLayout jiraFieldLayout = this.fieldLayoutManager.getFieldLayout(schemeEntity.getFieldLayoutId());
            collection2.add(new IssueTypeFieldLayoutLink(ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, schemeEntity.getIssueType(), false, 4, null), ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, jiraFieldLayout, false, 4, null)));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public FieldConfigurationSchemeWrapper extractServerEntity(@NotNull ExportContext ctx, @NotNull String entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull FieldConfigurationSchemeWrapper entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

