/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.filter;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.migration.export.core.filter.FilterSharePermissionWrapper;
import com.atlassian.jira.migration.export.core.filter.SearchRequestWrapper;
import com.atlassian.jira.migration.export.core.filter.service.retrieve.FilterRetrieveService;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.model.GroupRefModel;
import com.atlassian.jira.migration.export.model.UserRef;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.ExportFilters;
import com.atlassian.jira.migration.log.EntityIdentifierGenerator;
import com.atlassian.jira.migration.utility.JQLUtility;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.core.Filter;
import com.atlassian.migration.jira.core.JQL;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 22\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u00012B/\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ$\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0007J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0002H\u0016J.\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J \u0010+\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J \u0010,\u001a\u00020-2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010.\u001a\u00020-H\u0002J\u0010\u0010/\u001a\u00020-2\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0010\u00100\u001a\u00020-2\u0006\u0010#\u001a\u00020\u0002H\u0016J\b\u00101\u001a\u00020\u0017H\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00063"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/FilterExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/core/filter/SearchRequestWrapper;", "Lcom/atlassian/migration/jira/core/Filter;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "exportFilters", "Lcom/atlassian/jira/migration/export/utils/ExportFilters;", "identifierGenerator", "Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;", "jqlUtility", "Lcom/atlassian/jira/migration/utility/JQLUtility;", "filterRetrieveService", "Lcom/atlassian/jira/migration/export/core/filter/service/retrieve/FilterRetrieveService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/utils/ExportFilters;Lcom/atlassian/jira/migration/log/EntityIdentifierGenerator;Lcom/atlassian/jira/migration/utility/JQLUtility;Lcom/atlassian/jira/migration/export/core/filter/service/retrieve/FilterRetrieveService;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "childrenActions", "", "Lkotlin/Function0;", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportData", "exportJql", "Lcom/atlassian/migration/jira/core/JQL;", "jql", "", "exportSharePermissions", "exportUsersAndGroups", "extractServerEntity", "entityKey", "isNotSharedToOtherProjects", "", "sharePermission", "Lcom/atlassian/jira/sharing/SharePermission;", "currentProjectIds", "searchRequest", "Lcom/atlassian/jira/issue/search/SearchRequest;", "isSupportedSharePermission", "mapOwner", "Lcom/atlassian/migration/base/mri/MRI;", "mri", "mriForEntity", "mriForKey", "postConstruct", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nFilterExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterExporter.kt\ncom/atlassian/jira/migration/export/core/filter/FilterExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1#2:141\n766#3:142\n857#3,2:143\n1855#3,2:145\n*S KotlinDebug\n*F\n+ 1 FilterExporter.kt\ncom/atlassian/jira/migration/export/core/filter/FilterExporter\n*L\n109#1:142\n109#1:143,2\n117#1:145,2\n*E\n"})
public final class FilterExporter
implements Exporter<Long, SearchRequestWrapper, Filter> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final ExportFilters exportFilters;
    @NotNull
    private final EntityIdentifierGenerator identifierGenerator;
    @NotNull
    private final JQLUtility jqlUtility;
    @NotNull
    private final FilterRetrieveService filterRetrieveService;
    @NotNull
    private final ExporterKey key;
    private static final Logger log = LoggerFactory.getLogger(FilterExporter.class);

    @Inject
    public FilterExporter(@NotNull ExportService exportService, @NotNull ExportFilters exportFilters, @NotNull EntityIdentifierGenerator identifierGenerator, @NotNull JQLUtility jqlUtility, @NotNull FilterRetrieveService filterRetrieveService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)exportFilters, (String)"exportFilters");
        Intrinsics.checkNotNullParameter((Object)identifierGenerator, (String)"identifierGenerator");
        Intrinsics.checkNotNullParameter((Object)jqlUtility, (String)"jqlUtility");
        Intrinsics.checkNotNullParameter((Object)filterRetrieveService, (String)"filterRetrieveService");
        this.exportService = exportService;
        this.exportFilters = exportFilters;
        this.identifierGenerator = identifierGenerator;
        this.jqlUtility = jqlUtility;
        this.filterRetrieveService = filterRetrieveService;
        this.key = new ExporterKey(Filter.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, SearchRequestWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public Filter exportData(@NotNull ExportContext ctx, @NotNull SearchRequestWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[3];
        objectArray[0] = ctx.getMigrationId();
        SearchRequest searchRequest = entity.getSearchRequest();
        objectArray[1] = searchRequest != null ? searchRequest.getId() : null;
        objectArray[2] = ctx.getExportMode();
        log.debug("[MigrationId:{}] Exporting filter with id {} under exportMode:{}", objectArray);
        MRI mRI = this.mriForEntity(entity);
        String string = entity.getSearchRequest().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = entity.getSearchRequest().getDescription();
        MRI mRI2 = this.mapOwner(ctx, entity, this.mriForEntity(entity));
        String string3 = entity.getSearchRequest().getQuery().getQueryString();
        if (string3 == null) {
            string3 = "";
        }
        JQL jQL = this.exportJql(entity, string3);
        Long l = entity.getSearchRequest().getFavouriteCount();
        long l2 = 0L;
        boolean bl = l == null || l != l2;
        Long l3 = entity.getSearchRequest().getFavouriteCount();
        Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"getFavouriteCount(...)");
        return new Filter(mRI, string, string2, mRI2, jQL, bl, ((Number)l3).longValue(), null);
    }

    private final JQL exportJql(SearchRequestWrapper entity, String jql) {
        Pair<Boolean, String> pair = this.jqlUtility.validateJQL(jql);
        boolean isValid = (Boolean)pair.component1();
        String error = (String)pair.component2();
        if (isValid) {
            return new JQL(jql);
        }
        throw new ExportException(this.mriForEntity(entity), ExportErrorCode.FILTER_HAS_INVALID_JQL, "JQL referred in filter " + entity.getSearchRequest().getName() + " is invalid - " + error, "Please set a valid JQL.", null, null, null, 112, null);
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull SearchRequestWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getSearchRequest().getId(), ctx.getMigrationId(), ctx.getExportMode()};
        log.debug("Exporting users and groups for filter {} for migration {} under exportMode {}", objectArray);
        this.mapOwner(ctx, entity, this.mriForEntity(entity));
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull SearchRequestWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return CollectionsKt.listOf((Object)new Function0<Unit>(this, ctx, entity){
            final /* synthetic */ FilterExporter this$0;
            final /* synthetic */ ExportContext $ctx;
            final /* synthetic */ SearchRequestWrapper $entity;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$entity = $entity;
                super(0);
            }

            public final void invoke() {
                this.this$0.exportSharePermissions(this.$ctx, this.$entity);
            }
        });
    }

    @Override
    @Nullable
    public SearchRequestWrapper extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        SearchRequestWrapper searchRequestWrapper;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        SearchRequest searchRequest = this.filterRetrieveService.retrieveById(entityKey);
        if (searchRequest != null) {
            SearchRequest it = searchRequest;
            boolean bl = false;
            searchRequestWrapper = new SearchRequestWrapper("ReferredById", it);
        } else {
            searchRequestWrapper = null;
        }
        return searchRequestWrapper;
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull SearchRequestWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getSearchRequest().getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(Filter.Companion.getEntityType(), entityKey, null, 2, null);
    }

    private final MRI mapOwner(ExportContext ctx, SearchRequestWrapper entity, MRI mri) {
        MRI mRI;
        block3: {
            block2: {
                UserRef userRef = UserRef.Companion.fromString(entity.getSearchRequest().getOwnerUserName());
                if (userRef == null) break block2;
                UserRef it = userRef;
                boolean bl = false;
                mRI = this.exportService.userRef(ctx, it);
                if (mRI != null) break block3;
            }
            String string = EntityIdentifierGenerator.generate$default(this.identifierGenerator, mri, entity, null, 4, null) + " has no owner assigned or no longer exists";
            ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_SEARCH_REQUEST_HAS_NO_OWNER;
            throw new ExportException(mri, exportErrorCode, string, "Please set an owner for this search request.", null, null, null, 112, null);
        }
        return mRI;
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    public final void exportSharePermissions(@NotNull ExportContext ctx, @NotNull SearchRequestWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        searchRequest = entity.getSearchRequest();
        v0 = searchRequest.getPermissions().getPermissionSet();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getPermissionSet(...)");
        var4_4 = CollectionsKt.filterNotNull((Iterable)v0);
        $i$f$filter = false;
        var6_6 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            sharePermission = (SharePermission)element$iv$iv;
            $i$a$-filter-FilterExporter$exportSharePermissions$1 = false;
            if (!this.isSupportedSharePermission(sharePermission, searchRequest, entity) || !this.isNotSharedToOtherProjects(sharePermission, ctx.getProjectIds(), searchRequest, entity)) ** GOTO lbl-1000
            v1 = this.exportService;
            v2 = sharePermission;
            v3 = var13_15 = sharePermission.getParam1();
            if (v3 != null) {
                Intrinsics.checkNotNull((Object)v3);
                var14_16 = var13_15;
                var15_17 = v2;
                var16_18 = v1;
                $i$a$-let-FilterExporter$exportSharePermissions$1$1 = false;
                var18_20 = sharePermission.getParam1();
                v1 = var16_18;
                v2 = var15_17;
                v4 = var18_20;
            } else {
                v4 = null;
            }
            v5 = var19_21 = v4;
            if (v5 == null) {
                v6 = "undefined";
            } else {
                Intrinsics.checkNotNull(v5);
                v6 = var19_21;
            }
            var20_22 = String.valueOf(searchRequest.getId());
            var21_23 = "Filter Share Permission";
            var22_24 = v6;
            if (v1.skipInvalidGroup(v2, new GroupRefModel(var22_24, var21_23, var20_22))) {
                v7 = true;
            } else lbl-1000:
            // 2 sources

            {
                v7 = false;
            }
            if (!v7) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (SharePermission)element$iv;
            $i$a$-forEach-FilterExporter$exportSharePermissions$2 = false;
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, new FilterSharePermissionWrapper(entity, it), false, 4, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNotSharedToOtherProjects(SharePermission sharePermission, List<Long> currentProjectIds, SearchRequest searchRequest, SearchRequestWrapper entity) {
        boolean bl;
        if (!Intrinsics.areEqual((Object)sharePermission.getType(), (Object)ShareType.Name.PROJECT)) return true;
        String string = sharePermission.getParam1();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParam1(...)");
        if (currentProjectIds.contains(Long.parseLong(string))) return true;
        boolean bl2 = true;
        boolean it = bl = bl2;
        boolean bl3 = false;
        if (it) {
            log.warn("SharePermission " + sharePermission.getId() + " [" + sharePermission.getType() + "] (on Filter '" + searchRequest.getId() + "' in " + entity.getParentIdentifier() + ") is referring to a different project. Skipping...");
        }
        if (bl) return false;
        return true;
    }

    private final boolean isSupportedSharePermission(SharePermission sharePermission, SearchRequest searchRequest, SearchRequestWrapper entity) {
        boolean bl;
        boolean it = bl = this.exportFilters.isSupportedSharePermission(sharePermission);
        boolean bl2 = false;
        if (!it) {
            log.warn("SharePermission " + sharePermission.getId() + " [" + sharePermission.getType() + "] (on Filter '" + searchRequest.getId() + "' in " + entity.getParentIdentifier() + ") is not supported. Skipping...");
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/FilterExporter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

