/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.filter;

import com.atlassian.jira.migration.export.core.SharePermissionExportHandler;
import com.atlassian.jira.migration.export.core.filter.FilterSharePermissionWrapper;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.Exporter;
import com.atlassian.jira.migration.export.framework.ExporterKey;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.core.SharePermission;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/FilterSharePermissionExporter;", "Lcom/atlassian/jira/migration/export/framework/Exporter;", "", "Lcom/atlassian/jira/migration/export/core/filter/FilterSharePermissionWrapper;", "Lcom/atlassian/migration/jira/core/SharePermission;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "sharePermissionExportHandler", "Lcom/atlassian/jira/migration/export/core/SharePermissionExportHandler;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/core/SharePermissionExportHandler;)V", "key", "Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "getKey", "()Lcom/atlassian/jira/migration/export/framework/ExporterKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "exportData", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "entity", "exportUsersAndGroups", "", "mapSharePermissionData", "Lcom/atlassian/migration/jira/core/SharePermission$SharePermissionData;", "mriForEntity", "Lcom/atlassian/migration/base/mri/MRI;", "mriForKey", "entityKey", "postConstruct", "jira-migration-plugin"})
public final class FilterSharePermissionExporter
implements Exporter<Long, FilterSharePermissionWrapper, SharePermission> {
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final SharePermissionExportHandler sharePermissionExportHandler;
    private final Logger log;
    @NotNull
    private final ExporterKey key;

    @Inject
    public FilterSharePermissionExporter(@NotNull ExportService exportService, @NotNull SharePermissionExportHandler sharePermissionExportHandler) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)sharePermissionExportHandler, (String)"sharePermissionExportHandler");
        this.exportService = exportService;
        this.sharePermissionExportHandler = sharePermissionExportHandler;
        this.log = LoggerFactory.getLogger(FilterSharePermissionExporter.class);
        this.key = new ExporterKey(SharePermission.Companion.getEntityType());
    }

    @PostConstruct
    public final void postConstruct() {
        this.exportService.registerExporter(this.getKey(), this, FilterSharePermissionWrapper.class);
    }

    @Override
    @NotNull
    public ExporterKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public SharePermission exportData(@NotNull ExportContext ctx, @NotNull FilterSharePermissionWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getSharePermission().getId(), entity.getFilterWrapper().getSearchRequest().getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting filterSharePermission {} associated with filter {} for migration {} under exportMode {}", objectArray);
        return new SharePermission(this.mriForEntity(entity), ExportService.checkExportedOrThrow$default(this.exportService, ctx, entity.getFilterWrapper(), null, 4, null), this.mapSharePermissionData(ctx, entity));
    }

    @Override
    public void exportUsersAndGroups(@NotNull ExportContext ctx, @NotNull FilterSharePermissionWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object[] objectArray = new Object[]{entity.getSharePermission().getId(), entity.getFilterWrapper().getSearchRequest().getId(), ctx.getMigrationId(), ctx.getExportMode()};
        this.log.debug("Exporting users and groups for sharePermission {} associated with filter {} for migration {} under exportMode {}", objectArray);
        this.mapSharePermissionData(ctx, entity);
    }

    @Override
    @NotNull
    public MRI mriForEntity(@NotNull FilterSharePermissionWrapper entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Long l = entity.getSharePermission().getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        return this.mriForKey(((Number)l).longValue());
    }

    @Override
    @NotNull
    public MRI mriForKey(long entityKey) {
        return MriExtensionsKt.mri$default(SharePermission.Companion.getEntityType(), entityKey, null, 2, null);
    }

    private final SharePermission.SharePermissionData mapSharePermissionData(ExportContext ctx, FilterSharePermissionWrapper entity) {
        return this.sharePermissionExportHandler.mapSharePermissionData(ctx, entity);
    }

    @Override
    @Nullable
    public FilterSharePermissionWrapper extractServerEntity(@NotNull ExportContext ctx, long entityKey) {
        return Exporter.DefaultImpls.extractServerEntity(this, ctx, entityKey);
    }

    @Override
    @NotNull
    public List<Function0<Unit>> childrenActions(@NotNull ExportContext ctx, @NotNull FilterSharePermissionWrapper entity) {
        return Exporter.DefaultImpls.childrenActions(this, ctx, entity);
    }
}

