/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.filter.service;

import com.atlassian.jira.migration.export.core.filter.service.FilterExportService;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.features.MigrationFeatures;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/service/FeatureFlagProtectedFilterExportService;", "", "filterExportService", "Lcom/atlassian/jira/migration/export/core/filter/service/FilterExportService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/export/core/filter/service/FilterExportService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "export", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "exportAllFilters", "jira-migration-plugin"})
public final class FeatureFlagProtectedFilterExportService {
    @NotNull
    private final FilterExportService filterExportService;
    @NotNull
    private final MigrationFeatures migrationFeatures;

    @Inject
    public FeatureFlagProtectedFilterExportService(@NotNull FilterExportService filterExportService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)filterExportService, (String)"filterExportService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.filterExportService = filterExportService;
        this.migrationFeatures = migrationFeatures;
    }

    public final void export(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this.migrationFeatures.getEnableExportSharedFilters()) {
            this.filterExportService.exportSharedFilters(ctx);
        }
        if (this.migrationFeatures.getEnableExportAllFilters()) {
            this.filterExportService.exportAllFilters(ctx);
        }
    }

    public final void exportAllFilters(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this.migrationFeatures.getEnableExportAllFilters()) {
            this.filterExportService.exportAllFilters(ctx);
        }
    }
}

