/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.filter.service;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.migration.common.PaginatedList;
import com.atlassian.jira.migration.export.core.filter.SearchRequestWrapper;
import com.atlassian.jira.migration.export.core.filter.service.jql.FilterJqlService;
import com.atlassian.jira.migration.export.core.filter.service.retrieve.FilterRetrieveService;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportMode;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.export.utils.InMemExportingMemoryService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.serverdataextractors.cpb.model.CrossProjectFilterReferringProjectsInfo;
import com.atlassian.jira.migration.serverdataextractors.cpb.service.CPBFilterService;
import com.atlassian.migration.base.mri.MRI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 32\u00020\u0001:\u00013B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0013H\u0002J\u0018\u0010!\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020#0\u001aH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010-\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010.\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010/\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J&\u00100\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00101\u001a\u00020#2\f\u00102\u001a\b\u0012\u0004\u0012\u00020#0\u001aH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/service/FilterExportService;", "", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "filterRetrieveService", "Lcom/atlassian/jira/migration/export/core/filter/service/retrieve/FilterRetrieveService;", "exportingMemoryService", "Lcom/atlassian/jira/migration/export/utils/InMemExportingMemoryService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "cpbFilterService", "Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBFilterService;", "filterJqlService", "Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService;", "(Lcom/atlassian/jira/migration/export/service/ExportService;Lcom/atlassian/jira/migration/export/core/filter/service/retrieve/FilterRetrieveService;Lcom/atlassian/jira/migration/export/utils/InMemExportingMemoryService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBFilterService;Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService;)V", "exportAPageOfSharedFilters", "", "pageOfSearchRequest", "Lcom/atlassian/jira/migration/common/PaginatedList;", "Lcom/atlassian/jira/issue/search/SearchRequest;", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "exportAllCrossProjectFilters", "exportAllFilters", "exportCrossProjectFilters", "crossProjectFiltersList", "", "exportCrossProjectFiltersReferringAnySelectedProject", "exportFilter", "Lcom/atlassian/migration/base/mri/MRI;", "parentIdentifier", "", "searchRequest", "exportFilterById", "id", "", "exportSharedFilters", "getAllCrossProjectFilters", "getCrossProjectFiltersReferringAnySelectedProject", "selectedProjectIds", "isExportModeEligibleForMemoriseSkip", "", "exportMode", "Lcom/atlassian/jira/migration/export/framework/ExportMode;", "logSkippingExportCrossProjectFilters", "shouldExportAllFilters", "shouldExportCrossProjectFilters", "shouldSkipTryMemorizeExportingFilters", "updateFiltersCrossProjectsMapping", "filterId", "referringProjectIds", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nFilterExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterExportService.kt\ncom/atlassian/jira/migration/export/core/filter/service/FilterExportService\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1313#2,2:183\n1549#3:185\n1620#3,3:186\n1549#3:189\n1620#3,3:190\n1855#3,2:193\n1855#3,2:195\n*S KotlinDebug\n*F\n+ 1 FilterExportService.kt\ncom/atlassian/jira/migration/export/core/filter/service/FilterExportService\n*L\n38#1:183,2\n95#1:185\n95#1:186,3\n104#1:189\n104#1:190,3\n120#1:193,2\n146#1:195,2\n*E\n"})
public final class FilterExportService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportService exportService;
    @NotNull
    private final FilterRetrieveService filterRetrieveService;
    @NotNull
    private final InMemExportingMemoryService exportingMemoryService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final CPBFilterService cpbFilterService;
    @NotNull
    private final FilterJqlService filterJqlService;
    private static final Logger log = LoggerFactory.getLogger(FilterExportService.class);
    @NotNull
    private static final String OWNED_PARENT_IDENTIFIER = "Owned";
    @NotNull
    private static final Set<ExportMode> exportModeSet;

    @Inject
    public FilterExportService(@NotNull ExportService exportService, @NotNull FilterRetrieveService filterRetrieveService, @NotNull InMemExportingMemoryService exportingMemoryService, @NotNull MigrationFeatures migrationFeatures, @NotNull CPBFilterService cpbFilterService, @NotNull FilterJqlService filterJqlService) {
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        Intrinsics.checkNotNullParameter((Object)filterRetrieveService, (String)"filterRetrieveService");
        Intrinsics.checkNotNullParameter((Object)exportingMemoryService, (String)"exportingMemoryService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)cpbFilterService, (String)"cpbFilterService");
        Intrinsics.checkNotNullParameter((Object)filterJqlService, (String)"filterJqlService");
        this.exportService = exportService;
        this.filterRetrieveService = filterRetrieveService;
        this.exportingMemoryService = exportingMemoryService;
        this.migrationFeatures = migrationFeatures;
        this.cpbFilterService = cpbFilterService;
        this.filterJqlService = filterJqlService;
    }

    public final void exportSharedFilters(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        log.info("Exporting shared filters for migration " + ctx.getMigrationId() + " under exportMode " + (Object)((Object)ctx.getExportMode()));
        Sequence $this$forEach$iv = FilterRetrieveService.retrieveAllSharedFiltersForProject$default(this.filterRetrieveService, ctx.getProject(), 0, 2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PaginatedList it = (PaginatedList)element$iv;
            boolean bl = false;
            this.exportAPageOfSharedFilters(it, ctx);
        }
    }

    private final boolean isExportModeEligibleForMemoriseSkip(ExportMode exportMode) {
        return exportModeSet.contains((Object)exportMode);
    }

    public final void exportAllFilters(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this.shouldExportAllFilters(ctx)) {
            try {
                log.info("Exporting all filters for migration " + ctx.getMigrationId() + " under exportMode " + (Object)((Object)ctx.getExportMode()));
                this.filterRetrieveService.visitAllFilters((Function1<? super SearchRequest, Unit>)((Function1)new Function1<SearchRequest, Unit>(this, ctx){
                    final /* synthetic */ FilterExportService this$0;
                    final /* synthetic */ ExportContext $ctx;
                    {
                        this.this$0 = $receiver;
                        this.$ctx = $ctx;
                        super(1);
                    }

                    public final void invoke(@NotNull SearchRequest it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        FilterJqlService.JqlProjectReferenceInfo projectReferenceInfo = FilterExportService.access$getFilterJqlService$p(this.this$0).collectProjectReferenceInfo((List<Long>)CollectionsKt.emptyList(), it);
                        if (projectReferenceInfo.isReferringMultiProjects()) {
                            Long l = it.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                            FilterExportService.access$updateFiltersCrossProjectsMapping(this.this$0, this.$ctx, ((Number)l).longValue(), projectReferenceInfo.getReferringProjectIds());
                        }
                        FilterExportService.access$exportFilter(this.this$0, this.$ctx, "Owned", it);
                    }
                }));
                this.exportingMemoryService.memorizeExportedAllFilters(ctx.getMigrationId(), ctx.getExportMode());
            }
            catch (Throwable e) {
                this.exportingMemoryService.memorizeExportFailedAllFilters(ctx.getMigrationId(), ctx.getExportMode());
                throw e;
            }
        }
    }

    @Nullable
    public final MRI exportFilterById(@NotNull ExportContext ctx, long id) {
        MRI mRI;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        SearchRequest searchRequest = this.filterRetrieveService.retrieveById(id);
        if (searchRequest != null) {
            SearchRequest it = searchRequest;
            boolean bl = false;
            mRI = this.exportFilter(ctx, "ReferredById", it);
        } else {
            mRI = null;
        }
        return mRI;
    }

    public final void exportAllCrossProjectFilters(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this.shouldExportCrossProjectFilters(ctx)) {
            List<SearchRequest> crossProjectFiltersList = this.getAllCrossProjectFilters(ctx);
            this.exportCrossProjectFilters(ctx, crossProjectFiltersList);
        } else {
            this.logSkippingExportCrossProjectFilters(ctx);
        }
    }

    public final void exportCrossProjectFiltersReferringAnySelectedProject(@NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this.shouldExportCrossProjectFilters(ctx)) {
            List<SearchRequest> crossProjectFiltersList = this.getCrossProjectFiltersReferringAnySelectedProject(ctx, ctx.getProjectIds());
            this.exportCrossProjectFilters(ctx, crossProjectFiltersList);
        } else {
            this.logSkippingExportCrossProjectFilters(ctx);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<SearchRequest> getAllCrossProjectFilters(ExportContext ctx) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.cpbFilterService.getCrossProjectFilterReferringProjectsInfoList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CrossProjectFilterReferringProjectsInfo crossProjectFilterReferringProjectsInfo = (CrossProjectFilterReferringProjectsInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Long l = it.getCrossProjectFilter().getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            this.updateFiltersCrossProjectsMapping(ctx, ((Number)l).longValue(), it.getReferringProjectIds());
            collection.add(it.getCrossProjectFilter());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SearchRequest> getCrossProjectFiltersReferringAnySelectedProject(ExportContext ctx, List<Long> selectedProjectIds) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.cpbFilterService.getCrossProjectFilterReferringProjectsInfoList(selectedProjectIds);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CrossProjectFilterReferringProjectsInfo crossProjectFilterReferringProjectsInfo = (CrossProjectFilterReferringProjectsInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Long l = it.getCrossProjectFilter().getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            this.updateFiltersCrossProjectsMapping(ctx, ((Number)l).longValue(), it.getReferringProjectIds());
            collection.add(it.getCrossProjectFilter());
        }
        return (List)destination$iv$iv;
    }

    private final void logSkippingExportCrossProjectFilters(ExportContext ctx) {
        log.info("Skipping exporting of cross project filters for migration: " + ctx.getMigrationId() + " having export mode: " + (Object)((Object)ctx.getExportMode()));
    }

    private final void exportCrossProjectFilters(ExportContext ctx, List<? extends SearchRequest> crossProjectFiltersList) {
        try {
            log.info("Exporting cross project filters for migration " + ctx.getMigrationId() + " under exportMode " + (Object)((Object)ctx.getExportMode()));
            Iterable $this$forEach$iv = crossProjectFiltersList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SearchRequest filter = (SearchRequest)element$iv;
                boolean bl = false;
                log.info("Exporting cross project filter " + filter.getName() + " under exportMode " + (Object)((Object)ctx.getExportMode()));
                this.exportFilter(ctx, OWNED_PARENT_IDENTIFIER, filter);
            }
            this.exportingMemoryService.memorizeExportedCrossProjectFilters(ctx.getMigrationId(), ctx.getExportMode());
        }
        catch (Throwable e) {
            this.exportingMemoryService.memorizeExportFailedCrossProjectFilters(ctx.getMigrationId(), ctx.getExportMode());
            throw e;
        }
    }

    private final boolean shouldExportAllFilters(ExportContext ctx) {
        return this.shouldSkipTryMemorizeExportingFilters(ctx.getExportMode()) || this.exportingMemoryService.tryMemorizeExportingAllFilters(ctx.getMigrationId(), ctx.getExportMode());
    }

    private final boolean shouldExportCrossProjectFilters(ExportContext ctx) {
        return this.shouldSkipTryMemorizeExportingFilters(ctx.getExportMode()) || this.exportingMemoryService.tryMemorizeExportingCrossProjectFilters(ctx.getMigrationId(), ctx.getExportMode());
    }

    private final boolean shouldSkipTryMemorizeExportingFilters(ExportMode exportMode) {
        return !this.migrationFeatures.getEnableFilterAndBoardMemorize() && this.isExportModeEligibleForMemoriseSkip(exportMode);
    }

    private final void exportAPageOfSharedFilters(PaginatedList<SearchRequest> pageOfSearchRequest, ExportContext ctx) {
        Iterable $this$forEach$iv = pageOfSearchRequest.getFetched();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SearchRequest it = (SearchRequest)element$iv;
            boolean bl = false;
            this.exportFilter(ctx, "Shared", it);
        }
    }

    private final MRI exportFilter(ExportContext ctx, String parentIdentifier, SearchRequest searchRequest) {
        SearchRequestWrapper searchRequestWrapper = new SearchRequestWrapper(parentIdentifier, searchRequest);
        return this.exportService.exportOrThrow(ctx, searchRequestWrapper, true);
    }

    private final void updateFiltersCrossProjectsMapping(ExportContext ctx, long filterId, List<Long> referringProjectIds) {
        Long l = filterId;
        ctx.getFiltersCrossProjectsMapping().put(l, referringProjectIds);
    }

    public static final /* synthetic */ FilterJqlService access$getFilterJqlService$p(FilterExportService $this) {
        return $this.filterJqlService;
    }

    public static final /* synthetic */ void access$updateFiltersCrossProjectsMapping(FilterExportService $this, ExportContext ctx, long filterId, List referringProjectIds) {
        $this.updateFiltersCrossProjectsMapping(ctx, filterId, referringProjectIds);
    }

    public static final /* synthetic */ MRI access$exportFilter(FilterExportService $this, ExportContext ctx, String parentIdentifier, SearchRequest searchRequest) {
        return $this.exportFilter(ctx, parentIdentifier, searchRequest);
    }

    static {
        ExportMode[] exportModeArray = new ExportMode[]{ExportMode.COLLECT_USER_AND_GROUP_REFS, ExportMode.COLLECT_PREFLIGHT_PROJECT_DATA};
        exportModeSet = SetsKt.setOf((Object[])exportModeArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/service/FilterExportService$Companion;", "", "()V", "OWNED_PARENT_IDENTIFIER", "", "exportModeSet", "", "Lcom/atlassian/jira/migration/export/framework/ExportMode;", "getExportModeSet", "()Ljava/util/Set;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<ExportMode> getExportModeSet() {
            return exportModeSet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

