/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.filter.service;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.classic.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0013B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/service/FilterSharingInfoService;", "", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "(Lcom/atlassian/jira/project/ProjectManager;)V", "collectProjectSharingInfo", "Lcom/atlassian/jira/migration/export/core/filter/service/FilterSharingInfoService$FilterProjectSharingInfo;", "filter", "Lcom/atlassian/jira/issue/search/SearchRequest;", "forSharedProjects", "", "Lcom/atlassian/migration/base/mri/MRI;", "Lcom/atlassian/jira/project/Project;", "searchRequest", "getProjectIdIfTypeMatched", "", "permission", "Lcom/atlassian/jira/sharing/SharePermission;", "(Lcom/atlassian/jira/sharing/SharePermission;)Ljava/lang/Long;", "FilterProjectSharingInfo", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nFilterSharingInfoService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterSharingInfoService.kt\ncom/atlassian/jira/migration/export/core/filter/service/FilterSharingInfoService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1603#2,9:52\n1855#2:61\n1856#2:63\n1612#2:64\n1603#2,9:65\n1855#2:74\n1856#2:76\n1612#2:77\n1194#2,2:78\n1222#2,4:80\n1#3:62\n1#3:75\n1#3:84\n*S KotlinDebug\n*F\n+ 1 FilterSharingInfoService.kt\ncom/atlassian/jira/migration/export/core/filter/service/FilterSharingInfoService\n*L\n24#1:52,9\n24#1:61\n24#1:63\n24#1:64\n25#1:65,9\n25#1:74\n25#1:76\n25#1:77\n26#1:78,2\n26#1:80,4\n24#1:62\n25#1:75\n*E\n"})
public final class FilterSharingInfoService {
    @NotNull
    private final ProjectManager projectManager;

    @Inject
    public FilterSharingInfoService(@NotNull ProjectManager projectManager) {
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        this.projectManager = projectManager;
    }

    @NotNull
    public final FilterProjectSharingInfo collectProjectSharingInfo(@NotNull SearchRequest filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        return new FilterProjectSharingInfo(this.forSharedProjects(filter));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<MRI, com.atlassian.jira.project.Project> forSharedProjects(SearchRequest searchRequest) {
        void $this$associateByTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Object element$iv$iv$iv2;
        void $this$mapNotNullTo$iv$iv2;
        SharedEntity.SharePermissions sharePermissions = searchRequest.getPermissions();
        Intrinsics.checkNotNullExpressionValue((Object)sharePermissions, (String)"getPermissions(...)");
        Iterable $this$mapNotNull$iv = (Iterable)sharePermissions;
        boolean $i$f$mapNotNull22 = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<Long> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            Long it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl = false;
            SharePermission p0 = (SharePermission)element$iv$iv;
            boolean bl2 = false;
            if (this.getProjectIdIfTypeMatched(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        ProjectManager $i$f$mapNotNull22 = this.projectManager;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            com.atlassian.jira.project.Project it$iv$iv;
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl = false;
            Long p0 = (Long)element$iv$iv;
            boolean bl4 = false;
            if ($i$f$mapNotNull22.getProjectObj(p0) == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv2;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$mapNotNullTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            element$iv$iv$iv2 = (com.atlassian.jira.project.Project)element$iv$iv;
            Object object = destination$iv$iv2;
            boolean bl = false;
            EntityType entityType = Project.Companion.getEntityType();
            Long l = it.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            object.put(MriExtensionsKt.mri$default(entityType, l, null, 2, null), element$iv$iv);
        }
        return destination$iv$iv2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Long getProjectIdIfTypeMatched(SharePermission permission) {
        String string;
        SharePermission sharePermission;
        SharePermission sharePermission2 = sharePermission = permission;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)sharePermission2.getType(), (Object)ShareType.Name.PROJECT)) return null;
        SharePermission sharePermission3 = sharePermission;
        SharePermission sharePermission4 = sharePermission3;
        if (sharePermission4 == null) return null;
        String string2 = sharePermission4.getParam1();
        if (string2 == null) return null;
        String string3 = string = string2;
        boolean bl2 = false;
        if (StringsKt.isBlank((CharSequence)string3)) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        String string4 = string;
        String string5 = string4;
        if (string5 == null) return null;
        Long l = Long.parseLong(string5);
        return l;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/service/FilterSharingInfoService$FilterProjectSharingInfo;", "", "sharingInfo", "", "Lcom/atlassian/migration/base/mri/MRI;", "Lcom/atlassian/jira/project/Project;", "(Ljava/util/Map;)V", "isSharedToOtherProjects", "", "expectedProjectIds", "", "", "otherSharedProjects", "projectIds", "jira-migration-plugin"})
    @SourceDebugExtension(value={"SMAP\nFilterSharingInfoService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterSharingInfoService.kt\ncom/atlassian/jira/migration/export/core/filter/service/FilterSharingInfoService$FilterProjectSharingInfo\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,51:1\n125#2:52\n152#2,3:53\n526#3:56\n511#3,6:57\n*S KotlinDebug\n*F\n+ 1 FilterSharingInfoService.kt\ncom/atlassian/jira/migration/export/core/filter/service/FilterSharingInfoService$FilterProjectSharingInfo\n*L\n39#1:52\n39#1:53,3\n45#1:56\n45#1:57,6\n*E\n"})
    public static final class FilterProjectSharingInfo {
        @NotNull
        private final Map<MRI, com.atlassian.jira.project.Project> sharingInfo;

        public FilterProjectSharingInfo(@NotNull Map<MRI, ? extends com.atlassian.jira.project.Project> sharingInfo) {
            Intrinsics.checkNotNullParameter(sharingInfo, (String)"sharingInfo");
            this.sharingInfo = sharingInfo;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isSharedToOtherProjects(@NotNull List<Long> expectedProjectIds) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(expectedProjectIds, (String)"expectedProjectIds");
            Map<MRI, com.atlassian.jira.project.Project> $this$map$iv = this.sharingInfo;
            boolean $i$f$map = false;
            Map<MRI, com.atlassian.jira.project.Project> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Long.parseLong(((MRI)it.getKey()).getEntityId()));
            }
            List actualProjectIds = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            return !((Collection)CollectionsKt.minus((Iterable)actualProjectIds, (Iterable)expectedProjectIds)).isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<com.atlassian.jira.project.Project> otherSharedProjects(@NotNull List<Long> projectIds) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(projectIds, (String)"projectIds");
            Map<MRI, com.atlassian.jira.project.Project> $this$filter$iv = this.sharingInfo;
            boolean $i$f$filter = false;
            Map<MRI, com.atlassian.jira.project.Project> map = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!(!projectIds.contains(Long.parseLong(((MRI)it.getKey()).getEntityId())))) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            return CollectionsKt.toList((Iterable)destination$iv$iv.values());
        }
    }
}

