/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.filter.service.jql;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.jql.context.QueryContextImpl;
import com.atlassian.jira.jql.context.QueryContextVisitor;
import com.atlassian.jira.migration.export.core.filter.service.jql.CachedFilterProjectsServiceKt;
import com.atlassian.jira.migration.export.core.filter.service.jql.FilterProjectsRetrieveService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jiraservice.JiraSearchService;
import com.atlassian.jira.migration.utility.JQLUtility;
import com.atlassian.jira.migration.utils.CustomQueryContextVisitor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!BM\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u001bJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u00172\u0006\u0010\u001c\u001a\u00020\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u00172\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160\u00172\u0006\u0010\u001e\u001a\u00020\u001bH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/export/core/filter/service/jql/CachedFilterProjectsService;", "", "queryContextVisitorFactory", "Lcom/atlassian/jira/migration/utils/CustomQueryContextVisitor$QueryContextVisitorFactory;", "searchRequestManager", "Lcom/atlassian/jira/issue/search/SearchRequestManager;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "jqlUtility", "Lcom/atlassian/jira/migration/utility/JQLUtility;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "jiraSearchService", "Lcom/atlassian/jira/migration/jiraservice/JiraSearchService;", "filterProjectsRetrieveServiceProvider", "Ljavax/inject/Provider;", "Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterProjectsRetrieveService;", "(Lcom/atlassian/jira/migration/utils/CustomQueryContextVisitor$QueryContextVisitorFactory;Lcom/atlassian/jira/issue/search/SearchRequestManager;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/utility/JQLUtility;Lcom/atlassian/cache/CacheManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/jiraservice/JiraSearchService;Ljavax/inject/Provider;)V", "filterToProjectsCache", "Lcom/atlassian/cache/Cache;", "", "", "clearCache", "", "getFilterById", "Lcom/atlassian/jira/issue/search/SearchRequest;", "filterId", "getProjectsFromFilter", "filter", "getProjectsFromFilterContext", "getProjectsFromQueryIssues", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCachedFilterProjectsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachedFilterProjectsService.kt\ncom/atlassian/jira/migration/export/core/filter/service/jql/CachedFilterProjectsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1360#2:169\n1446#2,5:170\n*S KotlinDebug\n*F\n+ 1 CachedFilterProjectsService.kt\ncom/atlassian/jira/migration/export/core/filter/service/jql/CachedFilterProjectsService\n*L\n118#1:169\n118#1:170,5\n*E\n"})
public final class CachedFilterProjectsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CustomQueryContextVisitor.QueryContextVisitorFactory queryContextVisitorFactory;
    @NotNull
    private final SearchRequestManager searchRequestManager;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final JQLUtility jqlUtility;
    @NotNull
    private final CacheManager cacheManager;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final JiraSearchService jiraSearchService;
    @NotNull
    private final Provider<FilterProjectsRetrieveService> filterProjectsRetrieveServiceProvider;
    @NotNull
    private final Cache<Long, Set<Long>> filterToProjectsCache;
    private static final org.apache.log4j.Logger log4jLogger = org.apache.log4j.Logger.getLogger(CachedFilterProjectsService.class);
    private static final Logger log = LoggerFactory.getLogger(CachedFilterProjectsService.class);

    @Inject
    public CachedFilterProjectsService(@NotNull CustomQueryContextVisitor.QueryContextVisitorFactory queryContextVisitorFactory, @NotNull SearchRequestManager searchRequestManager, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull JQLUtility jqlUtility, @NotNull CacheManager cacheManager, @NotNull MigrationFeatures migrationFeatures, @NotNull JiraSearchService jiraSearchService, @NotNull Provider<FilterProjectsRetrieveService> filterProjectsRetrieveServiceProvider) {
        Intrinsics.checkNotNullParameter((Object)queryContextVisitorFactory, (String)"queryContextVisitorFactory");
        Intrinsics.checkNotNullParameter((Object)searchRequestManager, (String)"searchRequestManager");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)jqlUtility, (String)"jqlUtility");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)jiraSearchService, (String)"jiraSearchService");
        Intrinsics.checkNotNullParameter(filterProjectsRetrieveServiceProvider, (String)"filterProjectsRetrieveServiceProvider");
        this.queryContextVisitorFactory = queryContextVisitorFactory;
        this.searchRequestManager = searchRequestManager;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.jqlUtility = jqlUtility;
        this.cacheManager = cacheManager;
        this.migrationFeatures = migrationFeatures;
        this.jiraSearchService = jiraSearchService;
        this.filterProjectsRetrieveServiceProvider = filterProjectsRetrieveServiceProvider;
        CacheSettings cacheSettings = new CacheSettingsBuilder().expireAfterWrite(1L, CachedFilterProjectsServiceKt.access$getCACHE_TIME_UNIT$p()).replicateViaCopy().remote().build();
        Intrinsics.checkNotNullExpressionValue((Object)cacheSettings, (String)"build(...)");
        CacheSettings cacheSetting = cacheSettings;
        Cache cache2 = this.cacheManager.getCache("FILTER_PROJECTS_CACHE", null, cacheSetting);
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"getCache(...)");
        this.filterToProjectsCache = cache2;
        this.filterToProjectsCache.removeAll();
    }

    @NotNull
    public final Set<Long> getProjectsFromFilter(long filterId) {
        return this.getProjectsFromFilter(this.getFilterById(filterId));
    }

    @NotNull
    public final Set<Long> getProjectsFromFilter(@Nullable SearchRequest filter) {
        Set set;
        SearchRequest searchRequest = filter;
        if (searchRequest != null) {
            SearchRequest it = searchRequest;
            boolean bl = false;
            set = (Set)this.filterToProjectsCache.get((Object)it.getId(), () -> CachedFilterProjectsService.getProjectsFromFilter$lambda$3$lambda$2(this, it));
        } else {
            set = null;
        }
        Set set2 = set;
        return set2 == null ? SetsKt.emptySet() : set2;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Long> getProjectsFromFilterContext(SearchRequest filter) {
        Object $this$getProjectsFromFilterContext_u24lambda_u245;
        Object object = this;
        try {
            void $this$flatMapTo$iv$iv;
            $this$getProjectsFromFilterContext_u24lambda_u245 = object;
            boolean bl = false;
            log.debug("Getting projects from filter context for filter [" + filter.getId() + ']');
            long startTime = System.currentTimeMillis();
            ((CachedFilterProjectsService)$this$getProjectsFromFilterContext_u24lambda_u245).jiraThreadLocalUtil.preCall();
            ImportUtils.setSubvertSecurityScheme((boolean)true);
            Clause clause = filter.getQuery().getWhereClause();
            CustomQueryContextVisitor visitor = ((CachedFilterProjectsService)$this$getProjectsFromFilterContext_u24lambda_u245).queryContextVisitorFactory.createVisitor();
            Object object2 = clause.accept((ClauseVisitor)visitor);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.atlassian.jira.jql.context.QueryContextVisitor.ContextResult");
            QueryContextVisitor.ContextResult result2 = (QueryContextVisitor.ContextResult)object2;
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            log.debug("Getting projects from filter context for filter [" + filter.getId() + "] with query [" + filter.getQuery().getQueryString() + "] took " + duration + " ms");
            Collection collection = new QueryContextImpl(result2.getFullContext()).getProjectIssueTypeContexts();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getProjectIssueTypeContexts(...)");
            Iterable $this$flatMap$iv = collection;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                QueryContext.ProjectIssueTypeContexts it = (QueryContext.ProjectIssueTypeContexts)element$iv$iv;
                boolean bl2 = false;
                List list = it.getProjectIdInList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProjectIdInList(...)");
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$getProjectsFromFilterContext_u24lambda_u245 = Result.constructor-impl((Object)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        }
        catch (Throwable bl) {
            $this$getProjectsFromFilterContext_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$getProjectsFromFilterContext_u24lambda_u245;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object ex = $this$getProjectsFromFilterContext_u24lambda_u245 = throwable;
            boolean bl = false;
            log.error("Failed to get projects from filter context for filter [" + filter.getId() + ']', (Throwable)ex);
        }
        Object it = object;
        boolean bl = false;
        ImportUtils.setSubvertSecurityScheme((boolean)false);
        this.jiraThreadLocalUtil.postCall(log4jLogger);
        Set set = SetsKt.emptySet();
        return (Set)(Result.isFailure-impl((Object)object) ? set : object);
    }

    private final Set<Long> getProjectsFromQueryIssues(SearchRequest filter) {
        log.debug("Getting projects from issues for filter [" + filter.getId() + ']');
        long startTime = System.currentTimeMillis();
        Object object = (FilterProjectsRetrieveService)this.filterProjectsRetrieveServiceProvider.get();
        if (object == null || (object = ((FilterProjectsRetrieveService)object).getProjectsFromQueryIssues(filter)) == null) {
            ApplicationUser applicationUser = filter.getOwner();
            Intrinsics.checkNotNullExpressionValue((Object)applicationUser, (String)"getOwner(...)");
            Query query = filter.getQuery();
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"getQuery(...)");
            object = CollectionsKt.toSet((Iterable)JiraSearchService.getAllProjectsFromQuery$default(this.jiraSearchService, applicationUser, query, 0, 4, null));
        }
        Object projectIds = object;
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        log.debug("Getting projects from issues for filter [" + filter.getId() + "] with query [" + filter.getQuery().getQueryString() + "] took " + duration + " ms");
        return projectIds;
    }

    private final SearchRequest getFilterById(long filterId) {
        SearchRequest searchRequest;
        try {
            searchRequest = this.searchRequestManager.getSearchRequestById(Long.valueOf(filterId));
        }
        catch (Exception e) {
            log.error("Failed to get filter with ID: " + filterId, (Throwable)e);
            searchRequest = null;
        }
        return searchRequest;
    }

    public final void clearCache() {
        this.filterToProjectsCache.removeAll();
    }

    private static final Set getProjectsFromFilter$lambda$3$lambda$2(CachedFilterProjectsService this$0, SearchRequest $it) {
        Set<Long> set;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        JQLUtility jQLUtility = this$0.jqlUtility;
        String string = $it.getQuery().getQueryString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQueryString(...)");
        boolean hasDenialClause = jQLUtility.doesJQLHaveProjectDenialClauses(string);
        boolean bl = false;
        if (hasDenialClause) {
            if (this$0.migrationFeatures.getDisableFilterProjectsCollectionReliability()) {
                log.info("Filter with ID: [" + $it.getId() + "] has project denial clauses, but Filter Projects Collection Reliability is disabled, will not fallback to get projects from issues");
                SetsKt.emptySet();
            } else {
                log.info("Filter with ID: [" + $it.getId() + "] has project denial clauses, fallback to get projects from issues");
            }
            set = this$0.getProjectsFromQueryIssues($it);
        } else {
            Set<Long> set2;
            Set<Long> set3 = this$0.getProjectsFromFilterContext($it);
            if (set3.isEmpty()) {
                boolean bl2 = false;
                if (this$0.migrationFeatures.getDisableFilterProjectsCollectionReliability()) {
                    log.info("Filter with ID: [" + $it.getId() + "] has no explicit project context, but Filter Projects Collection Reliability is disabled, will not fallback to get implicit projects from issues");
                    set2 = SetsKt.emptySet();
                } else {
                    log.info("Filter with ID: [" + $it.getId() + "] has no explicit project context, will fallback to get implicit projects from issues");
                    set2 = this$0.getProjectsFromQueryIssues($it);
                }
            } else {
                set2 = set3;
            }
            set = set2;
        }
        return set;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/service/jql/CachedFilterProjectsService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log4jLogger", "Lorg/apache/log4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

