/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.filter.service.jql;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.migration.export.core.filter.service.jql.FilterMappingCache;
import com.atlassian.jira.migration.export.core.filter.service.retrieve.FilterRetrieveService;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000bJ\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService;", "", "filterRetrieveService", "Lcom/atlassian/jira/migration/export/core/filter/service/retrieve/FilterRetrieveService;", "filterMappingCache", "Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterMappingCache;", "(Lcom/atlassian/jira/migration/export/core/filter/service/retrieve/FilterRetrieveService;Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterMappingCache;)V", "collectProjectReferenceInfo", "Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService$JqlProjectReferenceInfo;", "projectIds", "", "", "filter", "Lcom/atlassian/jira/issue/search/SearchRequest;", "filterId", "collectProjectReferenceInfoList", "filterIds", "Companion", "JqlProjectReferenceInfo", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nFilterJqlService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterJqlService.kt\ncom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1#2:55\n1#2:66\n1603#3,9:56\n1855#3:65\n1856#3:67\n1612#3:68\n*S KotlinDebug\n*F\n+ 1 FilterJqlService.kt\ncom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService\n*L\n35#1:66\n35#1:56,9\n35#1:65\n35#1:67\n35#1:68\n*E\n"})
public final class FilterJqlService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FilterRetrieveService filterRetrieveService;
    @NotNull
    private final FilterMappingCache filterMappingCache;
    private static final Logger log = LoggerFactory.getLogger(FilterJqlService.class);

    @Inject
    public FilterJqlService(@NotNull FilterRetrieveService filterRetrieveService, @NotNull FilterMappingCache filterMappingCache) {
        Intrinsics.checkNotNullParameter((Object)filterRetrieveService, (String)"filterRetrieveService");
        Intrinsics.checkNotNullParameter((Object)filterMappingCache, (String)"filterMappingCache");
        this.filterRetrieveService = filterRetrieveService;
        this.filterMappingCache = filterMappingCache;
    }

    @NotNull
    public final JqlProjectReferenceInfo collectProjectReferenceInfo(@NotNull List<Long> projectIds, @NotNull SearchRequest filter) {
        Intrinsics.checkNotNullParameter(projectIds, (String)"projectIds");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Long l = filter.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        List<Long> referringProjectIds = this.filterMappingCache.getReferringProjectIds(((Number)l).longValue());
        Object[] objectArray = new Object[]{filter.getId(), filter.getName(), referringProjectIds, filter.getQuery().getQueryString()};
        log.debug("Filter[{} -  {}] is referring to projects {} with JQL[{}]", objectArray);
        return new JqlProjectReferenceInfo(filter, projectIds, referringProjectIds);
    }

    @Nullable
    public final JqlProjectReferenceInfo collectProjectReferenceInfo(@NotNull List<Long> projectIds, long filterId) {
        JqlProjectReferenceInfo jqlProjectReferenceInfo;
        Intrinsics.checkNotNullParameter(projectIds, (String)"projectIds");
        SearchRequest searchRequest = this.filterRetrieveService.retrieveById(filterId);
        if (searchRequest != null) {
            SearchRequest it = searchRequest;
            boolean bl = false;
            jqlProjectReferenceInfo = this.collectProjectReferenceInfo(projectIds, it);
        } else {
            jqlProjectReferenceInfo = null;
        }
        return jqlProjectReferenceInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JqlProjectReferenceInfo> collectProjectReferenceInfoList(@NotNull List<Long> filterIds) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(filterIds, (String)"filterIds");
        Iterable $this$mapNotNull$iv = filterIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            JqlProjectReferenceInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            long it = ((Number)element$iv$iv).longValue();
            boolean bl2 = false;
            if (this.collectProjectReferenceInfo((List<Long>)CollectionsKt.emptyList(), it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterJqlService$JqlProjectReferenceInfo;", "", "filter", "Lcom/atlassian/jira/issue/search/SearchRequest;", "currentProjectIds", "", "", "referringProjectIds", "(Lcom/atlassian/jira/issue/search/SearchRequest;Ljava/util/List;Ljava/util/List;)V", "getCurrentProjectIds", "()Ljava/util/List;", "getFilter", "()Lcom/atlassian/jira/issue/search/SearchRequest;", "getReferringProjectIds", "isReferringMultiProjects", "", "isReferringToCurrentProjects", "isReferringToSingleProject", "jira-migration-plugin"})
    public static final class JqlProjectReferenceInfo {
        @NotNull
        private final SearchRequest filter;
        @NotNull
        private final List<Long> currentProjectIds;
        @NotNull
        private final List<Long> referringProjectIds;

        public JqlProjectReferenceInfo(@NotNull SearchRequest filter, @NotNull List<Long> currentProjectIds, @NotNull List<Long> referringProjectIds) {
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            Intrinsics.checkNotNullParameter(currentProjectIds, (String)"currentProjectIds");
            Intrinsics.checkNotNullParameter(referringProjectIds, (String)"referringProjectIds");
            this.filter = filter;
            this.currentProjectIds = currentProjectIds;
            this.referringProjectIds = referringProjectIds;
        }

        @NotNull
        public final SearchRequest getFilter() {
            return this.filter;
        }

        @NotNull
        public final List<Long> getCurrentProjectIds() {
            return this.currentProjectIds;
        }

        @NotNull
        public final List<Long> getReferringProjectIds() {
            return this.referringProjectIds;
        }

        public final boolean isReferringMultiProjects() {
            return this.referringProjectIds.size() != 1;
        }

        public final boolean isReferringToSingleProject() {
            return this.referringProjectIds.size() == 1;
        }

        public final boolean isReferringToCurrentProjects() {
            return this.currentProjectIds.containsAll((Collection)this.referringProjectIds);
        }
    }
}

