/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.filter.service.jql;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.migration.export.db.advancedroadmaps.IssueSourceDataReader;
import com.atlassian.jira.migration.jiraservice.JiraSearchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u0015\u001a\u00020\u000bJ\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0007R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterMappingCache;", "", "issueSourceDataReader", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/IssueSourceDataReader;", "searchRequestManager", "Lcom/atlassian/jira/issue/search/SearchRequestManager;", "jiraSearchService", "Lcom/atlassian/jira/migration/jiraservice/JiraSearchService;", "(Lcom/atlassian/jira/migration/export/db/advancedroadmaps/IssueSourceDataReader;Lcom/atlassian/jira/issue/search/SearchRequestManager;Lcom/atlassian/jira/migration/jiraservice/JiraSearchService;)V", "filterIdToReferringProjectIdsMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "pool", "Ljava/util/concurrent/ForkJoinPool;", "createCache", "", "createMapping", "getReferringProjectIds", "filterId", "retrieveReferringProjectIds", "filter", "Lcom/atlassian/jira/issue/search/SearchRequest;", "shutdown", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nFilterMappingCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterMappingCache.kt\ncom/atlassian/jira/migration/export/core/filter/service/jql/FilterMappingCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1549#2:114\n1620#2,3:115\n*S KotlinDebug\n*F\n+ 1 FilterMappingCache.kt\ncom/atlassian/jira/migration/export/core/filter/service/jql/FilterMappingCache\n*L\n67#1:114\n67#1:115,3\n*E\n"})
public final class FilterMappingCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IssueSourceDataReader issueSourceDataReader;
    @NotNull
    private final SearchRequestManager searchRequestManager;
    @NotNull
    private final JiraSearchService jiraSearchService;
    @NotNull
    private final ConcurrentHashMap<Long, List<Long>> filterIdToReferringProjectIdsMap;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @Nullable
    private ForkJoinPool pool;
    private static final Logger log = LoggerFactory.getLogger(FilterMappingCache.class);
    private static final long TERMINATION_CHECK_TIMEOUT = 30L;
    private static final double PROCESSOR_UTILISATION = 0.8;
    private static final int parallelism = Math.max(1, (int)Math.floor((double)Runtime.getRuntime().availableProcessors() * 0.8));

    @Inject
    public FilterMappingCache(@NotNull IssueSourceDataReader issueSourceDataReader, @NotNull SearchRequestManager searchRequestManager, @NotNull JiraSearchService jiraSearchService) {
        Intrinsics.checkNotNullParameter((Object)issueSourceDataReader, (String)"issueSourceDataReader");
        Intrinsics.checkNotNullParameter((Object)searchRequestManager, (String)"searchRequestManager");
        Intrinsics.checkNotNullParameter((Object)jiraSearchService, (String)"jiraSearchService");
        this.issueSourceDataReader = issueSourceDataReader;
        this.searchRequestManager = searchRequestManager;
        this.jiraSearchService = jiraSearchService;
        this.filterIdToReferringProjectIdsMap = new ConcurrentHashMap();
        this.lock = new ReentrantReadWriteLock();
    }

    @PreDestroy
    public final void shutdown() {
        block0: {
            ForkJoinPool forkJoinPool = this.pool;
            if (forkJoinPool == null) break block0;
            forkJoinPool.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Long> getReferringProjectIds(long filterId) {
        this.lock.readLock().lock();
        try {
            List<Long> referringProjects;
            if (this.filterIdToReferringProjectIdsMap.isEmpty()) {
                this.lock.readLock().unlock();
                log.warn("Populating filter to referring project cache during read. This unexpected and should already be populated at this point");
                this.createMapping();
                this.lock.readLock().lock();
            }
            if ((referringProjects = this.filterIdToReferringProjectIdsMap.get(filterId)) == null) {
                log.warn("No entry found for filter id " + filterId + " - defaulting to empty list");
                List list = CollectionsKt.emptyList();
                return list;
            }
            List<Long> list = referringProjects;
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private final List<Long> retrieveReferringProjectIds(SearchRequest filter) {
        return JiraSearchService.getReferencedProjectIdsForSearchRequest$default(this.jiraSearchService, filter, null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void createMapping() {
        this.lock.writeLock().lock();
        try {
            void $this$mapTo$iv$iv;
            this.filterIdToReferringProjectIdsMap.clear();
            Ref.ObjectRef processedCount = new Ref.ObjectRef();
            processedCount.element = new AtomicInteger(0);
            List<Long> filterIds = this.issueSourceDataReader.getAllFilterIds();
            int total = filterIds.size();
            ForkJoinPool forkJoinPool = this.pool = new ForkJoinPool(parallelism);
            Intrinsics.checkNotNull((Object)forkJoinPool);
            ForkJoinPool forkJoinPool2 = forkJoinPool;
            Iterable $this$map$iv = filterIds;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void filterId;
                long l = ((Number)item$iv$iv).longValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                forkJoinPool2.execute(() -> FilterMappingCache.createMapping$lambda$1$lambda$0(this, (long)filterId, processedCount));
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            forkJoinPool2.shutdown();
            while (!forkJoinPool2.awaitTermination(30L, TimeUnit.SECONDS)) {
                log.info("Waiting for completion. Items processed " + ((AtomicInteger)processedCount.element).get() + " out of " + total + " - pool: " + forkJoinPool2);
            }
            log.info("All threads finished executing. Total items processed: " + ((AtomicInteger)processedCount.element).get());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public final void createCache() {
        log.info("Creating filter mapping cache");
        if (this.pool != null) {
            ForkJoinPool forkJoinPool = this.pool;
            Intrinsics.checkNotNull((Object)forkJoinPool);
            if (!forkJoinPool.isTerminated()) {
                log.warn("Filter mapping cache is currently being processed, blocking until terminated");
                ForkJoinPool forkJoinPool2 = this.pool;
                Intrinsics.checkNotNull((Object)forkJoinPool2);
                ForkJoinPool forkJoinPool3 = forkJoinPool2;
                forkJoinPool3.shutdownNow();
                while (!forkJoinPool3.awaitTermination(30L, TimeUnit.SECONDS)) {
                    log.warn("Waiting for pool to terminate " + forkJoinPool3);
                }
            }
        }
        new Thread(() -> FilterMappingCache.createCache$lambda$2(this)).start();
    }

    private static final void createMapping$lambda$1$lambda$0(FilterMappingCache this$0, long $filterId, Ref.ObjectRef $processedCount) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processedCount, (String)"$processedCount");
        try {
            SearchRequest searchRequest = this$0.searchRequestManager.getSearchRequestById(Long.valueOf($filterId));
            Intrinsics.checkNotNull((Object)searchRequest);
            List<Long> referringProjectIds = this$0.retrieveReferringProjectIds(searchRequest);
            Long l = $filterId;
            ((Map)this$0.filterIdToReferringProjectIdsMap).put(l, referringProjectIds);
        }
        catch (Throwable e) {
            log.error("Exception thrown processing filter with id " + $filterId + " - exception: " + e);
        }
        ((AtomicInteger)$processedCount.element).incrementAndGet();
    }

    private static final void createCache$lambda$2(FilterMappingCache this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.createMapping();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterMappingCache$Companion;", "", "()V", "PROCESSOR_UTILISATION", "", "TERMINATION_CHECK_TIMEOUT", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "parallelism", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

