/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.filter.service.jql;

import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.ProjectIssueDataCallback;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.migration.config.JiraSoftwareOnly;
import com.atlassian.jira.migration.export.core.filter.service.jql.FilterProjectsRetrieveService;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Named
@Conditional(value={JiraSoftwareOnly.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u001d\u0010\u0005\u001a\u0004\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterProjectsRetrieveService;", "", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "(Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;)V", "issueDataService", "Lcom/atlassian/greenhopper/service/issue/IssueDataService;", "getIssueDataService", "()Lcom/atlassian/greenhopper/service/issue/IssueDataService;", "issueDataService$delegate", "Lkotlin/Lazy;", "getProjectsFromQueryIssues", "", "", "filter", "Lcom/atlassian/jira/issue/search/SearchRequest;", "Companion", "jira-migration-plugin"})
public final class FilterProjectsRetrieveService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final Lazy issueDataService$delegate;
    private static final org.apache.log4j.Logger log4jLogger = org.apache.log4j.Logger.getLogger(FilterProjectsRetrieveService.class);
    private static final Logger log = LoggerFactory.getLogger(FilterProjectsRetrieveService.class);

    @Inject
    public FilterProjectsRetrieveService(@NotNull JiraThreadLocalUtil jiraThreadLocalUtil) {
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.issueDataService$delegate = LazyKt.lazy((Function0)issueDataService.2.INSTANCE);
    }

    private final IssueDataService getIssueDataService() {
        Lazy lazy = this.issueDataService$delegate;
        return (IssueDataService)lazy.getValue();
    }

    @NotNull
    public final Set<Long> getProjectsFromQueryIssues(@NotNull SearchRequest filter) {
        Object $this$getProjectsFromQueryIssues_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Object object = this;
        try {
            $this$getProjectsFromQueryIssues_u24lambda_u240 = object;
            boolean bl = false;
            ((FilterProjectsRetrieveService)$this$getProjectsFromQueryIssues_u24lambda_u240).jiraThreadLocalUtil.preCall();
            log.debug("Retrieving projects from issues for filter [" + filter.getId() + "] using IssueDataService");
            ProjectIssueDataCallback callback = new ProjectIssueDataCallback();
            IssueDataService issueDataService2 = super.getIssueDataService();
            if (issueDataService2 != null) {
                issueDataService2.findOverrideSecurity(filter.getOwner(), filter.getQuery(), (IssueDataCallback)callback);
            }
            $this$getProjectsFromQueryIssues_u24lambda_u240 = Result.constructor-impl((Object)callback.getProjectIds());
        }
        catch (Throwable bl) {
            $this$getProjectsFromQueryIssues_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$getProjectsFromQueryIssues_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object ex = $this$getProjectsFromQueryIssues_u24lambda_u240 = throwable;
            boolean bl = false;
            log.error("Failed to get projects from issues for filter [" + filter.getId() + ']', (Throwable)ex);
        }
        Object it = object;
        boolean bl = false;
        this.jiraThreadLocalUtil.postCall(log4jLogger);
        Set set = SetsKt.emptySet();
        return (Set)(Result.isFailure-impl((Object)object) ? set : object);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/service/jql/FilterProjectsRetrieveService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log4jLogger", "Lorg/apache/log4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

