/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.export.core.filter.service.retrieve;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestEntity;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.migration.common.PaginatedList;
import com.atlassian.jira.migration.export.core.filter.service.retrieve.FilterRetrieveService;
import com.atlassian.jira.migration.export.db.core.SharedFilterIdsReader;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.EnclosedIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\b0\rH\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\u0006\u0010\u0010\u001a\u00020\u000eJ\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\bJ\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\bH\u0002J\"\u0010\u0017\u001a\u00020\u00182\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001b0\u001a0\bH\u0002J$\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u001e0\u001d2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u001f\u001a\u00020 J$\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u001e0\u001d2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010\u001f\u001a\u00020 J,\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u001e0\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u001f\u001a\u00020 J\u0010\u0010%\u001a\u0004\u0018\u00010\t2\u0006\u0010&\u001a\u00020\u000eJ,\u0010'\u001a\u0004\u0018\u00010\t2\u0006\u0010&\u001a\u00020\u000e2\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001b0\u001a0(H\u0002J\u001a\u0010)\u001a\u00020\u00182\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00180+R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/service/retrieve/FilterRetrieveService;", "", "sharedFilterIdsReader", "Lcom/atlassian/jira/migration/export/db/core/SharedFilterIdsReader;", "searchRequestManager", "Lcom/atlassian/jira/issue/search/SearchRequestManager;", "(Lcom/atlassian/jira/migration/export/db/core/SharedFilterIdsReader;Lcom/atlassian/jira/issue/search/SearchRequestManager;)V", "findAPageOfSharedFiltersForUser", "", "Lcom/atlassian/jira/issue/search/SearchRequest;", "user", "Lcom/atlassian/jira/user/ApplicationUser;", "filterIdsProvider", "Lkotlin/Function0;", "", "getSharedProjectsForFilter", "filterId", "isFilterSharedWithProjects", "", "projectIds", "isInSearchRequestIds", "Lcom/atlassian/jira/sharing/SharedEntityAccessor$RetrievalDescriptor;", "ids", "reportFailedIds", "", "failedIds", "Lkotlin/Pair;", "", "retrieveAllNonProjectSharedFiltersForUser", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/common/PaginatedList;", "pageSize", "", "retrieveAllSharedFiltersForProject", "project", "Lcom/atlassian/jira/project/Project;", "retrieveAllSharedFiltersForProjectAndUser", "retrieveById", "id", "tryGetSearchRequestById", "", "visitAllFilters", "visitor", "Lkotlin/Function1;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nFilterRetrieveService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterRetrieveService.kt\ncom/atlassian/jira/migration/export/core/filter/service/retrieve/FilterRetrieveService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1#2:118\n1747#3,3:119\n*S KotlinDebug\n*F\n+ 1 FilterRetrieveService.kt\ncom/atlassian/jira/migration/export/core/filter/service/retrieve/FilterRetrieveService\n*L\n38#1:119,3\n*E\n"})
public final class FilterRetrieveService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SharedFilterIdsReader sharedFilterIdsReader;
    @NotNull
    private final SearchRequestManager searchRequestManager;
    private static final Logger log = LoggerFactory.getLogger(FilterRetrieveService.class);

    @Inject
    public FilterRetrieveService(@NotNull SharedFilterIdsReader sharedFilterIdsReader, @NotNull SearchRequestManager searchRequestManager) {
        Intrinsics.checkNotNullParameter((Object)sharedFilterIdsReader, (String)"sharedFilterIdsReader");
        Intrinsics.checkNotNullParameter((Object)searchRequestManager, (String)"searchRequestManager");
        this.sharedFilterIdsReader = sharedFilterIdsReader;
        this.searchRequestManager = searchRequestManager;
    }

    @NotNull
    public final Sequence<PaginatedList<SearchRequest>> retrieveAllSharedFiltersForProject(@NotNull Project project, int pageSize) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List failedIds = new ArrayList();
        SharedFilterIdsReader $this$retrieveAllSharedFiltersForProject_u24lambda_u240 = this.sharedFilterIdsReader;
        boolean bl = false;
        Sequence it = sequence = SequencesKt.asSequence(PaginatedList.Companion.fetchByPage(pageSize, (Function2)new Function2<Integer, Integer, Collection<? extends SearchRequest>>($this$retrieveAllSharedFiltersForProject_u24lambda_u240, project, this, (List<Pair<Long, String>>)failedIds){
            final /* synthetic */ SharedFilterIdsReader $this_run;
            final /* synthetic */ Project $project;
            final /* synthetic */ FilterRetrieveService this$0;
            final /* synthetic */ List<Pair<Long, String>> $failedIds;
            {
                this.$this_run = $receiver;
                this.$project = $project;
                this.this$0 = $receiver2;
                this.$failedIds = $failedIds;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Collection<SearchRequest> invoke(int offset, int limit) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = this.$this_run.fetchSharedFilterIdsForProject(this.$project, offset, limit);
                FilterRetrieveService filterRetrieveService = this.this$0;
                List<Pair<Long, String>> list = this.$failedIds;
                boolean $i$f$mapNotNull = false;
                void var7_7 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    SearchRequest it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    long id = ((Number)element$iv$iv).longValue();
                    boolean bl2 = false;
                    if (FilterRetrieveService.access$tryGetSearchRequestById(filterRetrieveService, id, list) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }));
        boolean bl2 = false;
        if (!((Collection)failedIds).isEmpty()) {
            this.reportFailedIds(failedIds);
        }
        return sequence;
    }

    public static /* synthetic */ Sequence retrieveAllSharedFiltersForProject$default(FilterRetrieveService filterRetrieveService, Project project, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 50;
        }
        return filterRetrieveService.retrieveAllSharedFiltersForProject(project, n);
    }

    public final boolean isFilterSharedWithProjects(long filterId, @NotNull List<Long> projectIds) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(projectIds, (String)"projectIds");
            SharedFilterIdsReader $this$isFilterSharedWithProjects_u24lambda_u243 = this.sharedFilterIdsReader;
            boolean bl2 = false;
            Iterable $this$any$iv = $this$isFilterSharedWithProjects_u24lambda_u243.fetchSharedProjectsForFilter(filterId);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    long it = ((Number)element$iv).longValue();
                    boolean bl3 = false;
                    if (!projectIds.contains(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final List<Long> getSharedProjectsForFilter(long filterId) {
        SharedFilterIdsReader $this$getSharedProjectsForFilter_u24lambda_u244 = this.sharedFilterIdsReader;
        boolean bl = false;
        return $this$getSharedProjectsForFilter_u24lambda_u244.fetchSharedProjectsForFilter(filterId);
    }

    public final void visitAllFilters(@NotNull Function1<? super SearchRequest, Unit> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        List failedIds = new ArrayList();
        this.searchRequestManager.visitAll(arg_0 -> FilterRetrieveService.visitAllFilters$lambda$5(this, failedIds, visitor, arg_0));
        if (!((Collection)failedIds).isEmpty()) {
            this.reportFailedIds(failedIds);
        }
    }

    private final SearchRequest tryGetSearchRequestById(long id, List<Pair<Long, String>> failedIds) {
        SearchRequest searchRequest;
        try {
            searchRequest = this.searchRequestManager.getSearchRequestById(Long.valueOf(id));
        }
        catch (Exception e) {
            Long l = id;
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            failedIds.add((Pair<Long, String>)TuplesKt.to((Object)l, (Object)string));
            searchRequest = null;
        }
        return searchRequest;
    }

    private final void reportFailedIds(List<Pair<Long, String>> failedIds) {
        String errorMessage2 = CollectionsKt.joinToString$default((Iterable)failedIds, (CharSequence)"\n", null, null, (int)0, null, (Function1)reportFailedIds.errorMessage.1.INSTANCE, (int)30, null);
        throw new Exception("Failed to get the following filters:\n" + errorMessage2);
    }

    @NotNull
    public final Sequence<PaginatedList<SearchRequest>> retrieveAllNonProjectSharedFiltersForUser(@NotNull ApplicationUser user, int pageSize) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        SharedFilterIdsReader $this$retrieveAllNonProjectSharedFiltersForUser_u24lambda_u246 = this.sharedFilterIdsReader;
        boolean bl = false;
        return SequencesKt.asSequence(PaginatedList.Companion.fetchByPage(pageSize, (Function2)new Function2<Integer, Integer, Collection<? extends SearchRequest>>(this, user, $this$retrieveAllNonProjectSharedFiltersForUser_u24lambda_u246){
            final /* synthetic */ FilterRetrieveService this$0;
            final /* synthetic */ ApplicationUser $user;
            final /* synthetic */ SharedFilterIdsReader $this_run;
            {
                this.this$0 = $receiver;
                this.$user = $user;
                this.$this_run = $receiver2;
                super(2);
            }

            @NotNull
            public final Collection<SearchRequest> invoke(int offset, int limit) {
                return FilterRetrieveService.access$findAPageOfSharedFiltersForUser(this.this$0, this.$user, (Function0)new Function0<List<? extends Long>>(this.$this_run, offset, limit){
                    final /* synthetic */ SharedFilterIdsReader $this_run;
                    final /* synthetic */ int $offset;
                    final /* synthetic */ int $limit;
                    {
                        this.$this_run = $receiver;
                        this.$offset = $offset;
                        this.$limit = $limit;
                        super(0);
                    }

                    @NotNull
                    public final List<Long> invoke() {
                        return this.$this_run.fetchNonProjectSharedFilterIds(this.$offset, this.$limit);
                    }
                });
            }
        }));
    }

    public static /* synthetic */ Sequence retrieveAllNonProjectSharedFiltersForUser$default(FilterRetrieveService filterRetrieveService, ApplicationUser applicationUser, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 50;
        }
        return filterRetrieveService.retrieveAllNonProjectSharedFiltersForUser(applicationUser, n);
    }

    @NotNull
    public final Sequence<PaginatedList<SearchRequest>> retrieveAllSharedFiltersForProjectAndUser(@NotNull Project project, @NotNull ApplicationUser user, int pageSize) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        SharedFilterIdsReader $this$retrieveAllSharedFiltersForProjectAndUser_u24lambda_u247 = this.sharedFilterIdsReader;
        boolean bl = false;
        return SequencesKt.asSequence(PaginatedList.Companion.fetchByPage(pageSize, (Function2)new Function2<Integer, Integer, Collection<? extends SearchRequest>>(this, user, $this$retrieveAllSharedFiltersForProjectAndUser_u24lambda_u247, project){
            final /* synthetic */ FilterRetrieveService this$0;
            final /* synthetic */ ApplicationUser $user;
            final /* synthetic */ SharedFilterIdsReader $this_run;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$user = $user;
                this.$this_run = $receiver2;
                this.$project = $project;
                super(2);
            }

            @NotNull
            public final Collection<SearchRequest> invoke(int offset, int limit) {
                return FilterRetrieveService.access$findAPageOfSharedFiltersForUser(this.this$0, this.$user, (Function0)new Function0<List<? extends Long>>(this.$this_run, this.$project, offset, limit){
                    final /* synthetic */ SharedFilterIdsReader $this_run;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ int $offset;
                    final /* synthetic */ int $limit;
                    {
                        this.$this_run = $receiver;
                        this.$project = $project;
                        this.$offset = $offset;
                        this.$limit = $limit;
                        super(0);
                    }

                    @NotNull
                    public final List<Long> invoke() {
                        return this.$this_run.fetchSharedFilterIdsForProject(this.$project, this.$offset, this.$limit);
                    }
                });
            }
        }));
    }

    public static /* synthetic */ Sequence retrieveAllSharedFiltersForProjectAndUser$default(FilterRetrieveService filterRetrieveService, Project project, ApplicationUser applicationUser, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 50;
        }
        return filterRetrieveService.retrieveAllSharedFiltersForProjectAndUser(project, applicationUser, n);
    }

    @Nullable
    public final SearchRequest retrieveById(long id) {
        SearchRequest searchRequest;
        try {
            searchRequest = this.searchRequestManager.getSearchRequestById(Long.valueOf(id));
        }
        catch (Exception e) {
            log.error("Failed to get filter with ID: " + id, (Throwable)e);
            searchRequest = null;
        }
        return searchRequest;
    }

    private final List<SearchRequest> findAPageOfSharedFiltersForUser(ApplicationUser user, Function0<? extends List<Long>> filterIdsProvider) {
        List list;
        List it = list = EnclosedIterable.Functions.toList((EnclosedIterable)this.searchRequestManager.getSearchRequests(user, this.isInSearchRequestIds((List)filterIdsProvider.invoke())));
        boolean bl = false;
        log.info("Found a page of " + it.size() + " shared filters");
        List list2 = list;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"also(...)");
        return list2;
    }

    private final SharedEntityAccessor.RetrievalDescriptor isInSearchRequestIds(List<Long> ids) {
        return new SharedEntityAccessor.RetrievalDescriptor(ids){
            final /* synthetic */ List<Long> $ids;
            {
                this.$ids = $ids;
            }

            @NotNull
            public List<Long> getIds() {
                return this.$ids;
            }

            public boolean preserveOrder() {
                return true;
            }
        };
    }

    private static final void visitAllFilters$lambda$5(FilterRetrieveService this$0, List $failedIds, Function1 $visitor, SearchRequestEntity filter) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$failedIds, (String)"$failedIds");
            Intrinsics.checkNotNullParameter((Object)$visitor, (String)"$visitor");
            Long l = filter.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            SearchRequest searchRequest = this$0.tryGetSearchRequestById(((Number)l).longValue(), $failedIds);
            if (searchRequest == null) break block0;
            $visitor.invoke((Object)searchRequest);
        }
    }

    public static final /* synthetic */ SearchRequest access$tryGetSearchRequestById(FilterRetrieveService $this, long id, List failedIds) {
        return $this.tryGetSearchRequestById(id, failedIds);
    }

    public static final /* synthetic */ List access$findAPageOfSharedFiltersForUser(FilterRetrieveService $this, ApplicationUser user, Function0 filterIdsProvider) {
        return $this.findAPageOfSharedFiltersForUser(user, (Function0<? extends List<Long>>)filterIdsProvider);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/export/core/filter/service/retrieve/FilterRetrieveService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

